/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import fm.icelink.stun.Attribute;

public class ErrorCodeAttribute
extends Attribute {
    private int __code;
    private String __reason;

    public ErrorCodeAttribute(int code) {
        this(code, null);
    }

    public ErrorCodeAttribute(int code, String reason) {
        this.setCode(code);
        this.setReason(reason != null ? reason : "");
    }

    private ErrorCodeAttribute() {
    }

    public int getCode() {
        return this.__code;
    }

    public String getReason() {
        return this.__reason;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getErrorCodeType();
    }

    @Override
    protected int getValueLength() {
        return 4 + Utf8.getByteCount(this.getReason());
    }

    public static ErrorCodeAttribute readValueFrom(DataBuffer buffer, int offset, int length) {
        IntegerHolder _var0 = new IntegerHolder(offset += 2);
        int _var1 = buffer.read8(offset, _var0);
        offset = _var0.getValue();
        int num = _var1;
        IntegerHolder _var2 = new IntegerHolder(offset);
        int _var3 = buffer.read8(offset, _var2);
        offset = _var2.getValue();
        int num2 = _var3;
        String str = Utf8.decode(buffer.getData(), buffer.getIndex() + offset, length).trim();
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setCode(num * 100 + num2);
        attribute.setReason(str);
        return attribute;
    }

    public void setCode(int value) {
        if (value < 300 || value > 699) {
            throw new RuntimeException(new Exception("code must be in the range of 300 to 699."));
        }
        this.__code = value;
    }

    public void setReason(String value) {
        if (StringExtensions.getLength(value) > 127) {
            throw new RuntimeException(new Exception("reason must have fewer than 128 characters."));
        }
        this.__reason = value;
    }

    public String toString() {
        return StringExtensions.format("ERROR-CODE {0} {1}", IntegerExtensions.toString(this.getCode()), this.getReason());
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        IntegerHolder _var0 = new IntegerHolder(offset);
        boolean _var1 = buffer.write16(0, offset, _var0);
        offset = _var0.getValue();
        IntegerHolder _var2 = new IntegerHolder(offset);
        boolean _var3 = buffer.write8(this.getCode() / 100, offset, _var2);
        offset = _var2.getValue();
        IntegerHolder _var4 = new IntegerHolder(offset);
        boolean _var5 = buffer.write8(this.getCode() % 100, offset, _var4);
        offset = _var4.getValue();
        buffer.writeBytes(Utf8.encode(this.getReason()), offset);
    }
}

