/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ByteExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;

public class QualityAttribute
extends Attribute {
    private byte _quality;

    public static QualityAttribute fromAttributeValue(String value) {
        QualityAttribute attribute = new QualityAttribute();
        attribute.setQuality(ParseAssistant.parseByteValue(value));
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        return ByteExtensions.toString(this.getQuality());
    }

    public byte getQuality() {
        return this._quality;
    }

    private QualityAttribute() {
        super.setAttributeType(AttributeType.QualityAttribute);
    }

    public QualityAttribute(byte quality) {
        super.setAttributeType(AttributeType.QualityAttribute);
        if (quality < 0 || quality > 10) {
            throw new RuntimeException(new Exception("quality must be a value in the range 0 to 10."));
        }
        this.setQuality(quality);
    }

    private void setQuality(byte value) {
        this._quality = value;
    }
}

