/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.HashMapExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Block;
import fm.icelink.matroska.BlockGroup;
import fm.icelink.matroska.Cluster;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.SeekHead;
import fm.icelink.matroska.SegmentInfo;
import fm.icelink.matroska.SimpleBlock;
import fm.icelink.matroska.Track;
import fm.icelink.matroska.TrackEntry;
import java.util.ArrayList;
import java.util.HashMap;

public class Segment
extends Element {
    private Cluster[] _clusters;
    private SeekHead[] _seekHeads;
    private SegmentInfo _segmentInfo;
    private Track[] _tracks;

    public Cluster[] getClusters() {
        return this._clusters;
    }

    public static byte[] getEbmlId() {
        return new byte[]{24, 83, -128, 103};
    }

    @Override
    public byte[] getId() {
        return Segment.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (this.getSegmentInfo() != null) {
            stream.writeBuffer(this.getSegmentInfo().getBytes());
        }
        if (this.getSeekHeads() != null) {
            for (Element element : this.getSeekHeads()) {
                stream.writeBuffer(element.getBytes());
            }
        }
        if (this.getTracks() != null) {
            for (Element element : this.getTracks()) {
                stream.writeBuffer(element.getBytes());
            }
        }
        if (this.getClusters() != null) {
            for (Element element : this.getClusters()) {
                stream.writeBuffer(element.getBytes());
            }
        }
        return stream.toArray();
    }

    public SeekHead[] getSeekHeads() {
        return this._seekHeads;
    }

    public SegmentInfo getSegmentInfo() {
        return this._segmentInfo;
    }

    public Track[] getTracks() {
        return this._tracks;
    }

    public void merge(Segment segment) {
        if (segment != null) {
            if (this.getSegmentInfo() == null) {
                this.setSegmentInfo(segment.getSegmentInfo());
            } else {
                this.getSegmentInfo().merge(segment.getSegmentInfo());
            }
            if (this.getSeekHeads() == null) {
                this.setSeekHeads(segment.getSeekHeads());
            } else if (segment.getSeekHeads() != null) {
                ArrayList list = new ArrayList();
                ArrayListExtensions.addRange(list, this.getSeekHeads());
                ArrayListExtensions.addRange(list, segment.getSeekHeads());
                this.setSeekHeads(list.toArray(new SeekHead[0]));
            }
            HashMap<String, Long> trackNumberMap = null;
            HashMap<String, Long> dictionary2 = null;
            ArrayList<Long> usedTrackUids = null;
            if (this.getTracks() == null) {
                this.setTracks(segment.getTracks());
            } else if (segment.getTracks() != null) {
                long trackNumberIndex = 1L;
                trackNumberMap = new HashMap<String, Long>();
                dictionary2 = new HashMap<String, Long>();
                usedTrackUids = new ArrayList<Long>();
                trackNumberIndex = this.updateTracks(this.getTracks(), trackNumberMap, trackNumberIndex, usedTrackUids);
                trackNumberIndex = this.updateTracks(segment.getTracks(), dictionary2, trackNumberIndex, usedTrackUids);
                ArrayList<Track> list3 = new ArrayList<Track>();
                ArrayListExtensions.addRange(list3, this.getTracks());
                int index = 0;
                for (Track track : segment.getTracks()) {
                    if (index < ArrayExtensions.getLength(this.getTracks())) {
                        this.getTracks()[index].merge(track);
                    } else {
                        list3.add(track);
                    }
                    ++index;
                }
                this.setTracks(list3.toArray(new Track[0]));
            }
            if (this.getClusters() == null) {
                this.setClusters(segment.getClusters());
            } else if (segment.getClusters() != null) {
                if (trackNumberMap != null) {
                    this.updateClusters(this.getClusters(), trackNumberMap);
                }
                if (dictionary2 != null) {
                    this.updateClusters(segment.getClusters(), dictionary2);
                }
                ArrayList<Cluster> list4 = new ArrayList<Cluster>();
                ArrayListExtensions.addRange(list4, this.getClusters());
                int num3 = 0;
                for (Cluster cluster : segment.getClusters()) {
                    if (num3 < ArrayExtensions.getLength(this.getClusters())) {
                        this.getClusters()[num3].merge(cluster);
                    } else {
                        list4.add(cluster);
                    }
                    ++num3;
                }
                this.setClusters(list4.toArray(new Cluster[0]));
            }
        }
    }

    public Segment() {
    }

    public Segment(byte[] bytes) {
        this();
        ArrayList<SeekHead> list = new ArrayList<SeekHead>();
        ArrayList<Track> list2 = new ArrayList<Track>();
        ArrayList<Cluster> list3 = new ArrayList<Cluster>();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, SegmentInfo.getEbmlId())) {
                this.setSegmentInfo(new SegmentInfo(buffer2));
                continue;
            }
            if (Element.compare(buffer, SeekHead.getEbmlId())) {
                list.add(new SeekHead(buffer2));
                continue;
            }
            if (Element.compare(buffer, Track.getEbmlId())) {
                list2.add(new Track(buffer2));
                continue;
            }
            if (Element.compare(buffer, Cluster.getEbmlId())) {
                list3.add(new Cluster(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaSegment: ", BitAssistant.getHexString(buffer)));
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            this.setSeekHeads(list.toArray(new SeekHead[0]));
        }
        if (ArrayListExtensions.getCount(list2) > 0) {
            this.setTracks(list2.toArray(new Track[0]));
        }
        if (ArrayListExtensions.getCount(list3) > 0) {
            this.setClusters(list3.toArray(new Cluster[0]));
        }
    }

    public void setClusters(Cluster[] value) {
        this._clusters = value;
    }

    public void setSeekHeads(SeekHead[] value) {
        this._seekHeads = value;
    }

    public void setSegmentInfo(SegmentInfo value) {
        this._segmentInfo = value;
    }

    public void setTracks(Track[] value) {
        this._tracks = value;
    }

    private void updateClusters(Cluster[] clusters, HashMap<String, Long> trackNumberMap) {
        for (Cluster cluster : clusters) {
            SimpleBlock[] simpleBlocks;
            String str;
            BlockGroup[] blockGroups = cluster.getBlockGroups();
            if (blockGroups != null) {
                for (BlockGroup group : blockGroups) {
                    Block block = group.getBlock();
                    if (block == null || !trackNumberMap.containsKey(str = LongExtensions.toString(block.getTrackNumber()))) continue;
                    block.setTrackNumber(HashMapExtensions.getItem(trackNumberMap).get(str));
                }
            }
            if ((simpleBlocks = cluster.getSimpleBlocks()) == null) continue;
            for (SimpleBlock block2 : simpleBlocks) {
                str = LongExtensions.toString(block2.getTrackNumber());
                if (!trackNumberMap.containsKey(str)) continue;
                block2.setTrackNumber(HashMapExtensions.getItem(trackNumberMap).get(str));
            }
        }
    }

    private long updateTracks(Track[] tracks, HashMap<String, Long> trackNumberMap, long trackNumberIndex, ArrayList<Long> usedTrackUids) {
        for (Track track : tracks) {
            for (TrackEntry entry : track.getTrackEntries()) {
                HashMapExtensions.set(HashMapExtensions.getItem(trackNumberMap), LongExtensions.toString(entry.getTrackNumber()), trackNumberIndex);
                entry.setTrackNumber(trackNumberIndex);
                ++trackNumberIndex;
                while (usedTrackUids.contains(entry.getTrackUid())) {
                    entry.setTrackUid(LockedRandomizer.nextLong());
                }
                usedTrackUids.add(entry.getTrackUid());
            }
        }
        return trackNumberIndex;
    }
}

