/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1Sequence;
import fm.icelink.BitAssistant;
import fm.icelink.Global;

class X509RsaPublicKey {
    private byte[] __exponent = null;
    private byte[] __modulus = null;

    public static X509RsaPublicKey fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) != 2) {
            return null;
        }
        X509RsaPublicKey key = new X509RsaPublicKey();
        key.setModulus(((Asn1Integer)sequence.getValues()[0]).getValue());
        key.setExponent(((Asn1Integer)sequence.getValues()[1]).getValue());
        return key;
    }

    public byte[] getExponent() {
        return this.__exponent;
    }

    public byte[] getModulus() {
        return X509RsaPublicKey.trim(this.__modulus);
    }

    private static byte[] lengthen(byte[] block) {
        if (ArrayExtensions.getLength(block) % 2 == 0) {
            byte[] destination = new byte[ArrayExtensions.getLength(block) + 1];
            destination[0] = 0;
            BitAssistant.copy(block, 0, destination, 1, ArrayExtensions.getLength(block));
            block = destination;
        }
        return block;
    }

    public void setExponent(byte[] value) {
        this.__exponent = value;
    }

    public void setModulus(byte[] value) {
        this.__modulus = X509RsaPublicKey.lengthen(value);
    }

    public Asn1Sequence toAsn1() {
        return new Asn1Sequence(new Asn1Any[]{new Asn1Integer(this.__modulus), new Asn1Integer(this.__exponent)});
    }

    private static byte[] trim(byte[] block) {
        if (ArrayExtensions.getLength(block) % 2 == 1 && block[0] == 0) {
            block = BitAssistant.subArray(block, 1);
        }
        return block;
    }

    public X509RsaPublicKey() {
    }

    public X509RsaPublicKey(byte[] modulus, byte[] exponent) {
        this.setModulus(modulus);
        this.setExponent(exponent);
    }
}

