/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BooleanHolder;
import fm.icelink.ByteCollection;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.DatagramSocket;
import fm.icelink.DatagramSocketCreateArgs;
import fm.icelink.Dynamic;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IntegerHolder;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.ManagedSocket;
import fm.icelink.ServerAddress;
import fm.icelink.StreamSocket;
import fm.icelink.StreamSocketCreateArgs;
import fm.icelink.StringExtensions;
import fm.icelink.TcpSocket;
import fm.icelink.TransportAddress;
import fm.icelink.TurnTcpConnection;
import fm.icelink.UdpSocket;
import fm.icelink.Utility;
import fm.icelink.stun.BindingRequest;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.Error;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageType;
import fm.icelink.stun.ServerError;
import fm.icelink.stun.XorMappedAddressAttribute;
import java.util.ArrayList;
import java.util.HashMap;

public class StunServer
extends Dynamic {
    private int __socketFailuresCount = 0;
    private Object __socketFailuresLock;
    private int __socketFailuresThreshold = 5;
    private Object __startedLock = new Object();
    private int __streamSendTimeout = -1;
    private IFunction1<DatagramSocketCreateArgs, DatagramSocket> _createDatagramSocket;
    private IFunction1<StreamSocketCreateArgs, StreamSocket> _createStreamSocket;
    private boolean _disableTcp;
    private boolean _disableUdp;
    private volatile boolean _started = false;
    private HashMap<String, TurnTcpConnection> _tcpConnections;
    private Object _tcpConnectionsLock;
    private StreamSocket[] _tcpSockets = null;
    private DatagramSocket[] _udpSockets = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTcpConnection(TurnTcpConnection connection) {
        Object object = this._tcpConnectionsLock;
        synchronized (object) {
            HashMapExtensions.add(this._tcpConnections, connection.getId(), connection);
        }
    }

    protected Message createErrorResponse(Message request, TransportAddress remoteAddress, String errorMessage) {
        ServerError error = new ServerError(errorMessage);
        return this.createExceptionResponse(request, remoteAddress, error);
    }

    protected Message createExceptionResponse(Message request, TransportAddress remoteAddress, Error error) {
        Message message = Message.createMessage(request.getMethod(), MessageType.ErrorResponse, request.getTransactionId());
        int stunErrorCode = error.getStunErrorCode();
        if (stunErrorCode == 0) {
            if (Log.getIsErrorEnabled()) {
                Log.error(StringExtensions.format("An System.Exception occurred while processing request from {0}: {1}", remoteAddress.toString(), error.getMessage()));
            }
            stunErrorCode = 500;
        }
        message.setErrorCode(new ErrorCodeAttribute(stunErrorCode, this.getReason(stunErrorCode)));
        return message;
    }

    private <T> ArrayList<T> createServerSockets(boolean udp, ServerAddress[] addresses, IFunction1<ServerAddress, T> createSocket) {
        String str = udp ? "[UDP] " : "[TCP] ";
        ArrayList<T> list = new ArrayList<T>();
        if (ArrayExtensions.getLength(addresses) == 0) {
            Log.error(StringExtensions.format("{0}No local addresses found.", str));
            return list;
        }
        for (ServerAddress address : addresses) {
            try {
                list.add(createSocket.invoke(address));
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("{0}Could not create socket on {1}.", str, address.toString()), exception);
            }
        }
        if (ArrayListExtensions.getCount(list) == 0) {
            Log.fatal(StringExtensions.format("{0}Could not create any sockets.", str));
            return list;
        }
        return list;
    }

    private StreamSocket createTcpSocket(ServerAddress address) {
        boolean addressInUse = false;
        boolean server = true;
        boolean flag3 = Global.equals((Object)LocalNetwork.getAddressType(address.getIPAddress()), (Object)AddressType.IPv6);
        boolean secure = false;
        ManagedSocket socket = null;
        if (this.getCreateStreamSocket() != null) {
            socket = this.getCreateStreamSocket().invoke(new StreamSocketCreateArgs(server, flag3, secure));
        }
        if (socket == null) {
            socket = new TcpSocket(server, flag3, secure);
        }
        socket.setPublicIPAddress(address.getPublicIPAddress());
        BooleanHolder _var0 = new BooleanHolder(addressInUse);
        boolean _var1 = socket.bind(address.getIPAddress(), address.getPort(), _var0);
        addressInUse = _var0.getValue();
        if (_var1) {
            return socket;
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (addressInUse) {
            throw new RuntimeException(new Exception("TCP socket address is in use."));
        }
        throw new RuntimeException(new Exception("TCP socket bind failed."));
    }

    private DatagramSocket createUdpSocket(ServerAddress address) {
        boolean addressInUse = false;
        boolean flag2 = Global.equals((Object)LocalNetwork.getAddressType(address.getIPAddress()), (Object)AddressType.IPv6);
        ManagedSocket socket = null;
        if (this.getCreateDatagramSocket() != null) {
            socket = this.getCreateDatagramSocket().invoke(new DatagramSocketCreateArgs(flag2));
        }
        if (socket == null) {
            socket = new UdpSocket(flag2);
        }
        socket.setPublicIPAddress(address.getPublicIPAddress());
        BooleanHolder _var0 = new BooleanHolder(addressInUse);
        boolean _var1 = socket.bind(address.getIPAddress(), address.getPort(), _var0);
        addressInUse = _var0.getValue();
        if (_var1) {
            return socket;
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (addressInUse) {
            throw new RuntimeException(new Exception("UDP socket address is in use."));
        }
        throw new RuntimeException(new Exception("UDP socket bind failed."));
    }

    private void doTcpAccept(StreamSocket tcpSocket) {
        if (!tcpSocket.getIsClosed()) {
            this.tcpAccept(tcpSocket);
        }
    }

    private void doUdpReceive(DatagramSocket udpSocket) {
        if (udpSocket == null || !udpSocket.getIsClosed()) {
            this.udpReceive(udpSocket);
        }
    }

    public IFunction1<DatagramSocketCreateArgs, DatagramSocket> getCreateDatagramSocket() {
        return this._createDatagramSocket;
    }

    public IFunction1<StreamSocketCreateArgs, StreamSocket> getCreateStreamSocket() {
        return this._createStreamSocket;
    }

    private ServerAddress[] getDefaultAddresses() {
        ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
        for (String str : LocalNetwork.getIPAddresses(new AddressType[]{AddressType.IPv4, AddressType.IPv6}, true)) {
            list.add(new ServerAddress(str, 3478));
        }
        return list.toArray(new ServerAddress[0]);
    }

    public boolean getDisableTcp() {
        return this._disableTcp;
    }

    public boolean getDisableUdp() {
        return this._disableUdp;
    }

    protected String getLabel() {
        return "STUN";
    }

    public ServerAddress getLocalTcpAddress() {
        return Utility.firstOrDefault(this.getLocalTcpAddresses());
    }

    public ServerAddress[] getLocalTcpAddresses() {
        Object[] tcpSockets = this._tcpSockets;
        ServerAddress[] addressArray = new ServerAddress[ArrayExtensions.getLength(tcpSockets)];
        for (int i = 0; i < ArrayExtensions.getLength(tcpSockets); ++i) {
            addressArray[i] = new ServerAddress(((ManagedSocket)tcpSockets[i]).getLocalIPAddress(), ((ManagedSocket)tcpSockets[i]).getLocalPort(), ((ManagedSocket)tcpSockets[i]).getPublicIPAddress());
        }
        return addressArray;
    }

    public ServerAddress getLocalUdpAddress() {
        return Utility.firstOrDefault(this.getLocalUdpAddresses());
    }

    public ServerAddress[] getLocalUdpAddresses() {
        Object[] udpSockets = this._udpSockets;
        ServerAddress[] addressArray = new ServerAddress[ArrayExtensions.getLength(udpSockets)];
        for (int i = 0; i < ArrayExtensions.getLength(udpSockets); ++i) {
            addressArray[i] = new ServerAddress(((ManagedSocket)udpSockets[i]).getLocalIPAddress(), ((ManagedSocket)udpSockets[i]).getLocalPort(), ((ManagedSocket)udpSockets[i]).getPublicIPAddress());
        }
        return addressArray;
    }

    private String getReason(int errorCode) {
        int _var0 = errorCode;
        if (_var0 == 400) {
            return "Bad Request";
        }
        if (_var0 == 401) {
            return "Unauthorized";
        }
        if (_var0 == 403) {
            return "Forbidden";
        }
        if (_var0 == 404) {
            return "Not Found";
        }
        if (_var0 == 420) {
            return "Unknown Attribute";
        }
        if (_var0 == 300) {
            return "Try Alternate";
        }
        if (_var0 == 500) {
            return "Server Error";
        }
        if (_var0 == 508) {
            return "Insufficient Capacity";
        }
        if (_var0 == 437) {
            return "Allocation Mismatch";
        }
        if (_var0 == 438) {
            return "Stale Nonce";
        }
        if (_var0 == 441) {
            return "Wrong Credentials";
        }
        if (_var0 == 442) {
            return "Unsupported Transport Protocol";
        }
        if (_var0 == 446) {
            return "Connection Already Exists";
        }
        if (_var0 == 447) {
            return "Connection Timeout or Failure";
        }
        if (_var0 == 486) {
            return "Allocation Quote Reached";
        }
        if (_var0 == 487) {
            return "Role Conflict";
        }
        return null;
    }

    public int getStreamSendTimeout() {
        return this.__streamSendTimeout;
    }

    private void logSocket(boolean udp, ServerAddress address) {
        String str;
        String string = str = udp ? "[UDP] " : "[TCP] ";
        if (Log.getIsInfoEnabled()) {
            if (TransportAddress.isPrivate(address.getIPAddress())) {
                if (StringExtensions.isNullOrEmpty(address.getPublicIPAddress())) {
                    Log.warn(StringExtensions.format("{0}{1} server listening on private address {2} with no public IP specified. Server may not behave as expected.", str, this.getLabel(), address.toString()));
                } else {
                    Log.info(StringExtensions.format("{0}{1} server listening on private address {2} with public IP {3}. A 1:1 NAT is required.", new Object[]{str, this.getLabel(), address.toString(), address.getPublicIPAddress()}));
                }
            } else {
                Log.info(StringExtensions.format("{0}{1} server listening on public address {2}.", str, this.getLabel(), address.toString()));
            }
        }
    }

    protected Message process(Message request, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress) {
        Message message;
        block5: {
            String str = tcpServerSocket == null ? "[UDP] " : "[TCP] ";
            String str2 = StringExtensions.empty;
            message = null;
            try {
                if (!(request instanceof BindingRequest)) {
                    return message;
                }
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processing UDP binding request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
                message = this.processBindingRequest((BindingRequest)request, remoteAddress);
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processed UDP binding request from {1}{2}.", str, remoteAddress.toString(), str2));
                }
            }
            catch (Exception exception) {
                if (Global.equals((Object)request.getMessageType(), (Object)MessageType.Indication)) break block5;
                message = this.createErrorResponse(request, remoteAddress, exception.getMessage());
            }
        }
        return message;
    }

    private BindingResponse processBindingRequest(BindingRequest request, TransportAddress remoteAddress) {
        BindingResponse response = new BindingResponse(request.getTransactionId(), true);
        response.setXorMappedAddress(new XorMappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort(), request.getTransactionId()));
        response.setMappedAddress(new MappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort()));
        return response;
    }

    protected boolean processBuffer(DataBuffer buffer, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress, IntegerHolder readLength) {
        int length = 0;
        IntegerHolder _var0 = new IntegerHolder(length);
        Message _var1 = Message.readFrom(buffer, 0, _var0);
        length = _var0.getValue();
        Message request = _var1;
        if (request != null) {
            readLength.setValue(length);
            Message message2 = this.process(request, udpServerSocket, tcpServerSocket, localAddress, remoteAddress);
            if (message2 != null) {
                DataBuffer buffer2 = DataBufferPool.getInstance().take(message2.getLength());
                message2.writeTo(buffer2, 0);
                if (udpServerSocket != null) {
                    udpServerSocket.send(buffer2, remoteAddress.getIPAddress(), remoteAddress.getPort());
                } else {
                    tcpServerSocket.sendAsync(buffer2, this.__streamSendTimeout, null, null);
                }
                buffer2.free();
            }
            return true;
        }
        readLength.setValue(0);
        return false;
    }

    private void processTcpConnectionReceive(TurnTcpConnection connection, ByteCollection receiveBuffer) {
        do {
            int readLength = 0;
            IntegerHolder _var0 = new IntegerHolder(readLength);
            boolean _var1 = this.processBuffer(DataBuffer.wrap(receiveBuffer.toArray()), null, connection.getSocket(), connection.getServerAddress(), connection.getClientAddress(), _var0);
            readLength = _var0.getValue();
            if (!_var1) {
                return;
            }
            receiveBuffer.removeRange(0, readLength);
        } while (receiveBuffer.getCount() != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTcpConnection(TurnTcpConnection connection) {
        Object object = this._tcpConnectionsLock;
        synchronized (object) {
            HashMapExtensions.remove(this._tcpConnections, connection.getId());
            try {
                if (!connection.getIsClosed()) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTcpConnections() {
        Object object = this._tcpConnectionsLock;
        synchronized (object) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : HashMapExtensions.getKeys(this._tcpConnections)) {
                list.add(str);
            }
            for (String str : list) {
                this.removeTcpConnection(HashMapExtensions.getItem(this._tcpConnections).get(str));
            }
        }
    }

    public void setCreateDatagramSocket(IFunction1<DatagramSocketCreateArgs, DatagramSocket> value) {
        this._createDatagramSocket = value;
    }

    public void setCreateStreamSocket(IFunction1<StreamSocketCreateArgs, StreamSocket> value) {
        this._createStreamSocket = value;
    }

    public void setDisableTcp(boolean value) {
        this._disableTcp = value;
    }

    public void setDisableUdp(boolean value) {
        this._disableUdp = value;
    }

    public void setStreamSendTimeout(int value) {
        if (value >= -1) {
            this.__streamSendTimeout = value;
        }
    }

    public boolean start(ServerAddress[] udpAddresses) {
        return this.start(udpAddresses, null);
    }

    public boolean start() {
        return this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(ServerAddress[] udpAddresses, ServerAddress[] tcpAddresses) {
        if (this.getDisableUdp() && this.getDisableTcp()) {
            throw new RuntimeException(new Exception("Cannot start server. Both UDP and TCP are disabled."));
        }
        ManagedSocket[] managedSocketArray = this.__startedLock;
        synchronized (this.__startedLock) {
            if (this._started) {
                // ** MonitorExit[managedSocketArray] (shouldn't be in output)
                return false;
            }
            this._started = true;
            // ** MonitorExit[managedSocketArray] (shouldn't be in output)
            if (this.getDisableUdp()) {
                udpAddresses = new ServerAddress[]{};
            } else if (udpAddresses == null) {
                udpAddresses = this.getDefaultAddresses();
            }
            if (this.getDisableTcp()) {
                tcpAddresses = new ServerAddress[]{};
            } else if (tcpAddresses == null) {
                tcpAddresses = this.getDefaultAddresses();
            }
            this._udpSockets = this.getDisableUdp() ? new DatagramSocket[0] : this.createServerSockets(true, udpAddresses, new IFunctionDelegate1<ServerAddress, DatagramSocket>(){

                @Override
                public String getId() {
                    return "fm.icelink.StunServer.createUdpSocket";
                }

                @Override
                public DatagramSocket invoke(ServerAddress address) {
                    return StunServer.this.createUdpSocket(address);
                }
            }).toArray(new DatagramSocket[0]);
            this._tcpSockets = this.getDisableTcp() ? new StreamSocket[0] : this.createServerSockets(false, tcpAddresses, new IFunctionDelegate1<ServerAddress, StreamSocket>(){

                @Override
                public String getId() {
                    return "fm.icelink.StunServer.createTcpSocket";
                }

                @Override
                public StreamSocket invoke(ServerAddress address) {
                    return StunServer.this.createTcpSocket(address);
                }
            }).toArray(new StreamSocket[0]);
            for (DatagramSocket datagramSocket : this._udpSockets) {
                this.doUdpReceive(datagramSocket);
                this.logSocket(true, new ServerAddress(datagramSocket.getLocalIPAddress(), datagramSocket.getLocalPort(), datagramSocket.getPublicIPAddress()));
            }
            for (ManagedSocket managedSocket : this._tcpSockets) {
                this.doTcpAccept((StreamSocket)managedSocket);
                this.logSocket(false, new ServerAddress(managedSocket.getLocalIPAddress(), managedSocket.getLocalPort(), managedSocket.getPublicIPAddress()));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        ManagedSocket[] managedSocketArray = this.__startedLock;
        synchronized (this.__startedLock) {
            if (!this._started) {
                // ** MonitorExit[managedSocketArray] (shouldn't be in output)
                return false;
            }
            this._started = false;
            // ** MonitorExit[managedSocketArray] (shouldn't be in output)
            for (DatagramSocket datagramSocket : this._udpSockets) {
                datagramSocket.close();
            }
            for (ManagedSocket managedSocket : this._tcpSockets) {
                managedSocket.close();
            }
            this.removeTcpConnections();
            return true;
        }
    }

    public StunServer() {
        this.__socketFailuresLock = new Object();
        this._tcpConnections = new HashMap();
        this._tcpConnectionsLock = new Object();
    }

    private void tcpAccept(final StreamSocket tcpSocket) {
        block5: {
            IAction1<StreamSocket> onSuccess = null;
            IAction1<Exception> onFailure = null;
            try {
                if (onSuccess == null) {
                    onSuccess = new IAction1<StreamSocket>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void invoke(StreamSocket acceptedSocket) {
                            block9: {
                                acceptedSocket.setPublicIPAddress(tcpSocket.getPublicIPAddress());
                                try {
                                    TurnTcpConnection connection = new TurnTcpConnection(acceptedSocket, (IAction2<TurnTcpConnection, ByteCollection>)new IActionDelegate2<TurnTcpConnection, ByteCollection>(){

                                        @Override
                                        public String getId() {
                                            return "fm.icelink.StunServer.processTcpConnectionReceive";
                                        }

                                        @Override
                                        public void invoke(TurnTcpConnection connection, ByteCollection receiveBuffer) {
                                            StunServer.this.processTcpConnectionReceive(connection, receiveBuffer);
                                        }
                                    });
                                    StunServer.this.addTcpConnection(connection);
                                    connection.setOnClose((IAction1<TurnTcpConnection>)new IActionDelegate1<TurnTcpConnection>(){

                                        @Override
                                        public String getId() {
                                            return "fm.icelink.StunServer.removeTcpConnection";
                                        }

                                        @Override
                                        public void invoke(TurnTcpConnection connection) {
                                            StunServer.this.removeTcpConnection(connection);
                                        }
                                    });
                                    connection.startListening();
                                }
                                catch (Exception exception) {
                                    Log.error("Could not accept TCP socket.", exception);
                                    boolean flag = false;
                                    Object object = StunServer.this.__socketFailuresLock;
                                    synchronized (object) {
                                        StunServer.this.__socketFailuresCount++;
                                        if (StunServer.this.__socketFailuresCount > StunServer.this.__socketFailuresThreshold) {
                                            if (Log.getIsDebugEnabled()) {
                                                Log.debug(StringExtensions.format("Could not accept on server TCP socket. {0}", exception.getMessage()));
                                            }
                                            flag = true;
                                        }
                                    }
                                    if (!flag) break block9;
                                    if (tcpSocket != null) {
                                        tcpSocket.close();
                                    }
                                    return;
                                }
                            }
                            if (StunServer.this._started) {
                                StunServer.this.doTcpAccept(tcpSocket);
                            }
                        }
                    };
                }
                if (onFailure == null) {
                    onFailure = new IAction1<Exception>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void invoke(Exception exception) {
                            boolean flag = false;
                            Object object = StunServer.this.__socketFailuresLock;
                            synchronized (object) {
                                StunServer.this.__socketFailuresCount++;
                                if (StunServer.this.__socketFailuresCount > StunServer.this.__socketFailuresThreshold) {
                                    if (Log.getIsDebugEnabled()) {
                                        Log.debug(StringExtensions.format("Could not accept on server TCP socket. {0}", exception.getMessage()));
                                    }
                                    flag = true;
                                }
                            }
                            if (flag) {
                                if (tcpSocket != null) {
                                    tcpSocket.close();
                                }
                            } else if (StunServer.this._started) {
                                StunServer.this.doTcpAccept(tcpSocket);
                            }
                        }
                    };
                }
                tcpSocket.acceptAsync(onSuccess, onFailure);
            }
            catch (Exception exception) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Could not accept on server TCP socket. {0}", exception.getMessage()));
                }
                if (tcpSocket == null) break block5;
                tcpSocket.close();
            }
        }
    }

    private void udpReceive(final DatagramSocket socket) {
        IAction3<DataBuffer, String, Integer> onSuccess = null;
        IAction1<Exception> onFailure = null;
        try {
            if (onSuccess == null) {
                onSuccess = new IAction3<DataBuffer, String, Integer>(){

                    @Override
                    public void invoke(DataBuffer data, String remoteIPAddress, Integer remotePort) {
                        try {
                            int readLength = 0;
                            IntegerHolder _var0 = new IntegerHolder(readLength);
                            boolean _var1 = StunServer.this.processBuffer(data, socket, null, new ServerAddress(socket.getLocalIPAddress(), socket.getLocalPort(), socket.getPublicIPAddress()), new TransportAddress(remoteIPAddress, remotePort), _var0);
                            readLength = _var0.getValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (StunServer.this._started) {
                            StunServer.this.doUdpReceive(socket);
                        }
                    }
                };
            }
            if (onFailure == null) {
                onFailure = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception exception) {
                        if (StunServer.this._started) {
                            StunServer.this.doUdpReceive(socket);
                        }
                    }
                };
            }
            socket.receiveAsync(onSuccess, onFailure);
        }
        catch (Exception exception) {
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Could not receive on server UDP socket. {0}", exception.getMessage()));
            }
            socket.close();
        }
    }
}

