/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AesCounter;
import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.MacContext;
import fm.icelink.MacType;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.RtcpPacket;
import fm.icelink.RtpPacket;
import fm.icelink.SrtpProtectionProfile;
import fm.icelink.StringExtensions;

class SrtpContext {
    private volatile boolean __clearing = false;
    private volatile boolean __decryptingRtcp = false;
    private volatile boolean __decryptingRtp = false;
    private volatile boolean __encryptingRtcp = false;
    private volatile boolean __encryptingRtp = false;
    private DataBuffer __localKey;
    private DataBuffer __localSalt;
    private String __protectionProfile;
    private DataBuffer __remoteKey;
    private DataBuffer __remoteSalt;
    private static byte __rtcpAuthLabel;
    private AesCounter __rtcpDecryption;
    private MacContext __rtcpDecryptionMacContext;
    private AesCounter __rtcpEncryption;
    private MacContext __rtcpEncryptionMacContext;
    private int __rtcpIntegritySize;
    private static byte __rtcpKeyLabel;
    private static byte __rtcpSaltLabel;
    private static byte __rtpAuthLabel;
    private AesCounter __rtpDecryptionCounter;
    private int __rtpDecryptionHighestSequenceNumber = -1;
    private MacContext __rtpDecryptionMacContext;
    private long __rtpDecryptionRoc = 0L;
    private AesCounter __rtpEncryptionCounter;
    private int __rtpEncryptionHighestSequenceNumber = -1;
    private MacContext __rtpEncryptionMacContext;
    private long __rtpEncryptionRoc = 0L;
    private int __rtpIntegritySize;
    private static byte __rtpKeyLabel;
    private static byte __rtpSaltLabel;
    private int __srtcpIndex = 0;
    private boolean _disabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtcpPacket[] decryptRtcp(DataBuffer buffer) {
        if (this.getDisabled()) {
            return RtcpPacket.parse(buffer);
        }
        if (!this.__clearing) {
            this.__decryptingRtcp = true;
            DataBuffer buffer2 = null;
            try {
                if (!this.__clearing) {
                    if (buffer.getLength() < 12 + this.__rtcpIntegritySize) {
                        RtcpPacket[] rtcpPacketArray = null;
                        return rtcpPacketArray;
                    }
                    int num = 4;
                    int length = this.__rtcpIntegritySize;
                    int offset = buffer.getLength() - num - length;
                    int num4 = offset + num;
                    DataBuffer buffer3 = buffer.subset(num4);
                    DataBuffer input = buffer.subset(0, num4);
                    buffer2 = this.__rtcpDecryptionMacContext.compute(input);
                    DataBuffer buffer5 = buffer2.subset(0, length);
                    if (!BitAssistant.sequencesAreEqual(buffer3.getData(), buffer3.getIndex(), buffer5.getData(), buffer5.getIndex(), length)) {
                        Log.error(StringExtensions.format("Could not decrypt RTCP. Auth check failed. Packet header: {0}", BitAssistant.getHexString(buffer.subset(0, 8).toArray())));
                        RtcpPacket[] rtcpPacketArray = null;
                        return rtcpPacketArray;
                    }
                    long ssrc = buffer.read32(4);
                    buffer.write1(false, offset, 0);
                    long packetIndex = buffer.read32(offset);
                    DataBuffer buffer6 = buffer.subset(8, offset - 8);
                    if (this.__rtcpDecryption != null) {
                        buffer6 = this.__rtcpDecryption.decrypt(buffer6, ssrc, packetIndex);
                        buffer.write(buffer6, 8);
                    }
                    RtcpPacket[] rtcpPacketArray = RtcpPacket.parse(buffer.subset(0, offset));
                    return rtcpPacketArray;
                }
            }
            finally {
                this.__decryptingRtcp = false;
                if (buffer2 != null) {
                    buffer2.free();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpPacket decryptRtp(DataBuffer encryptedBuffer) {
        if (this.getDisabled()) {
            return RtpPacket.wrap(encryptedBuffer);
        }
        if (!this.__clearing) {
            this.__decryptingRtp = true;
            DataBuffer buffer = null;
            DataBuffer buffer2 = null;
            try {
                if (!this.__clearing) {
                    if (encryptedBuffer.getLength() < RtpPacket.getFixedHeaderLength() + this.__rtpIntegritySize) {
                        RtpPacket rtpPacket = null;
                        return rtpPacket;
                    }
                    int num = 4;
                    int count = this.__rtpIntegritySize;
                    int length = encryptedBuffer.getLength() - count;
                    DataBuffer buffer3 = encryptedBuffer.subset(0, length);
                    RtpPacket packet = RtpPacket.wrap(buffer3);
                    if (packet == null) {
                        RtpPacket rtpPacket = null;
                        return rtpPacket;
                    }
                    DataBuffer buffer4 = DataBuffer.allocate(count);
                    buffer4.write(encryptedBuffer.subset(length), 0);
                    long roc = 0L;
                    LongHolder _var0 = new LongHolder(roc);
                    long _var1 = this.getRtpDecryptionPacketIndex(packet.getSequenceNumber(), _var0);
                    roc = _var0.getValue();
                    long rtpDecryptionPacketIndex = _var1;
                    DataBuffer input = encryptedBuffer.subset(0, length + num);
                    input.write32(roc, length);
                    buffer = this.__rtpDecryptionMacContext.compute(input);
                    if (buffer == null) {
                        RtpPacket rtpPacket = null;
                        return rtpPacket;
                    }
                    DataBuffer buffer6 = buffer.subset(0, count);
                    if (!BitAssistant.sequencesAreEqual(buffer4.getData(), buffer4.getIndex(), buffer6.getData(), buffer6.getIndex(), count)) {
                        long num6 = roc;
                        if (packet.getSequenceNumber() < 32768 && roc > 0L) {
                            --num6;
                        } else if (packet.getSequenceNumber() >= 32768) {
                            ++num6;
                        }
                        if (roc == num6) {
                            Log.error(StringExtensions.format("Could not decrypt RTP. Auth check failed for sequence number {0}. Packet Header: {1}; Payload Type: {2}; Tag: {3}", new Object[]{IntegerExtensions.toString(packet.getSequenceNumber()), BitAssistant.getHexString(encryptedBuffer.subset(0, 12).toArray()), IntegerExtensions.toString(packet.getPayloadType()), LongExtensions.toString(buffer4.read32(0))}));
                            RtpPacket rtpPacket = null;
                            return rtpPacket;
                        }
                        input.write32(num6, length);
                        buffer2 = this.__rtpDecryptionMacContext.compute(input);
                        if (buffer2 == null) {
                            RtpPacket rtpPacket = null;
                            return rtpPacket;
                        }
                        buffer6 = buffer2.subset(0, count);
                        if (!BitAssistant.sequencesAreEqual(buffer4.getData(), buffer4.getIndex(), buffer6.getData(), buffer6.getIndex(), count)) {
                            Log.error(StringExtensions.format("Could not decrypt RTP (recovery failed). Auth check failed for sequence number {0}. Packet Header: {1}; Payload Type: {2}; Tag: {3}", new Object[]{IntegerExtensions.toString(packet.getSequenceNumber()), BitAssistant.getHexString(encryptedBuffer.subset(0, 12).toArray()), IntegerExtensions.toString(packet.getPayloadType()), LongExtensions.toString(buffer4.read32(0))}));
                            RtpPacket rtpPacket = null;
                            return rtpPacket;
                        }
                        Log.debug(StringExtensions.format("Recovered RTP packet after failed decryption. Original auth check failed for sequence number {0}. Packet Header: {1}; Payload Type: {2}; Tag: {3}", new Object[]{IntegerExtensions.toString(packet.getSequenceNumber()), BitAssistant.getHexString(encryptedBuffer.subset(0, 12).toArray()), IntegerExtensions.toString(packet.getPayloadType()), LongExtensions.toString(buffer4.read32(0))}));
                    }
                    if (this.__rtpDecryptionCounter != null) {
                        packet.setPayload(this.__rtpDecryptionCounter.decrypt(buffer3.subset(packet.getPayloadOffset()), packet.getSynchronizationSource(), rtpDecryptionPacketIndex));
                    }
                    RtpPacket rtpPacket = packet;
                    return rtpPacket;
                }
            }
            finally {
                this.__decryptingRtp = false;
                if (buffer != null) {
                    buffer.free();
                }
                if (buffer2 != null) {
                    buffer2.free();
                }
            }
        }
        return null;
    }

    public void destroy() {
        if (!this.getDisabled()) {
            this.__clearing = true;
            while (this.__encryptingRtp || this.__encryptingRtcp || this.__decryptingRtp || this.__decryptingRtcp) {
                ManagedThread.sleep(10);
            }
            if (this.__rtpEncryptionCounter != null) {
                this.__rtpEncryptionCounter.clear();
                this.__rtpEncryptionCounter = null;
            }
            if (this.__rtcpEncryption != null) {
                this.__rtcpEncryption.clear();
                this.__rtcpEncryption = null;
            }
            if (this.__rtpDecryptionCounter != null) {
                this.__rtpDecryptionCounter.clear();
                this.__rtpDecryptionCounter = null;
            }
            if (this.__rtcpDecryption != null) {
                this.__rtcpDecryption.clear();
                this.__rtcpDecryption = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer encryptRtcp(RtcpPacket[] packets) {
        if (this.getDisabled()) {
            int num = 0;
            for (RtcpPacket packet : packets) {
                num += packet.getBuffer().getLength();
            }
            DataBuffer buffer = packets[0].getBuffer();
            int length = buffer.getLength();
            buffer.resize(num);
            for (int num3 = 1; num3 < ArrayExtensions.getLength(packets); ++num3) {
                buffer.write(packets[num3].getBuffer(), length);
                length += packets[num3].getBuffer().getLength();
            }
            return buffer;
        }
        if (!this.__clearing) {
            this.__encryptingRtcp = true;
            DataBuffer buffer2 = null;
            try {
                if (!this.__clearing) {
                    if (packets == null) {
                        DataBuffer dataBuffer = null;
                        return dataBuffer;
                    }
                    if (ArrayExtensions.getLength(packets) == 0) {
                        DataBuffer dataBuffer = DataBuffer.getEmpty();
                        return dataBuffer;
                    }
                    int num4 = 4;
                    int num5 = this.__rtcpIntegritySize;
                    int num = 0;
                    for (RtcpPacket packet : packets) {
                        num += packet.getBuffer().getLength();
                    }
                    int num6 = num + num4;
                    DataBuffer buffer3 = packets[0].getBuffer();
                    int length = buffer3.getLength();
                    buffer3.resize(num + num4 + num5);
                    for (int num3 = 1; num3 < ArrayExtensions.getLength(packets); ++num3) {
                        buffer3.write(packets[num3].getBuffer(), length);
                        length += packets[num3].getBuffer().getLength();
                    }
                    int rtcpEncryptionPacketIndex = this.getRtcpEncryptionPacketIndex();
                    long ssrc = buffer3.read32(4);
                    DataBuffer buffer4 = buffer3.subset(8, num - 8);
                    if (this.__rtcpEncryption != null) {
                        buffer4 = this.__rtcpEncryption.encrypt(buffer4, ssrc, rtcpEncryptionPacketIndex);
                        buffer3.write(buffer4, 8);
                    }
                    buffer3.write32(rtcpEncryptionPacketIndex, num);
                    buffer3.write1(true, num, 0);
                    DataBuffer input = buffer3.subset(0, num6);
                    buffer2 = this.__rtcpEncryptionMacContext.compute(input);
                    DataBuffer buffer6 = buffer2.subset(0, num5);
                    buffer3.write(buffer6, num6);
                    DataBuffer dataBuffer = buffer3;
                    return dataBuffer;
                }
            }
            finally {
                this.__encryptingRtcp = false;
                if (buffer2 != null) {
                    buffer2.free();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer encryptRtp(RtpPacket packet) {
        if (this.getDisabled()) {
            return packet.getBuffer();
        }
        if (!this.__clearing) {
            this.__encryptingRtp = true;
            DataBuffer buffer = null;
            try {
                if (!this.__clearing) {
                    if (packet == null) {
                        DataBuffer dataBuffer = null;
                        return dataBuffer;
                    }
                    int num = 4;
                    int length = packet.getBuffer().getLength();
                    int num3 = this.__rtpIntegritySize;
                    DataBuffer buffer2 = DataBuffer.allocate(length + num3);
                    buffer2.write(packet.getHeader(), 0);
                    long roc = 0L;
                    if (this.__rtpEncryptionCounter != null) {
                        LongHolder _var0 = new LongHolder(roc);
                        long _var1 = this.getRtpEncryptionPacketIndex(packet.getSequenceNumber(), _var0);
                        roc = _var0.getValue();
                        buffer2.write(this.__rtpEncryptionCounter.encrypt(packet.getPayload(), packet.getSynchronizationSource(), _var1), packet.getHeaderLength());
                    }
                    DataBuffer input = buffer2.subset(0, length + num);
                    input.write32(roc, length);
                    buffer = this.__rtpEncryptionMacContext.compute(input);
                    DataBuffer buffer4 = buffer.subset(0, num3);
                    buffer2.write(buffer4, length);
                    DataBuffer dataBuffer = buffer2;
                    return dataBuffer;
                }
            }
            finally {
                this.__encryptingRtp = false;
                if (buffer != null) {
                    buffer.free();
                }
            }
        }
        return null;
    }

    public boolean getDisabled() {
        return this._disabled;
    }

    public DataBuffer getLocalKey() {
        return this.__localKey;
    }

    public DataBuffer getLocalSalt() {
        return this.__localSalt;
    }

    public String getProtectionProfile() {
        return this.__protectionProfile;
    }

    public DataBuffer getRemoteKey() {
        return this.__remoteKey;
    }

    public DataBuffer getRemoteSalt() {
        return this.__remoteSalt;
    }

    private int getRtcpEncryptionPacketIndex() {
        return this.__srtcpIndex++;
    }

    public long getRtpDecryptionPacketIndex(int sequenceNumber) {
        long roc = 0L;
        LongHolder _var0 = new LongHolder(roc);
        long _var1 = this.getRtpDecryptionPacketIndex(sequenceNumber, _var0);
        roc = _var0.getValue();
        return _var1;
    }

    public long getRtpDecryptionPacketIndex(int sequenceNumber, LongHolder roc) {
        long num;
        if (this.__rtpDecryptionHighestSequenceNumber == -1) {
            this.__rtpDecryptionHighestSequenceNumber = sequenceNumber;
            roc.setValue(this.__rtpDecryptionRoc);
            return sequenceNumber;
        }
        if (this.__rtpDecryptionHighestSequenceNumber < 32768) {
            if (sequenceNumber - this.__rtpDecryptionHighestSequenceNumber > 32768) {
                num = (this.__rtpDecryptionRoc - 1L) % 0x100000000L;
            } else {
                num = this.__rtpDecryptionRoc;
                this.__rtpDecryptionHighestSequenceNumber = MathAssistant.max(this.__rtpDecryptionHighestSequenceNumber, sequenceNumber);
            }
        } else if (this.__rtpDecryptionHighestSequenceNumber - 32768 > sequenceNumber) {
            num = (this.__rtpDecryptionRoc + 1L) % 0x100000000L;
            this.__rtpDecryptionHighestSequenceNumber = sequenceNumber;
            this.__rtpDecryptionRoc = num;
        } else {
            num = this.__rtpDecryptionRoc;
            this.__rtpDecryptionHighestSequenceNumber = MathAssistant.max(this.__rtpDecryptionHighestSequenceNumber, sequenceNumber);
        }
        roc.setValue(num);
        return 65536L * num + (long)sequenceNumber;
    }

    public long getRtpEncryptionPacketIndex(int sequenceNumber, LongHolder roc) {
        long num;
        if (this.__rtpEncryptionHighestSequenceNumber == -1) {
            this.__rtpEncryptionHighestSequenceNumber = sequenceNumber;
            roc.setValue(this.__rtpEncryptionRoc);
            return sequenceNumber;
        }
        if (this.__rtpEncryptionHighestSequenceNumber < 32768) {
            if (sequenceNumber - this.__rtpEncryptionHighestSequenceNumber > 32768) {
                num = (this.__rtpEncryptionRoc - 1L) % 0x100000000L;
            } else {
                num = this.__rtpEncryptionRoc;
                this.__rtpEncryptionHighestSequenceNumber = MathAssistant.max(this.__rtpEncryptionHighestSequenceNumber, sequenceNumber);
            }
        } else if (this.__rtpEncryptionHighestSequenceNumber - 32768 > sequenceNumber) {
            num = (this.__rtpEncryptionRoc + 1L) % 0x100000000L;
            this.__rtpEncryptionHighestSequenceNumber = sequenceNumber;
            this.__rtpEncryptionRoc = num;
        } else {
            num = this.__rtpEncryptionRoc;
            this.__rtpEncryptionHighestSequenceNumber = MathAssistant.max(this.__rtpEncryptionHighestSequenceNumber, sequenceNumber);
        }
        roc.setValue(num);
        return 65536L * num + (long)sequenceNumber;
    }

    private void setDisabled(boolean value) {
        this._disabled = value;
    }

    public SrtpContext(String protectionProfile, DataBuffer localKey, DataBuffer localSalt, DataBuffer remoteKey, DataBuffer remoteSalt) {
        if (protectionProfile == null) {
            this.setDisabled(true);
        } else {
            this.__protectionProfile = protectionProfile;
            this.__localKey = localKey;
            this.__localSalt = localSalt;
            this.__remoteKey = remoteKey;
            this.__remoteSalt = remoteSalt;
            AesCounter counter = new AesCounter(localKey, localSalt);
            AesCounter counter2 = new AesCounter(remoteKey, remoteSalt);
            if (Global.equals(protectionProfile, SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileString()) || Global.equals(protectionProfile, SrtpProtectionProfile.getAes128CmHmacSha180ProtectionProfileString())) {
                DataBuffer buffer = counter.generate(__rtpKeyLabel, 16);
                DataBuffer salt = counter.generate(__rtpSaltLabel, 14);
                this.__rtpEncryptionCounter = new AesCounter(buffer, salt);
                DataBuffer buffer3 = counter.generate(__rtcpKeyLabel, 16);
                DataBuffer buffer4 = counter.generate(__rtcpSaltLabel, 14);
                this.__rtcpEncryption = new AesCounter(buffer3, buffer4);
                DataBuffer buffer5 = counter2.generate(__rtpKeyLabel, 16);
                DataBuffer buffer6 = counter2.generate(__rtpSaltLabel, 14);
                this.__rtpDecryptionCounter = new AesCounter(buffer5, buffer6);
                DataBuffer buffer7 = counter2.generate(__rtcpKeyLabel, 16);
                DataBuffer buffer8 = counter2.generate(__rtcpSaltLabel, 14);
                this.__rtcpDecryption = new AesCounter(buffer7, buffer8);
            }
            DataBuffer key = counter.generate(__rtpAuthLabel, 20);
            this.__rtpEncryptionMacContext = new MacContext(MacType.HmacSha1, key);
            DataBuffer buffer10 = counter.generate(__rtcpAuthLabel, 20);
            this.__rtcpEncryptionMacContext = new MacContext(MacType.HmacSha1, buffer10);
            DataBuffer buffer11 = counter2.generate(__rtpAuthLabel, 20);
            this.__rtpDecryptionMacContext = new MacContext(MacType.HmacSha1, buffer11);
            DataBuffer buffer12 = counter2.generate(__rtcpAuthLabel, 20);
            this.__rtcpDecryptionMacContext = new MacContext(MacType.HmacSha1, buffer12);
            this.__rtpIntegritySize = Global.equals(protectionProfile, SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileString()) || Global.equals(protectionProfile, SrtpProtectionProfile.getNullHmacSha132ProtectionProfileString()) ? 4 : 10;
            this.__rtcpIntegritySize = 10;
            counter2.clear();
            counter.clear();
        }
    }

    static {
        __rtpKeyLabel = 0;
        __rtpAuthLabel = 1;
        __rtpSaltLabel = (byte)2;
        __rtcpKeyLabel = (byte)3;
        __rtcpAuthLabel = (byte)4;
        __rtcpSaltLabel = (byte)5;
    }
}

