/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;

class SctpCommonHeader {
    private long _checksum;
    private int _destinationPortNumber;
    private int _sourcePortNumber;
    private long _verificationTag;

    public byte[] getBytes() {
        return SctpCommonHeader.getBytes(this);
    }

    public static byte[] getBytes(SctpCommonHeader header) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(header.getSourcePortNumber(), false));
        bytes.addRange(Binary.toBytes16(header.getDestinationPortNumber(), false));
        bytes.addRange(Binary.toBytes32(header.getVerificationTag(), false));
        bytes.addRange(Binary.toBytes32(header.getChecksum(), false));
        return bytes.toArray();
    }

    public long getChecksum() {
        return this._checksum;
    }

    public int getDestinationPortNumber() {
        return this._destinationPortNumber;
    }

    public int getSourcePortNumber() {
        return this._sourcePortNumber;
    }

    public long getVerificationTag() {
        return this._verificationTag;
    }

    public static SctpCommonHeader parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int sourcePort = Binary.fromBytes16(bytes, 0, false);
            int destionationPort = Binary.fromBytes16(bytes, 2, false);
            long vTag = Binary.fromBytes32(bytes, 4, false);
            long checksum = Binary.fromBytes32(bytes, 8, false);
            offsetPlus.setValue(12);
            return new SctpCommonHeader(sourcePort, destionationPort, vTag, checksum);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpCommonHeader(int sourcePort, int destionationPort, long vTag) {
        this.setSourcePortNumber(sourcePort);
        this.setDestinationPortNumber(destionationPort);
        this.setVerificationTag(vTag);
        this.setChecksum(0L);
    }

    public SctpCommonHeader(int sourcePort, int destionationPort, long vTag, long checksum) {
        this.setSourcePortNumber(sourcePort);
        this.setDestinationPortNumber(destionationPort);
        this.setVerificationTag(vTag);
        this.setChecksum(checksum);
    }

    public void setChecksum(long value) {
        this._checksum = value;
    }

    public void setDestinationPortNumber(int value) {
        this._destinationPortNumber = value;
    }

    public void setSourcePortNumber(int value) {
        this._sourcePortNumber = value;
    }

    public void setVerificationTag(long value) {
        this._verificationTag = value;
    }
}

