/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.CandidatePairState;
import fm.icelink.CandidatePairStats;
import fm.icelink.CandidateType;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IceCandidate;
import fm.icelink.IceComponent;
import fm.icelink.IceDatagramSocketManager;
import fm.icelink.IceLocalCandidateState;
import fm.icelink.IceLocalRelayedCandidate;
import fm.icelink.IceParameters;
import fm.icelink.IceRole;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestFailureArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IceTransactionManager;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.BindingRequest;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.StaleNonceError;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.Utility;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.ControllingAttribute;
import fm.icelink.stun.ice.PriorityAttribute;
import fm.icelink.stun.ice.UseCandidateAttribute;
import fm.icelink.stun.turn.CreatePermissionRequest;
import fm.icelink.stun.turn.CreatePermissionResponse;

class IceCandidatePair {
    private boolean __awaitingOriginalRelayPermissions;
    private IceComponent __component;
    private int __connectionTimeout = 10000;
    private ScheduledItem __connectivityCheckScheduledItem = null;
    private volatile boolean __keepAliveActive;
    private ScheduledItem __keepAliveScheduledItem;
    private int __keepAliveTimeout = 3000;
    private long __lastReceivedSomethingTimestamp;
    private IceCandidate __local;
    private IceParameters __localParameters;
    private IceRole __localRole;
    private Object __lock;
    private volatile boolean __needsKeepAlive = true;
    private long __permissionExpiresTimestamp;
    private volatile boolean __relayPermissionsActive;
    private ScheduledItem __relayPermissionsRefreshScheduledItem;
    private IceCandidate __remote;
    private IceParameters __remoteParameters;
    private CandidatePairState __state = CandidatePairState.New;
    private long __tieBreaker;
    private IceTransactionManager __transactionManager;
    private AtomicLong _bytesReceived;
    private AtomicLong _bytesSent;
    private Error _error;
    private String _id;
    private int _keepAliveInterval;
    private boolean _nominated;
    private IAction1<IceCandidatePair> _onOriginalRelayPermissionsObtained;
    private IAction1<IceCandidatePair> _onStateChange;
    private IAction1<IceSendRequestSuccessArgs> _onStunResponse;
    private long _priority;
    private IceCandidatePair _relatedValidPair;
    private ScheduledItem _stopCandidatePair;
    private boolean _useCandidateReceived;
    private boolean _valid;
    private boolean _verboseDebugMessages = false;

    public void assignPriority(IceRole role) {
        long num2;
        long priority;
        if (Global.equals((Object)role, (Object)IceRole.Controlling)) {
            priority = this.getLocal().getPriority();
            num2 = this.getRemote().getPriority();
        } else {
            priority = this.getRemote().getPriority();
            num2 = this.getLocal().getPriority();
        }
        this.setPriority(0x100000000L * MathAssistant.min(priority, num2) + 2L * MathAssistant.max(priority, num2) + (priority > num2 ? 1L : 0L));
    }

    void bypassConnectivityChecks() {
        this.setState(CandidatePairState.Succeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAssociatedTransactions() {
        Object object;
        Object obj2;
        if (Global.equals((Object)this.getLocal().getType(), (Object)CandidateType.Relayed)) {
            object = obj2 = this.__lock;
            synchronized (object) {
                this.__relayPermissionsActive = false;
                if (this.__transactionManager != null) {
                    this.__transactionManager.remove(this.__relayPermissionsRefreshScheduledItem, this);
                }
                this.__relayPermissionsRefreshScheduledItem = null;
            }
        }
        object = obj2 = this.__lock;
        synchronized (object) {
            this.__keepAliveActive = false;
            if (this.__transactionManager != null) {
                this.__transactionManager.remove(this.__keepAliveScheduledItem, this);
            }
            this.__keepAliveScheduledItem = null;
        }
        this.cancelConnectivityCheck();
    }

    public void cancelConnectivityCheck() {
        ScheduledItem item = this.__connectivityCheckScheduledItem;
        if (item != null) {
            ((IceSendMessageArgs)item.getState()).cancelTransaction();
        }
    }

    void checkForConnectivity() {
        if (Global.equals((Object)this.getState(), (Object)CandidatePairState.Waiting)) {
            this.setState(CandidatePairState.InProgress);
            BindingRequest message = this.createBindingRequest();
            TransportAddress turnServer = null;
            if (Global.equals((Object)this.getLocal().getType(), (Object)CandidateType.Relayed)) {
                IceLocalRelayedCandidate local = (IceLocalRelayedCandidate)this.getLocal();
                turnServer = local.getTurnServer();
            }
            String iPAddress = this.getRemote().getIPAddress();
            int port = this.getRemote().getPort();
            IceSendMessageArgs args2 = new IceSendMessageArgs(message, new TransportAddress(iPAddress, port));
            args2.setTurnRelay(turnServer);
            args2.setCandidatePair(this);
            args2.setOnResponse(this.getOnStunResponse());
            args2.setOnFailure((IAction1<IceSendRequestFailureArgs>)new IActionDelegate1<IceSendRequestFailureArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceCandidatePair.processConnectivityCheckExecutionFailure";
                }

                @Override
                public void invoke(IceSendRequestFailureArgs e) {
                    IceCandidatePair.this.processConnectivityCheckExecutionFailure(e);
                }
            });
            IceSendMessageArgs args = args2;
            int relayConnectionTimeout = this.getRelayConnectionTimeout();
            int interval = Global.equals((Object)this.getLocal().getOperatingProtocol(), (Object)ProtocolType.Udp) ? 100 : ScheduledItem.getUnset();
            int invocationCountLimit = Global.equals((Object)this.getLocal().getOperatingProtocol(), (Object)ProtocolType.Udp) ? ScheduledItem.getUnset() : 1;
            ScheduledItem item = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceCandidatePair.sendConnectivityCheck";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    IceCandidatePair.this.sendConnectivityCheck(item);
                }
            }, 0, interval, relayConnectionTimeout, invocationCountLimit);
            item.setState(args);
            item.setIntervalBackoffMultiplier(2.0f);
            item.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceCandidatePair.connectivityCheckTimedout";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    IceCandidatePair.this.connectivityCheckTimedout(item);
                }
            });
            this.__connectivityCheckScheduledItem = item;
            if (this._verboseDebugMessages) {
                Log.debug(StringExtensions.format("Checking candidate pair {0} for connectivity.", this.toString()));
            }
            this.__transactionManager.addTransaction(this.__connectivityCheckScheduledItem, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectivityCheckTimedout(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)CandidatePairState.Succeeded)) {
                this.__transactionManager.remove(item, this);
                if (!state.getCancelled()) {
                    this.setState(CandidatePairState.Failed);
                }
            }
        }
    }

    public BindingRequest createBindingRequest() {
        if (this.__remoteParameters.getUsernameFragment() == null || this.__remoteParameters.getPassword() == null) {
            if (this.__remoteParameters.getUsernameFragment() == null && this.__remoteParameters.getPassword() == null) {
                Log.warn("Could not create binding request. Remote candidate username and password were null.");
            } else if (this.__remoteParameters.getUsernameFragment() == null) {
                Log.warn("Could not create binding request. Remote candidate username was null.");
            } else {
                Log.warn("Could not create binding request. Remote candidate password was null.");
            }
            return null;
        }
        BindingRequest request = new BindingRequest();
        request.setUsername(new UsernameAttribute(StringExtensions.format("{0}:{1}", this.__remoteParameters.getUsernameFragment(), this.__localParameters.getUsernameFragment())));
        if (Global.equals((Object)this.__localRole, (Object)IceRole.Controlling)) {
            request.setIceControlling(new ControllingAttribute(this.__tieBreaker));
            request.setUseCandidate(new UseCandidateAttribute());
        } else {
            request.setIceControlled(new ControlledAttribute(this.__tieBreaker));
        }
        int localPreference = IceCandidate.calculateLocalPreference(this.getLocal().getType(), this.getLocal().getPriority(), this.__component);
        request.setPriority(new PriorityAttribute(IceCandidate.calculatePriority(CandidateType.PeerReflexive, localPreference, this.__component)));
        request.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createShortTermKey(this.__remoteParameters.getPassword())));
        request.setFingerprint(new FingerprintAttribute());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPermissionFailure(IceSendRequestFailureArgs e) {
        Error error = e.getError();
        Object object = this.__lock;
        synchronized (object) {
            if (this.__relayPermissionsActive) {
                String str;
                String string = str = error != null ? error.getDescription() : "";
                if (Log.getIsWarnEnabled()) {
                    Log.error(StringExtensions.format("CreatePermission request failed for {0}. {1}", this.toString(), str));
                }
            }
            this.setError(error);
            this.setState(CandidatePairState.Failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchKeepAlive(ScheduledItem item) {
        long currentTime = Scheduler.getCurrentTime();
        if (this.__lastReceivedSomethingTimestamp == (long)ScheduledItem.getUnset()) {
            this.receivedSomething();
        }
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)CandidatePairState.ConnectivityLost) && currentTime > this.__lastReceivedSomethingTimestamp + (long)this.getKeepAliveTimeout()) {
                Log.debug(StringExtensions.format("Candidate pair {0} lost connectivity.", this.toString()));
                this.setState(CandidatePairState.ConnectivityLost);
            }
            if (this.__keepAliveActive) {
                if (this.__needsKeepAlive) {
                    // empty if block
                }
                try {
                    this.getLocal().sendStunMessage(item);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.__needsKeepAlive = true;
            }
        }
    }

    public boolean equals(Object obj) {
        IceCandidatePair pair = Global.tryCast(obj, IceCandidatePair.class);
        if (pair == null) {
            return false;
        }
        return this.equals(pair.getLocal(), pair.getRemote());
    }

    public boolean equals(IceCandidate local, IceCandidate remote) {
        return local.equals(this.getLocal()) && remote.equals(this.getRemote());
    }

    private IceSendMessageArgs generateKeepAlive() {
        boolean flag = Global.equals((Object)this.getLocal().getType(), (Object)CandidateType.Relayed);
        BindingRequest message = this.createBindingRequest();
        TransportAddress turnServer = null;
        if (flag) {
            turnServer = ((IceLocalRelayedCandidate)this.getLocal()).getTurnServer();
        }
        IceSendMessageArgs args2 = new IceSendMessageArgs(message, new TransportAddress(this.getRemote().getIPAddress(), this.getRemote().getPort()));
        args2.setTurnRelay(turnServer);
        args2.setCandidatePair(this);
        args2.setOnResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceCandidatePair.processKeepAliveResponse";
            }

            @Override
            public void invoke(IceSendRequestSuccessArgs args) {
                IceCandidatePair.this.processKeepAliveResponse(args);
            }
        });
        args2.setOnFailure((IAction1<IceSendRequestFailureArgs>)new IActionDelegate1<IceSendRequestFailureArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceCandidatePair.processKeepAliveExecutionFailure";
            }

            @Override
            public void invoke(IceSendRequestFailureArgs args) {
                IceCandidatePair.this.processKeepAliveExecutionFailure(args);
            }
        });
        return args2;
    }

    boolean getAwaitingOriginalRelayPermissions() {
        return this.__awaitingOriginalRelayPermissions;
    }

    public Error getError() {
        return this._error;
    }

    public String getFoundation() {
        return StringExtensions.concat(this.getLocal().getFoundation(), this.getRemote().getFoundation());
    }

    public String getId() {
        return this._id;
    }

    int getKeepAliveInterval() {
        return this._keepAliveInterval;
    }

    int getKeepAliveTimeout() {
        return this.__keepAliveTimeout;
    }

    public IceCandidate getLocal() {
        return this.__local;
    }

    boolean getNominated() {
        return this._nominated;
    }

    IAction1<IceCandidatePair> getOnOriginalRelayPermissionsObtained() {
        return this._onOriginalRelayPermissionsObtained;
    }

    public IAction1<IceCandidatePair> getOnStateChange() {
        return this._onStateChange;
    }

    IAction1<IceSendRequestSuccessArgs> getOnStunResponse() {
        return this._onStunResponse;
    }

    public long getPriority() {
        return this._priority;
    }

    IceCandidatePair getRelatedValidPair() {
        return this._relatedValidPair;
    }

    int getRelayConnectionTimeout() {
        return this.__connectionTimeout;
    }

    public IceCandidate getRemote() {
        return this.__remote;
    }

    public CandidatePairState getState() {
        return this.__state;
    }

    public CandidatePairStats getStats() {
        CandidatePairStats stats = new CandidatePairStats();
        stats.setId(this.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setLocalCandidateId(this.getLocal().getId());
        stats.setRemoteCandidateId(this.getRemote().getId());
        stats.setNominated(this.getNominated());
        stats.setPriority(this.getPriority());
        stats.setState(this.getState());
        stats.setBytesSent(this._bytesSent.getValue());
        stats.setBytesReceived(this._bytesReceived.getValue());
        return stats;
    }

    ScheduledItem getStopCandidatePair() {
        return this._stopCandidatePair;
    }

    boolean getUseCandidateReceived() {
        return this._useCandidateReceived;
    }

    boolean getValid() {
        return this._valid;
    }

    public int hashCode() {
        return super.hashCode();
    }

    IceCandidatePair(Object lockObject, IceCandidate local, IceCandidate remote, IceParameters localParameters, IceParameters remoteParameters, IceRole localRole, long tieBreaker, IceComponent component, IceTransactionManager manager) {
        this.__lastReceivedSomethingTimestamp = ScheduledItem.getUnset();
        this._bytesSent = new AtomicLong();
        this._bytesReceived = new AtomicLong();
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.__lock = lockObject;
        this.setLocal(local);
        this.__remote = remote;
        this.__localParameters = localParameters;
        this.__remoteParameters = remoteParameters;
        this.__localRole = localRole;
        this.__tieBreaker = tieBreaker;
        this.__component = component;
        this.__remote.setUsername(this.__remoteParameters.getUsernameFragment());
        this.__remote.setPassword(this.__remoteParameters.getPassword());
        this.__transactionManager = manager;
        this.__permissionExpiresTimestamp = 0L;
        if (Global.equals((Object)local.getType(), (Object)CandidateType.Relayed)) {
            this.setAwaitingOriginalRelayPermissions(true);
        }
        this.assignPriority(this.__localRole);
    }

    public void notifyDataReceived(DataBuffer buffer) {
        if (buffer != null) {
            this._bytesReceived.add(buffer.getLength());
        }
        this.receivedSomething();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataSent() {
        Object object = this.__lock;
        synchronized (object) {
            this.__needsKeepAlive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnectivityCheckExecutionFailure(IceSendRequestFailureArgs e) {
        Error error = e.getError();
        Object object = this.__lock;
        synchronized (object) {
            String str = error != null ? error.getDescription() : "";
            Log.debug(StringExtensions.format("Connectivity check failed from {0} to {1}: {2}", this.getLocal().getTransportAddress().toString(), this.getRemote().getTransportAddress().toString(), str));
            this.setError(error);
            this.setState(CandidatePairState.Failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKeepAliveExecutionFailure(IceSendRequestFailureArgs args) {
        Error error = args.getError();
        String str = error != null ? error.getDescription() : "";
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)CandidatePairState.Failed)) {
                String message = StringExtensions.format("KeepAlive request failed for {0}. {1}", this.toString(), str);
                if (Log.getIsWarnEnabled()) {
                    Log.error(message);
                }
                this.setError(error);
                this.setState(CandidatePairState.Failed);
            }
        }
    }

    private void processKeepAliveResponse(IceSendRequestSuccessArgs args) {
        this.receivedSomething();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalCandidateStateChange(IceCandidate candidate) {
        IceLocalCandidateState state = candidate.getState();
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)state, (Object)IceLocalCandidateState.Failed)) {
                this.setError(candidate.getError());
                this.setState(CandidatePairState.Failed);
            } else if (!(!Global.equals((Object)state, (Object)IceLocalCandidateState.Closed) || Global.equals((Object)this.getState(), (Object)CandidatePairState.Closed) && Global.equals((Object)this.getState(), (Object)CandidatePairState.Failed))) {
                this.setState(CandidatePairState.Failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPermissionExtensionResponse(IceSendRequestSuccessArgs e) {
        boolean flag = false;
        Object object = this.__lock;
        synchronized (object) {
            if (this.__relayPermissionsActive) {
                if (!(e.getResponse() instanceof CreatePermissionResponse)) {
                    return;
                }
                ScheduledItem item = e.getItem();
                IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
                int num = (int)((long)item.getInvocationLifetimeLimit() + item.getOriginalInvocationTime() - Scheduler.getCurrentTime());
                Error error = IceDatagramSocketManager.validateResponse(state, e.getResponse(), e.getRemoteAddress());
                this.__transactionManager.remove(this.__relayPermissionsRefreshScheduledItem, this);
                if (error == null) {
                    this.__permissionExpiresTimestamp = Scheduler.getCurrentTime() + 300000L;
                    if (this.getAwaitingOriginalRelayPermissions()) {
                        this.setAwaitingOriginalRelayPermissions(false);
                    }
                    this.schedulePermissionExtension(240000);
                } else {
                    String str;
                    if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunStaleNonce)) {
                        StaleNonceError error2 = (StaleNonceError)error;
                        IceLocalRelayedCandidate local = (IceLocalRelayedCandidate)this.getLocal();
                        local.setNonce(error2.getNonce().getValue());
                        IceSendMessageArgs args2 = (IceSendMessageArgs)item.getState();
                        args2.getMessage().setNonce(error2.getNonce());
                    } else if (!Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunServerError)) {
                        str = StringExtensions.format("CreatePermission request failed for {0}. {1}", this.toString(), error.getDescription());
                        Error error3 = new Error(ErrorCode.IceCreatePermissionError);
                        error3.setException(new Exception(str));
                        this.setError(error3);
                        Log.error(this.getError().getDescription());
                        flag = true;
                    }
                    if (num > 0) {
                        item.setInvocationLifetimeLimit(num);
                        this.__transactionManager.addTransaction(item, this);
                    } else {
                        str = StringExtensions.format("CreatePermission request failed for {0} after several attempts. {1}", this.toString(), error.getDescription());
                        Error error4 = new Error(ErrorCode.IceCreatePermissionTimeout);
                        error4.setException(new Exception(str));
                        this.setError(error4);
                        Log.error(this.getError().getDescription());
                        flag = true;
                    }
                }
            }
        }
        if (flag) {
            this.setState(CandidatePairState.Failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPermissionTimedout(ScheduledItem item) {
        String message = StringExtensions.format("CreatePermission request failed for {0} after several attempts. Relay server did not respond.", this.toString());
        Object object = this.__lock;
        synchronized (object) {
            if (this.__relayPermissionsActive && Log.getIsWarnEnabled()) {
                Log.error(message);
            }
            Error error = new Error(ErrorCode.IceCreatePermissionTimeout);
            error.setException(new Exception(message));
            this.setError(error);
            this.setState(CandidatePairState.Failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedSomething() {
        Object object = this.__lock;
        synchronized (object) {
            this.__lastReceivedSomethingTimestamp = Scheduler.getCurrentTime();
            if (Global.equals((Object)this.getState(), (Object)CandidatePairState.ConnectivityLost)) {
                Log.debug(StringExtensions.format("Candidate pair {0} regained connectivity.", this.toString()));
                this.setState(CandidatePairState.Succeeded);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePermissionExtension(int delay) {
        IceLocalRelayedCandidate local = (IceLocalRelayedCandidate)this.getLocal();
        CreatePermissionRequest message = local.generatePermissionRequest(this.getRemote().getIPAddress());
        TransportAddress turnServer = local.getTurnServer();
        IceSendMessageArgs args2 = new IceSendMessageArgs(message, turnServer);
        args2.setCandidatePair(this);
        args2.setOnResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceCandidatePair.processPermissionExtensionResponse";
            }

            @Override
            public void invoke(IceSendRequestSuccessArgs e) {
                IceCandidatePair.this.processPermissionExtensionResponse(e);
            }
        });
        args2.setOnFailure((IAction1<IceSendRequestFailureArgs>)new IActionDelegate1<IceSendRequestFailureArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceCandidatePair.createPermissionFailure";
            }

            @Override
            public void invoke(IceSendRequestFailureArgs e) {
                IceCandidatePair.this.createPermissionFailure(e);
            }
        });
        IceSendMessageArgs args = args2;
        int invocationCountLimit = Global.equals((Object)this.getLocal().getOperatingProtocol(), (Object)ProtocolType.Udp) ? ScheduledItem.getUnset() : 1;
        int interval = Global.equals((Object)this.getLocal().getOperatingProtocol(), (Object)ProtocolType.Udp) ? 100 : ScheduledItem.getUnset();
        Object object = this.__lock;
        synchronized (object) {
            if (this.__relayPermissionsActive) {
                ScheduledItem item = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceCandidatePair.triggerPermissionExtension";
                    }

                    @Override
                    public void invoke(ScheduledItem item) {
                        IceCandidatePair.this.triggerPermissionExtension(item);
                    }
                }, delay, interval, this.getRelayConnectionTimeout(), invocationCountLimit);
                item.setState(args);
                item.setIntervalBackoffMultiplier(2.0f);
                item.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceCandidatePair.processPermissionTimedout";
                    }

                    @Override
                    public void invoke(ScheduledItem item) {
                        IceCandidatePair.this.processPermissionTimedout(item);
                    }
                });
                this.__relayPermissionsRefreshScheduledItem = item;
                this.__transactionManager.addTransaction(this.__relayPermissionsRefreshScheduledItem, this);
            }
        }
    }

    public void send(DataBuffer buffer) {
        IceCandidate local;
        if (Global.equals((Object)this.getState(), (Object)CandidatePairState.Succeeded) && (local = this.getLocal()) != null) {
            this._bytesSent.add(buffer.getLength());
            local.send(buffer, this.getRemote());
        }
    }

    private void sendConnectivityCheck(ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        if (!state.getCancelled() && !Global.equals((Object)this.getState(), (Object)CandidatePairState.Succeeded)) {
            try {
                this.getLocal().sendStunMessage(item);
            }
            catch (Exception exception) {}
        } else {
            this.__transactionManager.remove(item, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAwaitingOriginalRelayPermissions(boolean value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals(value, this.__awaitingOriginalRelayPermissions)) {
                IAction1<IceCandidatePair> onOriginalRelayPermissionsObtained;
                this.__awaitingOriginalRelayPermissions = value;
                if (!value && (onOriginalRelayPermissionsObtained = this.getOnOriginalRelayPermissionsObtained()) != null) {
                    onOriginalRelayPermissionsObtained.invoke(this);
                }
            }
        }
    }

    private void setError(Error value) {
        this._error = value;
    }

    public void setId(String value) {
        this._id = value;
    }

    void setKeepAliveInterval(int value) {
        this._keepAliveInterval = value;
    }

    void setKeepAliveTimeout(int value) {
        this.__keepAliveTimeout = value;
    }

    void setLocal(IceCandidate value) {
        if (!Global.equals(this.__local, value)) {
            if (this.__local != null) {
                this.__local.removeOnStateChange((IAction1<IceCandidate>)new IActionDelegate1<IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceCandidatePair.processLocalCandidateStateChange";
                    }

                    @Override
                    public void invoke(IceCandidate candidate) {
                        IceCandidatePair.this.processLocalCandidateStateChange(candidate);
                    }
                });
            }
            this.__local = value;
            if (value != null) {
                this.__local.removeOnStateChange((IAction1<IceCandidate>)new IActionDelegate1<IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceCandidatePair.processLocalCandidateStateChange";
                    }

                    @Override
                    public void invoke(IceCandidate candidate) {
                        IceCandidatePair.this.processLocalCandidateStateChange(candidate);
                    }
                });
                this.__local.addOnStateChange((IAction1<IceCandidate>)new IActionDelegate1<IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceCandidatePair.processLocalCandidateStateChange";
                    }

                    @Override
                    public void invoke(IceCandidate candidate) {
                        IceCandidatePair.this.processLocalCandidateStateChange(candidate);
                    }
                });
            }
        }
    }

    void setNominated(boolean value) {
        this._nominated = value;
    }

    void setOnOriginalRelayPermissionsObtained(IAction1<IceCandidatePair> value) {
        this._onOriginalRelayPermissionsObtained = value;
    }

    public void setOnStateChange(IAction1<IceCandidatePair> value) {
        this._onStateChange = value;
    }

    void setOnStunResponse(IAction1<IceSendRequestSuccessArgs> value) {
        this._onStunResponse = value;
    }

    public void setPriority(long value) {
        this._priority = value;
    }

    void setRelatedValidPair(IceCandidatePair value) {
        this._relatedValidPair = value;
    }

    void setRelayConnectionTimeout(int value) {
        if (value > 0) {
            this.__connectionTimeout = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(CandidatePairState value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!(Global.equals((Object)this.__state, (Object)value) || Global.equals((Object)this.__state, (Object)CandidatePairState.Closed) && Global.equals((Object)value, (Object)CandidatePairState.Failed))) {
                this.__state = value;
                if (Global.equals((Object)this.__state, (Object)CandidatePairState.Failed) || Global.equals((Object)this.__state, (Object)CandidatePairState.Closed)) {
                    this.cancelAssociatedTransactions();
                    if (this.__transactionManager != null) {
                        this.__transactionManager.remove(this);
                    }
                    this.getLocal().removeOnStateChange((IAction1<IceCandidate>)new IActionDelegate1<IceCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceCandidatePair.processLocalCandidateStateChange";
                        }

                        @Override
                        public void invoke(IceCandidate candidate) {
                            IceCandidatePair.this.processLocalCandidateStateChange(candidate);
                        }
                    });
                } else if (Global.equals((Object)this.__state, (Object)CandidatePairState.Succeeded) && this.__transactionManager != null) {
                    this.__transactionManager.remove(this.__connectivityCheckScheduledItem, this);
                }
                IAction1<IceCandidatePair> onStateChange = this.getOnStateChange();
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    void setStopCandidatePair(ScheduledItem value) {
        this._stopCandidatePair = value;
    }

    void setUseCandidateReceived(boolean value) {
        this._useCandidateReceived = value;
    }

    void setValid(boolean value) {
        this._valid = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startKeepAlives() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__keepAliveScheduledItem == null) {
                this.__keepAliveActive = true;
                this.__needsKeepAlive = true;
                this.__keepAliveScheduledItem = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceCandidatePair.dispatchKeepAlive";
                    }

                    @Override
                    public void invoke(ScheduledItem item) {
                        IceCandidatePair.this.dispatchKeepAlive(item);
                    }
                }, this.getKeepAliveInterval(), this.getKeepAliveInterval(), ScheduledItem.getUnset(), ScheduledItem.getUnset());
                this.__keepAliveScheduledItem.setState(this.generateKeepAlive());
                this.__transactionManager.addTransaction(this.__keepAliveScheduledItem, this);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startPermissionRequests() {
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.getLocal().getType(), (Object)CandidateType.Relayed) && this.__relayPermissionsRefreshScheduledItem == null) {
                this.__relayPermissionsActive = true;
                this.schedulePermissionExtension(0);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.__lock;
        synchronized (object) {
            this.setStopCandidatePair(null);
            if (!Global.equals((Object)this.getState(), (Object)CandidatePairState.Failed) && !Global.equals((Object)this.getState(), (Object)CandidatePairState.Closed)) {
                this.setState(CandidatePairState.Closed);
            }
        }
    }

    public String toString() {
        try {
            String str;
            String string = Global.equals((Object)this.getLocal().getOperatingProtocol(), (Object)ProtocolType.Udp) ? "Udp" : (str = Global.equals((Object)this.getLocal().getOperatingProtocol(), (Object)ProtocolType.Udp) ? "Tcp" : "Unknown");
            String str2 = Global.equals((Object)this.getRemote().getOperatingProtocol(), (Object)ProtocolType.Udp) ? "Udp" : (Global.equals((Object)this.getRemote().getOperatingProtocol(), (Object)ProtocolType.Udp) ? "Tcp" : "Unknown");
            return StringExtensions.format("{0} {2} ({4}) | {1} {3} ({5})", new Object[]{this.getLocal().toString(), this.getRemote().toString(), this.getLocal().getType().toString(), this.getRemote().getType().toString(), str, str2});
        }
        catch (Exception exception1) {
            return StringExtensions.format("{0}:{1} ({4}) | {2}:{3} ({5})", new Object[]{this.getLocal().getIPAddress(), IntegerExtensions.toString(this.getLocal().getPort()), this.getRemote().getIPAddress(), IntegerExtensions.toString(this.getRemote().getPort()), this.getLocal().getType().toString(), this.getRemote().getType().toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerPermissionExtension(ScheduledItem item) {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__relayPermissionsActive) {
                this.getLocal().sendStunMessage(item);
            }
        }
    }
}

