/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Global;
import fm.icelink.IntegerHolder;
import fm.icelink.LocalNetwork;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.AddressFamily;
import fm.icelink.stun.AlternateServerAttribute;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.SoftwareAttribute;
import fm.icelink.stun.UnknownAttributesAttribute;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.ControllingAttribute;
import fm.icelink.stun.ice.PriorityAttribute;
import fm.icelink.stun.ice.UseCandidateAttribute;
import fm.icelink.stun.turn.ChannelNumberAttribute;
import fm.icelink.stun.turn.ConnectionIdAttribute;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.DontFragmentAttribute;
import fm.icelink.stun.turn.EvenPortAttribute;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RequestedAddressFamilyAttribute;
import fm.icelink.stun.turn.RequestedTransportAttribute;
import fm.icelink.stun.turn.ReservationTokenAttribute;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import fm.icelink.stun.turn.XorRelayedAddressAttribute;

public abstract class Attribute {
    private static String _blankIPv4Address;
    private static byte[] _blankIPv4AddressBytes;
    private static String _blankIPv6Address;
    private static byte[] _blankIPv6AddressBytes;

    protected Attribute() {
    }

    private static Attribute createAttributeFromValue(int typeValue, DataBuffer buffer, int offset, int length, DataBuffer transactionId, DataBuffer messageBuffer) {
        if (typeValue == Attribute.getAlternateServerType()) {
            return AlternateServerAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getErrorCodeType()) {
            return ErrorCodeAttribute.readValueFrom(buffer, offset, length);
        }
        if (typeValue == Attribute.getFingerprintType()) {
            return FingerprintAttribute.readValueFrom(buffer, offset, messageBuffer);
        }
        if (typeValue == Attribute.getMappedAddressType()) {
            return MappedAddressAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getMessageIntegrityType()) {
            return MessageIntegrityAttribute.readValueFrom(buffer, offset, length, messageBuffer);
        }
        if (typeValue == Attribute.getNonceType()) {
            return NonceAttribute.readValueFrom(buffer, offset, length);
        }
        if (typeValue == Attribute.getRealmType()) {
            return RealmAttribute.readValueFrom(buffer, offset, length);
        }
        if (typeValue == Attribute.getSoftwareType()) {
            return SoftwareAttribute.readValueFrom(buffer, offset, length);
        }
        if (typeValue == Attribute.getUnknownAttributesType()) {
            return UnknownAttributesAttribute.readValueFrom(buffer, offset, length);
        }
        if (typeValue == Attribute.getUsernameType()) {
            return UsernameAttribute.readValueFrom(buffer, offset, length);
        }
        if (typeValue == Attribute.getXorMappedAddressType()) {
            return XorMappedAddressAttribute.readValueFrom(buffer, offset, transactionId);
        }
        if (typeValue == Attribute.getControlledType()) {
            return ControlledAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getControllingType()) {
            return ControllingAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getPriorityType()) {
            return PriorityAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getUseCandidateType()) {
            return UseCandidateAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getChannelNumberType()) {
            return ChannelNumberAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getConnectionIdType()) {
            return ConnectionIdAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getDataType()) {
            return DataAttribute.readValueFrom(buffer, offset, length);
        }
        if (typeValue == Attribute.getDontFragmentType()) {
            return DontFragmentAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getEvenPortType()) {
            return EvenPortAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getLifetimeType()) {
            return LifetimeAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getRequestedTransportType()) {
            return RequestedTransportAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getReservationTokenType()) {
            return ReservationTokenAttribute.readValueFrom(buffer, offset);
        }
        if (typeValue == Attribute.getXorPeerAddressType()) {
            return XorPeerAddressAttribute.readValueFrom(buffer, offset, transactionId);
        }
        if (typeValue == Attribute.getXorRelayedAddressType()) {
            return XorRelayedAddressAttribute.readValueFrom(buffer, offset, transactionId);
        }
        if (typeValue == Attribute.getRequestedAddressFamilyType()) {
            return RequestedAddressFamilyAttribute.readValueFrom(buffer, offset);
        }
        return null;
    }

    public static int getAlternateServerType() {
        return 32803;
    }

    public static int getChannelNumberType() {
        return 12;
    }

    public static int getConnectionIdType() {
        return 42;
    }

    public static int getControlledType() {
        return 32809;
    }

    public static int getControllingType() {
        return 32810;
    }

    public static int getDataType() {
        return 19;
    }

    public static int getDontFragmentType() {
        return 26;
    }

    public static int getErrorCodeType() {
        return 9;
    }

    public static int getEvenPortType() {
        return 24;
    }

    public static int getFingerprintType() {
        return 32808;
    }

    public int getLength() {
        int valueLength = this.getValueLength();
        return 4 + this.getValueLength() + this.getPaddingLength(valueLength);
    }

    public static int getLifetimeType() {
        return 13;
    }

    public static int getMappedAddressType() {
        return 1;
    }

    public static int getMessageIntegrityType() {
        return 8;
    }

    public static int getNonceType() {
        return 21;
    }

    public int getPaddingLength(int valueLength) {
        return (4 - valueLength % 4) % 4;
    }

    public static int getPriorityType() {
        return 36;
    }

    public static int getRealmType() {
        return 20;
    }

    public static int getRequestedAddressFamilyType() {
        return 23;
    }

    public static int getRequestedTransportType() {
        return 25;
    }

    public static int getReservationTokenType() {
        return 34;
    }

    public static int getSoftwareType() {
        return 32802;
    }

    public abstract int getTypeValue();

    public static int getUnknownAttributesType() {
        return 10;
    }

    public static int getUseCandidateType() {
        return 37;
    }

    public static int getUsernameType() {
        return 6;
    }

    protected abstract int getValueLength();

    public static int getXorMappedAddressType() {
        return 32;
    }

    public static int getXorPeerAddressType() {
        return 18;
    }

    public static int getXorRelayedAddressType() {
        return 22;
    }

    public static int nextLength(DataBuffer buffer, int offset) {
        if (offset + 4 > buffer.getLength()) {
            return -1;
        }
        int num = 4 + buffer.read16(offset + 2);
        while (num % 4 != 0) {
            ++num;
        }
        return num;
    }

    protected static AddressType readAddressType(DataBuffer buffer, int offset) {
        if (buffer.read8(offset) == AddressFamily.getIPv4()) {
            return AddressType.IPv4;
        }
        if (buffer.read8(offset) == AddressFamily.getIPv6()) {
            return AddressType.IPv6;
        }
        return AddressType.getByAssignedValue(0);
    }

    public static Attribute readFrom(DataBuffer buffer, int offset, IntegerHolder offsetPlus, DataBuffer transactionId, DataBuffer messageBuffer) {
        offsetPlus.setValue(offset + Attribute.nextLength(buffer, offset));
        return Attribute.readFrom(buffer, offset, transactionId, messageBuffer);
    }

    public static Attribute readFrom(DataBuffer buffer, int offset, DataBuffer transactionId, DataBuffer messageBuffer) {
        int length;
        IntegerHolder _var0 = new IntegerHolder(offset);
        int _var1 = buffer.read16(offset, _var0);
        offset = _var0.getValue();
        int typeValue = _var1;
        IntegerHolder _var2 = new IntegerHolder(offset);
        int _var3 = buffer.read16(offset, _var2);
        offset = _var2.getValue();
        Attribute attribute = Attribute.createAttributeFromValue(typeValue, buffer, offset, length = _var3, transactionId, messageBuffer);
        if (attribute != null) {
            return attribute;
        }
        return null;
    }

    protected static String readIPAddress(DataBuffer buffer, int offset, AddressType addressType) {
        int length = Global.equals((Object)addressType, (Object)AddressType.IPv4) ? 4 : 16;
        DataBuffer buffer2 = buffer.subset(offset, length);
        try {
            return TransportAddress.sanitizeIPAddress(LocalNetwork.getAddress(buffer2.toArray()));
        }
        catch (Exception exception1) {
            if (Global.equals((Object)addressType, (Object)AddressType.IPv4)) {
                return _blankIPv4Address;
            }
            return _blankIPv6Address;
        }
    }

    protected static int readPort(DataBuffer buffer, int offset) {
        return buffer.read16(offset);
    }

    protected static String readXorIPAddress(DataBuffer buffer, int offset, AddressType addressType, DataBuffer transactionId) {
        int size = Global.equals((Object)addressType, (Object)AddressType.IPv4) ? 4 : 16;
        DataBuffer ipAddressBuffer = DataBufferPool.getInstance().take(size);
        ipAddressBuffer.write(buffer.subset(offset, size), 0);
        Attribute.xorIPAddress(ipAddressBuffer, transactionId);
        String str = StringExtensions.empty;
        try {
            str = TransportAddress.sanitizeIPAddress(LocalNetwork.getAddress(ipAddressBuffer.toArray()));
        }
        catch (Exception exception1) {
            str = Global.equals((Object)addressType, (Object)AddressType.IPv4) ? _blankIPv4Address : _blankIPv6Address;
        }
        ipAddressBuffer.free();
        return str;
    }

    protected static int readXorPort(DataBuffer buffer, int offset, DataBuffer transactionId) {
        DataBuffer portBuffer = DataBufferPool.getInstance().take(2);
        portBuffer.write(buffer.subset(offset, 2), 0);
        Attribute.xorPort(portBuffer, transactionId);
        int num = portBuffer.read16(0);
        portBuffer.free();
        return num;
    }

    protected static void writeAddressType(DataBuffer buffer, int offset, AddressType addressType) {
        if (Global.equals((Object)addressType, (Object)AddressType.IPv4)) {
            buffer.write8(AddressFamily.getIPv4(), offset);
        } else if (Global.equals((Object)addressType, (Object)AddressType.IPv6)) {
            buffer.write8(AddressFamily.getIPv6(), offset);
        }
    }

    protected void writeIPAddress(DataBuffer buffer, int offset, AddressType addressType, String ipAddress) {
        byte[] addressBytes;
        try {
            addressBytes = LocalNetwork.getAddressBytes(ipAddress);
        }
        catch (Exception exception1) {
            addressBytes = Global.equals((Object)addressType, (Object)AddressType.IPv4) ? _blankIPv4AddressBytes : _blankIPv6AddressBytes;
        }
        buffer.writeBytes(addressBytes, offset);
    }

    protected void writePort(DataBuffer buffer, int offset, int port) {
        buffer.write16(port, offset);
    }

    public void writeTo(DataBuffer buffer, int offset) {
        int typeValue = this.getTypeValue();
        int valueLength = this.getValueLength();
        int paddingLength = this.getPaddingLength(valueLength);
        IntegerHolder _var0 = new IntegerHolder(offset);
        boolean _var1 = buffer.write16(typeValue, offset, _var0);
        offset = _var0.getValue();
        IntegerHolder _var2 = new IntegerHolder(offset);
        boolean _var3 = buffer.write16(valueLength, offset, _var2);
        offset = _var2.getValue();
        this.writeValueTo(buffer, offset);
        offset += valueLength;
        if (paddingLength > 0) {
            buffer.set((byte)0, offset, paddingLength);
        }
    }

    public void writeTo(DataBuffer buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + this.getLength());
        this.writeTo(buffer, offset);
    }

    protected abstract void writeValueTo(DataBuffer var1, int var2);

    protected void writeXorIPAddress(DataBuffer buffer, int offset, AddressType addressType, String ipAddress, DataBuffer transactionId) {
        this.writeIPAddress(buffer, offset, addressType, ipAddress);
        Attribute.xorIPAddress(buffer.subset(offset, Global.equals((Object)addressType, (Object)AddressType.IPv4) ? 4 : 16), transactionId);
    }

    protected void writeXorPort(DataBuffer buffer, int offset, int port, DataBuffer transactionId) {
        this.writePort(buffer, offset, port);
        Attribute.xorPort(buffer.subset(offset, 2), transactionId);
    }

    private static void xorIPAddress(DataBuffer ipAddressBuffer, DataBuffer transactionId) {
        int num;
        for (num = 0; num < ArrayExtensions.getLength(Message.getMagicCookieBytes()); ++num) {
            ipAddressBuffer.write8(ipAddressBuffer.read8(num) ^ Message.getMagicCookieBytes()[num], num);
        }
        if (ipAddressBuffer.getLength() > ArrayExtensions.getLength(Message.getMagicCookieBytes())) {
            for (num = 0; num < transactionId.getLength(); ++num) {
                ipAddressBuffer.write8(ipAddressBuffer.read8(num + ArrayExtensions.getLength(Message.getMagicCookieBytes())) ^ transactionId.read8(num), num + ArrayExtensions.getLength(Message.getMagicCookieBytes()));
            }
        }
    }

    private static void xorPort(DataBuffer portBuffer, DataBuffer transactionId) {
        for (int i = 0; i < portBuffer.getLength(); ++i) {
            portBuffer.write8(portBuffer.read8(i) ^ Message.getMagicCookieBytes()[i], i);
        }
    }

    static {
        _blankIPv4AddressBytes = new byte[]{0, 0, 0, 0};
        _blankIPv4Address = "0.0.0.0";
        _blankIPv6AddressBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        _blankIPv6Address = "0:0:0:0:0:0:0:0";
    }
}

