/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IMediaTransport;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaTransportState;
import fm.icelink.RtpParameters;
import fm.icelink.StringExtensions;
import java.util.ArrayList;
import java.util.List;

abstract class MediaTransport<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
implements IMediaTransport {
    private String __id;
    Object __lock;
    private List<IAction1<MediaControlFrame[]>> __onReceiveControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onReceiveFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<IMediaTransport>> __onStateChange = new ArrayList<IAction1<IMediaTransport>>();
    private RtpParameters<TFormat, TFormatCollection> __parameters = null;
    private boolean __sendingControlFrame = false;
    private boolean __sendingFrame = false;
    MediaTransportState __state;
    private IAction1<MediaControlFrame[]> _onReceiveControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaTransport.this.__onReceiveControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onReceiveFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaTransport.this.__onReceiveFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<IMediaTransport> _onStateChange = new IAction1<IMediaTransport>(){

        @Override
        public void invoke(IMediaTransport p0) {
            for (IAction1 action : new ArrayList(MediaTransport.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };

    public void addOnReceiveControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onReceiveControlFrames.add(value);
    }

    public void addOnReceiveFrame(IAction1<TFrame> value) {
        this.__onReceiveFrame.add(value);
    }

    @Override
    public void addOnStateChange(IAction1<IMediaTransport> value) {
        this.__onStateChange.add(value);
    }

    @Override
    public void addRemoteSynchronizationSource(long remoteSynchronizationSource) {
        if (this.getParameters() != null) {
            this.getParameters().addRemoteSynchronizationSource(remoteSynchronizationSource);
        }
    }

    public abstract void doReceiveControlFrames(MediaControlFrame[] var1);

    public abstract void doReceiveFrame(TFrame var1);

    public abstract void doSendControlFrames(MediaControlFrame[] var1);

    public abstract boolean doSendFrame(TFrame var1);

    public abstract boolean doStart();

    public abstract boolean doStop();

    public TFormat getFormat(String formatName) {
        return ((MediaFormatCollection)this.getParameters().getNegotiatedFormats()).getFirstByName(formatName);
    }

    public TFormat getFormat(int payloadType) {
        if (this.hasPayloadType(payloadType)) {
            return (TFormat)((MediaFormat)HashMapExtensions.getItem(this.getParameters().getPayloadTypeRegistry()).get(payloadType));
        }
        return null;
    }

    @Override
    public String getId() {
        return this.__id;
    }

    public long[] getLocalSynchronizationSources() {
        if (this.getParameters() != null) {
            return this.getParameters().getLocalSynchronizationSources();
        }
        return null;
    }

    public RtpParameters<TFormat, TFormatCollection> getParameters() {
        return this.__parameters;
    }

    public int getPayloadType(String formatName) {
        TFormat format = this.getFormat(formatName);
        if (format != null) {
            return ((MediaFormat)format).getRegisteredPayloadType();
        }
        return -1;
    }

    @Override
    public long[] getRemoteSynchronizationSources() {
        if (this.getParameters() != null) {
            return this.getParameters().getRemoteSynchronizationSources();
        }
        return null;
    }

    @Override
    public MediaTransportState getState() {
        return this.__state;
    }

    @Override
    public boolean hasPayloadType(int payloadType) {
        return this.getParameters().getPayloadTypeRegistry().containsKey(payloadType);
    }

    @Override
    public boolean hasRemoteSynchronizationSource(long synchronizationSource) {
        return this.getParameters() != null && this.getParameters().hasRemoteSynchronizationSource(synchronizationSource);
    }

    public MediaTransport(Object lockObject) {
        this.__id = Guid.newGuid().toString().replace("-", "");
        this.__state = MediaTransportState.New;
        this.__lock = lockObject;
    }

    protected void raiseReceiveControlFrames(MediaControlFrame[] controlFrames) {
        IAction1<MediaControlFrame[]> onReceiveControlFrames = this._onReceiveControlFrames;
        if (onReceiveControlFrames != null) {
            onReceiveControlFrames.invoke(controlFrames);
        }
    }

    protected void raiseReceiveFrame(TFrame frame) {
        IAction1<TFrame> onReceiveFrame = this._onReceiveFrame;
        if (onReceiveFrame != null) {
            onReceiveFrame.invoke(frame);
        }
    }

    protected void raiseStateChange(MediaTransportState state) {
        this.__state = state;
        IAction1<IMediaTransport> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this);
        }
    }

    public void receiveControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
            this.doReceiveControlFrames(controlFrames);
        }
    }

    public void receiveFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
            this.doReceiveFrame(frame);
        }
    }

    public void removeOnReceiveControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveControlFrames.remove(value);
    }

    public void removeOnReceiveFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveFrame.remove(value);
    }

    @Override
    public void removeOnStateChange(IAction1<IMediaTransport> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    public void sendControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
            this.__sendingControlFrame = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
                    this.doSendControlFrames(controlFrames);
                }
            }
            finally {
                this.__sendingControlFrame = false;
            }
        }
    }

    public void sendFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
            this.__sendingFrame = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
                    this.doSendFrame(frame);
                }
            }
            finally {
                this.__sendingFrame = false;
            }
        }
    }

    public void setParameters(RtpParameters<TFormat, TFormatCollection> value) {
        this.__parameters = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)MediaTransportState.Started) && !Global.equals((Object)this.__state, (Object)MediaTransportState.Starting)) {
                this.raiseStateChange(MediaTransportState.Starting);
                if (this.doStart()) {
                    this.raiseStateChange(MediaTransportState.Started);
                    return true;
                }
                this.raiseStateChange(MediaTransportState.Failed);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stop() {
        Object obj2;
        Object object = obj2 = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
                return false;
            }
            this.raiseStateChange(MediaTransportState.Stopping);
        }
        while (this.__sendingFrame || this.__sendingControlFrame) {
            ManagedThread.sleep(1);
        }
        object = obj2 = this.__lock;
        synchronized (object) {
            boolean flag;
            try {
                if (this.doStop()) {
                    Log.debug(StringExtensions.format("MediaTransport {0} shut down gracefully.", this.getId()));
                    boolean bl = true;
                    return bl;
                }
                Log.debug(StringExtensions.format("MediaTransport {0} requires force shut down.", this.getId()));
                flag = false;
            }
            finally {
                this.raiseStateChange(MediaTransportState.Stopped);
            }
            return flag;
        }
    }
}

