/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioConfig;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.MediaFormat;

public class AudioFormat
extends MediaFormat<AudioFormat> {
    private int _channelCount;
    private boolean _littleEndian;

    public AudioFormat(String name, int clockRate, int channelCount) {
        super(name, clockRate);
        this.setChannelCount(channelCount);
    }

    public AudioFormat(String name, AudioConfig config) {
        this(name, config.getClockRate(), config.getChannelCount());
    }

    protected AudioFormat() {
    }

    @Override
    public AudioFormat clone() {
        AudioFormat format = (AudioFormat)super.clone();
        format.setChannelCount(this.getChannelCount());
        format.setLittleEndian(this.getLittleEndian());
        return format;
    }

    @Override
    protected AudioFormat createInstance() {
        return new AudioFormat();
    }

    public int getChannelCount() {
        return this._channelCount;
    }

    public AudioConfig getConfig() {
        return new AudioConfig(super.getClockRate(), this.getChannelCount());
    }

    public boolean getIsPcm() {
        return Global.equals(super.getName(), AudioFormat.getPcmName());
    }

    public boolean getLittleEndian() {
        return this._littleEndian;
    }

    public static String getOpusName() {
        return "opus";
    }

    @Override
    public String getParameters() {
        int channelCount = this.getChannelCount();
        if (channelCount == 1) {
            return null;
        }
        return IntegerExtensions.toString(channelCount);
    }

    public static String getPcmaName() {
        return "PCMA";
    }

    public static String getPcmName() {
        return "PCM";
    }

    public static String getPcmuName() {
        return "PCMU";
    }

    @Override
    public boolean isEquivalent(AudioFormat format, boolean ignoreIsPacketized) {
        return super.isEquivalent(format, ignoreIsPacketized) && this.getChannelCount() == format.getChannelCount();
    }

    public void setChannelCount(int value) {
        this._channelCount = value;
    }

    public void setLittleEndian(boolean value) {
        this._littleEndian = value;
    }
}

