/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.ArrayExtensions;
import fm.Binary;
import fm.BitAssistant;
import fm.File;

public class FileStream {
    private File __file;
    private boolean _littleEndian;

    public FileStream(File file) {
        this.__file = file;
    }

    public File getFile() {
        return this.__file;
    }

    public boolean getLittleEndian() {
        return this._littleEndian;
    }

    private byte[] getValue(int length, int count) throws Exception {
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = 0;
        }
        int num2 = this.getLittleEndian() ? this.getFile().read(data, 0, count) : this.getFile().read(data, length - count, count);
        if (num2 != count) {
            throw new Exception("Cannot read value beyond end of File.");
        }
        return data;
    }

    private byte[] getValue32(int count) throws Exception {
        return this.getValue(4, count);
    }

    private byte[] getValue64(int count) throws Exception {
        return this.getValue(8, count);
    }

    public byte[] read(int length) {
        byte[] data = new byte[length];
        int count = this.getFile().read(data, 0, length);
        if (count != length) {
            data = BitAssistant.subArray(data, 0, count);
        }
        return data;
    }

    public int read16() throws Exception {
        return Binary.fromBytes16(this.getValue32(2), 0, this.getLittleEndian());
    }

    public int read24() throws Exception {
        return Binary.fromBytes24(this.getValue32(3), 0, this.getLittleEndian());
    }

    public long read32() throws Exception {
        return Binary.fromBytes32(this.getValue64(4), 0, this.getLittleEndian());
    }

    public long read40() throws Exception {
        return Binary.fromBytes40(this.getValue64(5), 0, this.getLittleEndian());
    }

    public long read48() throws Exception {
        return Binary.fromBytes48(this.getValue64(6), 0, this.getLittleEndian());
    }

    public long read56() throws Exception {
        return Binary.fromBytes56(this.getValue64(7), 0, this.getLittleEndian());
    }

    public long read64() throws Exception {
        return Binary.fromBytes64(this.getValue64(8), 0, this.getLittleEndian());
    }

    public int read8() {
        byte[] data = new byte[1];
        this.getFile().read(data, 0, 1);
        return data[0];
    }

    public byte[] readOpaque16() throws Exception {
        int length = this.read16();
        if (length < 0) {
            return null;
        }
        return this.read(length);
    }

    public byte[] readOpaque24() throws Exception {
        int length = this.read24();
        if (length < 0) {
            return null;
        }
        return this.read(length);
    }

    public byte[] readOpaque32() throws Exception {
        int length = (int)this.read32();
        if (length < 0) {
            return null;
        }
        return this.read(length);
    }

    public byte[] readOpaque8() {
        int length = this.read8();
        if (length < 0) {
            return null;
        }
        return this.read(length);
    }

    public void setLittleEndian(boolean value) {
        this._littleEndian = value;
    }

    public void write(byte[] value) {
        this.getFile().write(value, 0, ArrayExtensions.getLength(value));
    }

    public void write16(int value) {
        this.write(Binary.toBytes16(value, this.getLittleEndian()));
    }

    public void write16To(int location, int value) {
        this.writeTo(location, Binary.toBytes16(value, this.getLittleEndian()));
    }

    public void write24(int value) {
        this.write(Binary.toBytes24(value, this.getLittleEndian()));
    }

    public void write24To(int location, int value) {
        this.writeTo(location, Binary.toBytes24(value, this.getLittleEndian()));
    }

    public void write32(long value) {
        this.write(Binary.toBytes32(value, this.getLittleEndian()));
    }

    public void write32To(int location, long value) {
        this.writeTo(location, Binary.toBytes32(value, this.getLittleEndian()));
    }

    public void write40(long value) {
        this.write(Binary.toBytes40(value, this.getLittleEndian()));
    }

    public void write40To(int location, long value) {
        this.writeTo(location, Binary.toBytes40(value, this.getLittleEndian()));
    }

    public void write48(long value) {
        this.write(Binary.toBytes48(value, this.getLittleEndian()));
    }

    public void write48To(int location, long value) {
        this.writeTo(location, Binary.toBytes48(value, this.getLittleEndian()));
    }

    public void write56(long value) {
        this.write(Binary.toBytes56(value, this.getLittleEndian()));
    }

    public void write56To(int location, long value) {
        this.writeTo(location, Binary.toBytes56(value, this.getLittleEndian()));
    }

    public void write64(long value) {
        this.write(Binary.toBytes64(value, this.getLittleEndian()));
    }

    public void write64To(int location, long value) {
        this.writeTo(location, Binary.toBytes64(value, this.getLittleEndian()));
    }

    public void write8(int value) {
        this.write(new byte[]{(byte)value});
    }

    public void write8To(int location, int value) {
        this.writeTo(location, new byte[]{(byte)value});
    }

    public void writeOpaque16(byte[] value) {
        this.write16(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque16To(int location, byte[] value) {
        this.write16To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 2, value);
    }

    public void writeOpaque24(byte[] value) {
        this.write24(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque24To(int location, byte[] value) {
        this.write24To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 3, value);
    }

    public void writeOpaque32(byte[] value) {
        this.write32(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque32To(int location, byte[] value) {
        this.write32To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 4, value);
    }

    public void writeOpaque40(byte[] value) {
        this.write40(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque40To(int location, byte[] value) {
        this.write40To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 5, value);
    }

    public void writeOpaque48(byte[] value) {
        this.write48(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque48To(int location, byte[] value) {
        this.write48To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 6, value);
    }

    public void writeOpaque56(byte[] value) {
        this.write56(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque56To(int location, byte[] value) {
        this.write56To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 7, value);
    }

    public void writeOpaque64(byte[] value) {
        this.write64(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque64To(int location, byte[] value) {
        this.write64To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 8, value);
    }

    public void writeOpaque8(byte[] value) {
        this.write8(ArrayExtensions.getLength(value));
        this.write(value);
    }

    public void writeOpaque8To(int location, byte[] value) {
        this.write8To(location, ArrayExtensions.getLength(value));
        this.writeTo(location + 1, value);
    }

    public void writeTo(int location, byte[] value) {
        this.getFile().writeTo(location, value, 0, ArrayExtensions.getLength(value));
    }
}

