/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.Log;
import java.util.Arrays;

public class CharacterCollection {
    private char[] _list;
    private int _length;

    public void add(char b) {
        try {
            this.append(b);
        }
        catch (Exception ex) {
            Log.error("Could not add(char).", ex);
        }
    }

    public void addRange(char[] buffer) {
        if (buffer != null) {
            try {
                this.append(buffer, buffer.length);
            }
            catch (Exception ex) {
                Log.error("Could not addRange(char[]).", ex);
            }
        }
    }

    public void addRange(CharacterCollection collection) {
        if (collection != null) {
            try {
                this.append(collection._list, collection._length);
            }
            catch (Exception ex) {
                Log.error("Could not addRange(CharacterCollection).", ex);
            }
        }
    }

    public CharacterCollection() {
    }

    public CharacterCollection(char[] buffer) {
        this.addRange(buffer);
    }

    public char get(int index) {
        if (this._list != null && index < this._list.length) {
            return this._list[index];
        }
        return '\u0000';
    }

    public int getCount() {
        return this._length;
    }

    public char[] getRange(int index, int count) {
        return Arrays.copyOfRange(this._list, index, index + count);
    }

    public void insertRange(int index, char[] buffer) {
        if (buffer != null) {
            try {
                this.insert(buffer, buffer.length, index);
            }
            catch (Exception ex) {
                Log.error("Could not insertRange(int,char[]).", ex);
            }
        }
    }

    public void insertRange(int index, CharacterCollection collection) {
        if (collection != null) {
            try {
                this.insert(collection._list, collection._length, index);
            }
            catch (Exception ex) {
                Log.error("Could not insertRange(int,CharacterCollection).", ex);
            }
        }
    }

    public void removeRange(int index, int count) {
        try {
            this.remove(count, index);
        }
        catch (Exception ex) {
            Log.error("Could not removeRange(int,int).", ex);
        }
    }

    public char[] toArray() {
        if (this._list == null) {
            return new char[0];
        }
        if (this._list.length == this._length) {
            return this._list;
        }
        return this.getRange(0, this._length);
    }

    private void append(char value) {
        if (this._list == null) {
            this._list = new char[4];
            this._list[0] = value;
            this._length = 1;
        } else {
            int minLength = this._length + 1;
            if (minLength > this._list.length) {
                char[] newlist = this.createBiggerArray(minLength);
                System.arraycopy(this._list, 0, newlist, 0, this._list.length);
                this._list = newlist;
            }
            this._list[this._length] = value;
            ++this._length;
        }
    }

    private void append(char[] buffer, int length) {
        if (buffer != null) {
            if (this._list == null) {
                this._list = buffer;
                this._length = length;
            } else {
                int minLength = this._length + length;
                if (minLength > this._list.length) {
                    char[] newlist = this.createBiggerArray(minLength);
                    System.arraycopy(this._list, 0, newlist, 0, this._list.length);
                    this._list = newlist;
                }
                System.arraycopy(buffer, 0, this._list, this._length, length);
                this._length += length;
            }
        }
    }

    private void insert(char[] buffer, int length, int position) {
        if (buffer != null) {
            if (this._list == null) {
                this._list = buffer;
                this._length = length;
            } else {
                int bpos = position;
                int blength = this._length - bpos;
                int minLength = this._length + length;
                if (minLength > this._list.length) {
                    int apos = 0;
                    int alength = position;
                    char[] newlist = this.createBiggerArray(minLength);
                    int offset = 0;
                    System.arraycopy(this._list, apos, newlist, offset, alength);
                    System.arraycopy(buffer, 0, newlist, offset += alength, length);
                    System.arraycopy(this._list, bpos, newlist, offset += length, blength);
                    this._list = newlist;
                } else {
                    System.arraycopy(this._list, bpos, this._list, position + length, blength);
                    System.arraycopy(buffer, 0, this._list, position, length);
                }
                this._length += length;
            }
        }
    }

    private void remove(int length, int position) {
        if (this._list != null) {
            int bpos = position + length;
            int blength = this._length - bpos;
            System.arraycopy(this._list, bpos, this._list, position, blength);
            this._length -= length;
        }
    }

    private char[] createBiggerArray(int minLength) {
        int newLength;
        for (newLength = this._list.length; newLength < minLength; newLength *= 2) {
        }
        return new char[newLength];
    }
}

