/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Looper;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import fm.icelink.IAction0;
import fm.icelink.LayoutFrame;
import fm.icelink.LayoutScale;
import fm.icelink.Log;
import fm.icelink.android.Utility;

public class CameraPreview
implements TextureView.SurfaceTextureListener,
View.OnLayoutChangeListener {
    private LayoutScale _scale;
    private Camera _camera;
    private Context _context;
    private TextureView _cameraView;
    private ViewGroup _cameraViewContainer;
    private Object _cameraLock = new Object();
    private boolean muted = false;
    private int cameraRotation = 0;

    public Context getContext() {
        return this._context;
    }

    public LayoutScale getViewScale() {
        return this._scale;
    }

    public void setViewScale(LayoutScale scale) {
        this._scale = scale;
    }

    protected TextureView getCameraView() {
        return this._cameraView;
    }

    public View getView() {
        return this._cameraViewContainer;
    }

    public void setMuted(final boolean muted) {
        if (this.muted != muted) {
            this.muted = muted;
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (muted) {
                        CameraPreview.this._cameraViewContainer.setAlpha(0.0f);
                    } else {
                        CameraPreview.this._cameraViewContainer.setAlpha(1.0f);
                    }
                }
            });
        }
    }

    public boolean getMuted() {
        return this.muted;
    }

    public CameraPreview(Context context, LayoutScale scale) {
        this._scale = scale;
        if (context == null) {
            throw new RuntimeException("Context cannot be null.");
        }
        this._context = context.getApplicationContext();
        final CameraPreview stl = this;
        final CameraPreview olcl = this;
        Utility.dispatchToMainThread(new IAction0(){

            public void invoke() {
                CameraPreview.this._cameraView = new TextureView(CameraPreview.this._context);
                CameraPreview.this._cameraViewContainer = (ViewGroup)new FrameLayout(CameraPreview.this._context);
                CameraPreview.this._cameraViewContainer.addView((View)CameraPreview.this._cameraView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                CameraPreview.this._cameraViewContainer.addOnLayoutChangeListener(olcl);
                CameraPreview.this._cameraView.setSurfaceTextureListener(stl);
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCamera(Camera camera) {
        if (camera != null) {
            Object object = this._cameraLock;
            synchronized (object) {
                this._camera = camera;
                SurfaceTexture surface = this._cameraView.getSurfaceTexture();
                if (surface != null) {
                    this.startPreview(surface);
                } else {
                    this.updateSurfaceSize();
                }
            }
        } else {
            this.stopPreview();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.startPreview(surface);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.stopPreview();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            this.updateSurfaceSize();
        }
    }

    protected void updateSurfaceSize() {
        Utility.dispatchToMainThread(new IAction0(){

            public void invoke() {
                try {
                    int layoutWidth = 0;
                    int layoutHeight = 0;
                    ViewGroup.LayoutParams layoutParams = CameraPreview.this._cameraViewContainer.getLayoutParams();
                    if (layoutParams != null) {
                        layoutWidth = layoutParams.width;
                        layoutHeight = layoutParams.height;
                    }
                    if (layoutWidth < 0 || layoutHeight < 0) {
                        layoutWidth = CameraPreview.this._cameraViewContainer.getWidth();
                        layoutHeight = CameraPreview.this._cameraViewContainer.getHeight();
                    }
                    if (layoutWidth < 0 || layoutHeight < 0) {
                        layoutWidth = CameraPreview.this._cameraViewContainer.getMeasuredWidth();
                        layoutHeight = CameraPreview.this._cameraViewContainer.getMeasuredHeight();
                    }
                    if (layoutWidth > 0 && layoutHeight > 0 && CameraPreview.this._camera != null) {
                        Camera.Parameters cameraParams = CameraPreview.this._camera.getParameters();
                        Camera.Size cameraSize = cameraParams.getPreviewSize();
                        int cameraWidth = cameraSize.width;
                        int cameraHeight = cameraSize.height;
                        if (cameraWidth > 0 && cameraHeight > 0) {
                            if (CameraPreview.this.cameraRotation % 180 != 0) {
                                int temp = cameraWidth;
                                cameraWidth = cameraHeight;
                                cameraHeight = temp;
                            }
                            LayoutFrame frame = LayoutFrame.getScaledFrame((LayoutScale)CameraPreview.this._scale, (int)layoutWidth, (int)layoutHeight, (int)cameraWidth, (int)cameraHeight);
                            int x = frame.getX();
                            int y = frame.getY();
                            int width = frame.getWidth();
                            int height = frame.getHeight();
                            CameraPreview.this._cameraView.setX((float)x);
                            CameraPreview.this._cameraView.setY((float)y);
                            ViewGroup.LayoutParams cvlp = CameraPreview.this._cameraView.getLayoutParams();
                            cvlp.width = width;
                            cvlp.height = height;
                            CameraPreview.this._cameraView.setLayoutParams(cvlp);
                        }
                    }
                }
                catch (Exception ex) {
                    Log.error((String)"Could not update camera preview surface size.", (Exception)ex);
                }
            }
        });
    }

    protected void setCameraRotation(int cameraRotation) {
        this.cameraRotation = cameraRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPreview(SurfaceTexture surface) {
        Object object = this._cameraLock;
        synchronized (object) {
            if (this._camera != null) {
                try {
                    this._camera.setPreviewTexture(surface);
                    this._camera.startPreview();
                    this.updateSurfaceSize();
                }
                catch (Exception ex) {
                    Log.error((String)"Could not start camera preview.", (Exception)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPreview() {
        Object object = this._cameraLock;
        synchronized (object) {
            if (this._camera != null) {
                try {
                    this._camera.stopPreview();
                    this._camera = null;
                }
                catch (Exception ex) {
                    Log.error((String)"Could not stop camera preview.", (Exception)ex);
                }
            }
        }
    }
}

