/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Global;
import fm.icelink.Log;
import java.util.Arrays;
import java.util.HashMap;

class Native
extends fm.icelink.Native {
    long _encoderState;
    long _decoderState;
    int _FecPacketLossPercentage;
    boolean _FecEnabled;
    static HashMap<Integer, DataBuffer> allocMap;

    public void setFecPacketLossPercentage(int value) {
        this._FecPacketLossPercentage = value;
    }

    public int getFecPacketLossPercentage() {
        return this._FecPacketLossPercentage;
    }

    public boolean getFecEnabled() {
        return this._FecEnabled;
    }

    public void setFecEnabled(boolean value) {
        this._FecEnabled = value;
        if (this._FecEnabled) {
            Native.OpusFMEncoderActivateFec(this._encoderState, this._FecPacketLossPercentage);
        } else {
            Native.OpusFMEncoderDeactivateFec(this._encoderState);
        }
    }

    public int getBitrate() {
        return Native.OpusFMEncoderGetBitrate(this._encoderState);
    }

    public void setBitrate(int value) {
        Native.OpusFMEncoderSetBitrate(this._encoderState, value);
    }

    public double getQuality() {
        return Native.OpusFMEncoderGetQuality(this._encoderState);
    }

    public void setQuality(double value) {
        Native.OpusFMEncoderSetQuality(this._encoderState, value);
    }

    public Native(boolean encoder, int clockRate, int channelCount, double packetTime) {
        this._encoderState = Native.OpusFMEncoderCreate(0L, 0L, 0L, 0L, clockRate, channelCount, packetTime);
        this._decoderState = Native.OpusFMDecoderCreate(0L, 0L, 0L, 0L, clockRate, channelCount, packetTime);
        if (this._encoderState == 0L) {
            throw new RuntimeException("Could not create Opusfm encoder.");
        }
        if (this._decoderState == 0L) {
            throw new RuntimeException("Could not create Opusfm decoder.");
        }
        this.setBitrate(125);
        this.setQuality(0.5);
    }

    public void destroy() {
        Native.OpusFMEncoderDestroy(this._encoderState);
        this._encoderState = 0L;
        Native.OpusFMDecoderDestroy(this._decoderState);
        this._decoderState = 0L;
    }

    public AudioBuffer encode(AudioBuffer buffer, AudioFormat outputFormat) {
        int bufferCount = buffer.getDataBuffers().length;
        if (bufferCount > 0) {
            if (bufferCount > 1) {
                throw new RuntimeException("Cannot encode more than one sample at a time. AudioBuffer must contain only one DataBuffer.");
            }
            DataBuffer pcm = buffer.getDataBuffer();
            int index = pcm.getIndex();
            int length = pcm.getLength();
            int[] encodedLength = new int[1];
            byte[] outputData = Native.OpusFMEncoderEncode(this._encoderState, pcm.getData(), length, index, encodedLength);
            if (outputData != null && encodedLength[0] > 0) {
                DataBuffer outputDataBuffer = Native.getBuffer(outputData).subset(0, encodedLength[0]);
                outputDataBuffer.setLittleEndian(outputFormat.getLittleEndian());
                return new AudioBuffer(outputDataBuffer, outputFormat);
            }
        }
        return null;
    }

    public AudioBuffer decode(AudioBuffer encodedFrame, AudioFormat outputFormat, boolean fec) {
        byte[] outputData;
        int[] lengthArray = new int[1];
        if (encodedFrame != null) {
            DataBuffer buffer = encodedFrame.getDataBuffers()[0];
            outputData = Native.OpusFMDecoderDecodeFec(this._decoderState, Arrays.copyOfRange(buffer.getData(), buffer.getIndex(), buffer.getLength() + buffer.getIndex()), encodedFrame.getDataBuffers()[0].getLength(), lengthArray, fec);
        } else {
            outputData = Native.OpusFMDecoderDecodeFec(this._decoderState, null, 0, lengthArray, fec);
        }
        if (outputData != null && lengthArray[0] > 0) {
            DataBuffer outputDataBuffer = Native.getBuffer(outputData);
            outputDataBuffer.setLittleEndian(outputFormat.getLittleEndian());
            return new AudioBuffer(outputDataBuffer, outputFormat);
        }
        return null;
    }

    private static void DebugCallback(String msg) {
        Log.info((String)("LibOpusFM: " + msg));
    }

    private static void ErrorCallback(String msg) {
        Log.error((String)("LibOpusFM: " + msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] AllocCallback(int size) {
        HashMap<Integer, DataBuffer> hashMap = allocMap;
        synchronized (hashMap) {
            DataBuffer buffer = DataBufferPool.getInstance().take(size);
            byte[] data = buffer.getData();
            allocMap.put(data.hashCode(), buffer);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataBuffer getBuffer(byte[] data) {
        HashMap<Integer, DataBuffer> hashMap = allocMap;
        synchronized (hashMap) {
            DataBuffer buffer = allocMap.remove(data.hashCode());
            return buffer;
        }
    }

    private static native int OpusFMEncoderGetBitrate(long var0);

    private static native void OpusFMEncoderSetBitrate(long var0, int var2);

    private static native double OpusFMEncoderGetQuality(long var0);

    private static native void OpusFMEncoderSetQuality(long var0, double var2);

    private static native long OpusFMEncoderCreate(long var0, long var2, long var4, long var6, int var8, int var9, double var10);

    private static native void OpusFMEncoderActivateFec(long var0, int var2);

    private static native void OpusFMEncoderDeactivateFec(long var0);

    private static native void OpusFMEncoderDestroy(long var0);

    private static native byte[] OpusFMEncoderEncode(long var0, byte[] var2, int var3, int var4, int[] var5);

    private static native long OpusFMDecoderCreate(long var0, long var2, long var4, long var6, int var8, int var9, double var10);

    private static native void OpusFMDecoderDestroy(long var0);

    private static native byte[] OpusFMDecoderDecode(long var0, byte[] var2, int var3, int[] var4);

    private static native byte[] OpusFMDecoderDecodeFec(long var0, byte[] var2, int var3, int[] var4, boolean var5);

    static {
        Global.loadLibrary((String)"opus-0");
        Global.loadLibrary((String)"opusfmJNI");
        allocMap = new HashMap();
    }
}

