/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private int[][][] M;

    @Override
    public void init(byte[] H) {
        if (this.M == null) {
            this.M = new int[16][256][4];
        } else if (Arrays.areEqual(this.H, H)) {
            return;
        }
        this.H = Arrays.clone(H);
        GCMUtil.asInts(H, this.M[0][128]);
        int j = 64;
        while (j >= 1) {
            GCMUtil.multiplyP(this.M[0][j + j], this.M[0][j]);
            j >>= 1;
        }
        int i = 0;
        block1: while (true) {
            int j2 = 2;
            while (j2 < 256) {
                int k = 1;
                while (k < j2) {
                    GCMUtil.xor(this.M[i][j2], this.M[i][k], this.M[i][j2 + k]);
                    ++k;
                }
                j2 += j2;
            }
            if (++i == 16) {
                return;
            }
            j2 = 128;
            while (true) {
                if (j2 <= 0) continue block1;
                GCMUtil.multiplyP8(this.M[i - 1][j2], this.M[i][j2]);
                j2 >>= 1;
            }
            break;
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        int[] z = new int[4];
        int i = 15;
        while (i >= 0) {
            int[] m = this.M[i][x[i] & 0xFF];
            z[0] = z[0] ^ m[0];
            z[1] = z[1] ^ m[1];
            z[2] = z[2] ^ m[2];
            z[3] = z[3] ^ m[3];
            --i;
        }
        Pack.intToBigEndian(z, x, 0);
    }
}

