/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp8;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IVideoOutput;
import fm.icelink.MathAssistant;
import fm.icelink.RtpPacket;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPacketizer;
import fm.icelink.vp8.Format;
import fm.icelink.vp8.Packet;
import java.util.ArrayList;

public class Packetizer
extends VideoPacketizer {
    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer = this.packetize(inputBuffer, frame.getTimestamp());
        if (buffer != null) {
            frame.addBuffer(buffer);
            this.raiseFrame(frame);
        }
    }

    public static int getHeaderPadding() {
        return 20;
    }

    @Override
    public String getLabel() {
        return "VP8 Packetizer";
    }

    public static int getMaxPacketSize() {
        return 1050;
    }

    private VideoBuffer packetize(VideoBuffer encodedBuffer, long timestamp) {
        int num6;
        ArrayList<Packet> list = new ArrayList<Packet>();
        int num = Packetizer.getMaxPacketSize() - 1;
        int num2 = (int)MathAssistant.ceil((double)encodedBuffer.getDataBuffer().getLength() / (double)num);
        if (num2 == 0) {
            num2 = 1;
        }
        if (num2 == 1) {
            list.add(new Packet(encodedBuffer.getDataBuffer(), true));
        } else {
            int num3 = encodedBuffer.getDataBuffer().getLength() / num2;
            int num4 = encodedBuffer.getDataBuffer().getLength() - num2 * num3;
            int offset = 0;
            for (num6 = 0; num6 < num2; ++num6) {
                int length = num3;
                if (num6 < num4) {
                    ++length;
                }
                list.add(new Packet(encodedBuffer.getDataBuffer().subset(offset, length), num6 == 0));
                offset += length;
            }
        }
        DataBuffer[] dataBuffers = new DataBuffer[ArrayListExtensions.getCount(list)];
        for (num6 = 0; num6 < ArrayListExtensions.getCount(list); ++num6) {
            RtpPacket packet = new RtpPacket(((Packet)ArrayListExtensions.getItem(list).get(num6)).getBuffer());
            packet.setMarker(num6 == ArrayListExtensions.getCount(list) - 1);
            dataBuffers[num6] = packet.getBuffer();
        }
        VideoFormat format = ((VideoFormat)encodedBuffer.getFormat()).clone();
        format.setIsPacketized(true);
        return new VideoBuffer(encodedBuffer.getWidth(), encodedBuffer.getHeight(), dataBuffers, format);
    }

    public Packetizer(IVideoOutput input) {
        this();
        super.addInput(input);
    }

    public Packetizer() {
        super(new Format());
    }
}

