/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DateExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import java.util.Date;

class TurnChannelBinding {
    private TransportAddress _address;
    private int _channelNumber;
    private Date _expires = new Date();

    public void extendTimeToExpiry() {
        this.setTimeToExpiry(600);
    }

    public TransportAddress getAddress() {
        return this._address;
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    public boolean getIsExpired() {
        return DateExtensions.getTicks(DateExtensions.getUtcNow()) > DateExtensions.getTicks(this._expires);
    }

    public int getTimeToExpiry() {
        return (int)((DateExtensions.getTicks(this._expires) - DateExtensions.getTicks(DateExtensions.getUtcNow())) / 10000000L);
    }

    private void setAddress(TransportAddress value) {
        this._address = value;
    }

    private void setChannelNumber(int value) {
        this._channelNumber = value;
    }

    private void setTimeToExpiry(int timeToExpiry) {
        this._expires = DateExtensions.addSeconds(DateExtensions.getUtcNow(), timeToExpiry);
    }

    public String toString() {
        return StringExtensions.format("{0}:{1}", IntegerExtensions.toString(this.getChannelNumber()), this.getAddress().toString());
    }

    public TurnChannelBinding(TransportAddress address, int channelNumber) {
        this.setAddress(address);
        this.setChannelNumber(channelNumber);
        this.extendTimeToExpiry();
    }
}

