/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum TrickleIcePolicy {
    NotSupported(1),
    FullTrickle(2),
    HalfTrickle(3);

    private final int value;
    private static final Map<Integer, TrickleIcePolicy> lookup;

    private TrickleIcePolicy(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static TrickleIcePolicy getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, TrickleIcePolicy>();
        for (TrickleIcePolicy s : EnumSet.allOf(TrickleIcePolicy.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

