/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.CandidatePairStats;
import fm.icelink.CandidateStats;
import fm.icelink.CertificateStats;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableLong;
import java.util.HashMap;

public class TransportStats
extends BaseStats {
    private CandidatePairStats _activeCandidatePair;
    private long _bytesReceived;
    private long _bytesSent;
    private CandidatePairStats[] _candidatePairs;
    private CandidateStats[] _localCandidates;
    private CertificateStats _localCertificate;
    private CandidateStats[] _remoteCandidates;
    private CertificateStats _remoteCertificate;
    private TransportStats _rtcpTransport;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String _var0 = key;
        if (_var0.equals("bytesSent")) {
            this.setBytesSent(JsonSerializer.deserializeInteger(valueJson).getValue());
        } else if (_var0.equals("bytesReceived")) {
            this.setBytesReceived(JsonSerializer.deserializeInteger(valueJson).getValue());
        } else if (_var0.equals("rtcpTransport")) {
            this.setRtcpTransport(TransportStats.fromJson(valueJson));
        } else if (_var0.equals("localCandidates")) {
            this.setLocalCandidates(CandidateStats.fromJsonArray(valueJson));
        } else if (_var0.equals("remoteCandidates")) {
            this.setRemoteCandidates(CandidateStats.fromJsonArray(valueJson));
        } else if (_var0.equals("candidatePairs")) {
            this.setCandidatePairs(CandidatePairStats.fromJsonArray(valueJson));
        } else if (_var0.equals("activeCandidatePair")) {
            this.setActiveCandidatePair(CandidatePairStats.fromJson(valueJson));
        } else if (_var0.equals("localCertificate")) {
            this.setLocalCertificate(CertificateStats.fromJson(valueJson));
        } else if (_var0.equals("remoteCertificate")) {
            this.setRemoteCertificate(CertificateStats.fromJson(valueJson));
        }
    }

    public static TransportStats fromJson(String transportJson) {
        return JsonSerializer.deserializeObject(transportJson, new IFunction0<TransportStats>(){

            @Override
            public TransportStats invoke() {
                return new TransportStats();
            }
        }, new IAction3<TransportStats, String, String>(){

            @Override
            public void invoke(TransportStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public CandidatePairStats getActiveCandidatePair() {
        return this._activeCandidatePair;
    }

    public long getBytesReceived() {
        return this._bytesReceived;
    }

    public long getBytesSent() {
        return this._bytesSent;
    }

    public CandidatePairStats getCandidatePair(String candidatePairId) {
        for (CandidatePairStats stats : this.getCandidatePairs()) {
            if (!Global.equals(stats.getId(), candidatePairId)) continue;
            return stats;
        }
        return null;
    }

    public CandidatePairStats[] getCandidatePairs() {
        return this._candidatePairs;
    }

    public boolean getIsHost() {
        CandidatePairStats activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair == null) {
            return false;
        }
        CandidateStats localCandidate = this.getLocalCandidate(activeCandidatePair.getLocalCandidateId());
        CandidateStats remoteCandidate = this.getRemoteCandidate(activeCandidatePair.getRemoteCandidateId());
        return localCandidate != null && localCandidate.getIsHost() || remoteCandidate != null && remoteCandidate.getIsHost();
    }

    public boolean getIsReflexive() {
        CandidatePairStats activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair == null) {
            return false;
        }
        CandidateStats localCandidate = this.getLocalCandidate(activeCandidatePair.getLocalCandidateId());
        CandidateStats remoteCandidate = this.getRemoteCandidate(activeCandidatePair.getRemoteCandidateId());
        return localCandidate != null && localCandidate.getIsReflexive() || remoteCandidate != null && remoteCandidate.getIsReflexive();
    }

    public boolean getIsRelayed() {
        CandidatePairStats activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair == null) {
            return false;
        }
        CandidateStats localCandidate = this.getLocalCandidate(activeCandidatePair.getLocalCandidateId());
        CandidateStats remoteCandidate = this.getRemoteCandidate(activeCandidatePair.getRemoteCandidateId());
        return localCandidate != null && localCandidate.getIsRelayed() || remoteCandidate != null && remoteCandidate.getIsRelayed();
    }

    public CandidateStats getLocalCandidate(String candidateId) {
        for (CandidateStats stats : this.getLocalCandidates()) {
            if (!Global.equals(stats.getId(), candidateId)) continue;
            return stats;
        }
        return null;
    }

    public CandidateStats[] getLocalCandidates() {
        return this._localCandidates;
    }

    public CertificateStats getLocalCertificate() {
        return this._localCertificate;
    }

    public CandidateStats getRemoteCandidate(String candidateId) {
        for (CandidateStats stats : this.getRemoteCandidates()) {
            if (!Global.equals(stats.getId(), candidateId)) continue;
            return stats;
        }
        return null;
    }

    public CandidateStats[] getRemoteCandidates() {
        return this._remoteCandidates;
    }

    public CertificateStats getRemoteCertificate() {
        return this._remoteCertificate;
    }

    public TransportStats getRtcpTransport() {
        return this._rtcpTransport;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesSent", JsonSerializer.serializeLong(new NullableLong(this.getBytesSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "bytesReceived", JsonSerializer.serializeLong(new NullableLong(this.getBytesReceived())));
        if (this.getRtcpTransport() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "rtcpTransport", TransportStats.toJson(this.getRtcpTransport()));
        }
        if (this.getLocalCandidates() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "localCandidates", CandidateStats.toJsonArray(this.getLocalCandidates()));
        }
        if (this.getRemoteCandidates() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "remoteCandidates", CandidateStats.toJsonArray(this.getRemoteCandidates()));
        }
        if (this.getCandidatePairs() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "candidatePairs", CandidatePairStats.toJsonArray(this.getCandidatePairs()));
        }
        if (this.getActiveCandidatePair() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "activeCandidatePair", CandidatePairStats.toJson(this.getActiveCandidatePair()));
        }
        if (this.getLocalCertificate() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "localCertificate", CertificateStats.toJson(this.getLocalCertificate()));
        }
        if (this.getRemoteCertificate() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "remoteCertificate", CertificateStats.toJson(this.getRemoteCertificate()));
        }
    }

    void setActiveCandidatePair(CandidatePairStats value) {
        this._activeCandidatePair = value;
    }

    void setBytesReceived(long value) {
        this._bytesReceived = value;
    }

    void setBytesSent(long value) {
        this._bytesSent = value;
    }

    void setCandidatePairs(CandidatePairStats[] value) {
        this._candidatePairs = value;
    }

    void setLocalCandidates(CandidateStats[] value) {
        this._localCandidates = value;
    }

    void setLocalCertificate(CertificateStats value) {
        this._localCertificate = value;
    }

    void setRemoteCandidates(CandidateStats[] value) {
        this._remoteCandidates = value;
    }

    void setRemoteCertificate(CertificateStats value) {
        this._remoteCertificate = value;
    }

    void setRtcpTransport(TransportStats value) {
        this._rtcpTransport = value;
    }

    public String toJson() {
        return TransportStats.toJson(this);
    }

    public static String toJson(TransportStats transport) {
        return JsonSerializer.serializeObject(transport, new IAction2<TransportStats, HashMap<String, String>>(){

            @Override
            public void invoke(TransportStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }
}

