/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Collection;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IntegerExtensions;
import fm.icelink.MediaFormat;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class MediaFormatCollection<TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends Collection<TFormat, TFormatCollection> {
    private Object __equivalenceLookup;
    private Object __nameLookupLock;
    private HashMap<String, TFormat> __payloadTypeLookup = new HashMap();
    private Object __payloadTypeLookupLock = new Object();

    @Override
    protected void addSuccess(TFormat value) {
        super.addSuccess(value);
        if (((MediaFormat)value).getRegisteredPayloadType() >= 0) {
            this.cachePayloadType(IntegerExtensions.toString(((MediaFormat)value).getRegisteredPayloadType()), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePayloadType(String payloadType, TFormat format) {
        Object object = this.__nameLookupLock;
        synchronized (object) {
            HashMapExtensions.add(this.__payloadTypeLookup, payloadType, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TFormat> getByName(String name) {
        ArrayList<MediaFormat> list = new ArrayList<MediaFormat>();
        Object object = this.__nameLookupLock;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!Global.equals(local.getName(), name)) continue;
                list.add(local);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TFormat getByPayloadType(String payloadType) {
        MediaFormat local = null;
        Object object = this.__payloadTypeLookupLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(local);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__payloadTypeLookup, payloadType, _var0);
            local = _var0.getValue();
            if (_var1) {
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFormat getEquivalent(TFormat format, boolean ignoreIsPacketized) {
        Object object = this.__equivalenceLookup;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!local.isEquivalent(format, ignoreIsPacketized)) continue;
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFormat getEquivalent(TFormat format) {
        Object object = this.__equivalenceLookup;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!local.isEquivalent(format)) continue;
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFormat getFirstByName(String name) {
        Object object = this.__nameLookupLock;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!Global.equals(local.getName(), name)) continue;
                return (TFormat)local;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEquivalent(TFormat format) {
        Object object = this.__equivalenceLookup;
        synchronized (object) {
            for (MediaFormat local : (MediaFormat[])super.getValues()) {
                if (!local.isEquivalent(format)) continue;
                return true;
            }
        }
        return false;
    }

    protected MediaFormatCollection() {
        this.__nameLookupLock = new Object();
        this.__equivalenceLookup = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        super.removeAll();
        Object object = this.__nameLookupLock;
        synchronized (object) {
            this.__payloadTypeLookup.clear();
        }
    }

    @Override
    protected void removeSuccess(TFormat value) {
        super.removeSuccess(value);
        if (((MediaFormat)value).getRegisteredPayloadType() >= 0) {
            this.uncachePayloadType(IntegerExtensions.toString(((MediaFormat)value).getRegisteredPayloadType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncachePayloadType(String payloadType) {
        Object object = this.__payloadTypeLookupLock;
        synchronized (object) {
            HashMapExtensions.remove(this.__payloadTypeLookup, payloadType);
        }
    }
}

