/*
 * Decompiled with CFR 0.152.
 */
package fm;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum WebSocketStatusCode {
    Normal(1000),
    GoingAway(1001),
    ProtocolError(1002),
    InvalidType(1003),
    NoStatus(1005),
    Abnormal(1006),
    InvalidData(1007),
    PolicyViolation(1008),
    MessageTooLarge(1009),
    UnsupportedExtension(1010),
    UnexpectedCondition(1011),
    SecureHandshakeFailure(1015);

    private final int value;
    private static final Map<Integer, WebSocketStatusCode> lookup;

    private WebSocketStatusCode(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static WebSocketStatusCode getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, WebSocketStatusCode>();
        for (WebSocketStatusCode s : EnumSet.allOf(WebSocketStatusCode.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

