/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.NullableLong;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Block;
import fm.icelink.matroska.Element;
import java.util.ArrayList;

public class BlockGroup
extends Element {
    private Block _block;
    private NullableLong _blockDuration = new NullableLong();
    private static byte[] _blockDurationId;
    private static byte[] _referenceBlockId;
    private long[] _referenceBlocks;

    public BlockGroup() {
    }

    public BlockGroup(byte[] bytes) {
        ArrayList<Long> list = new ArrayList<Long>();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, Block.getEbmlId())) {
                this.setBlock(new Block(buffer2));
                continue;
            }
            if (Element.compare(buffer, _referenceBlockId)) {
                list.add(Element.readSignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _blockDurationId)) {
                this.setBlockDuration(new NullableLong(Element.readSignedInteger(buffer2)));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaBlockGroup: ", BitAssistant.getHexString(buffer)));
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            long[] numArray = new long[ArrayListExtensions.getCount(list)];
            for (int i = 0; i < ArrayListExtensions.getCount(list); ++i) {
                numArray[i] = (Long)ArrayListExtensions.getItem(list).get(i);
            }
            this.setReferenceBlocks(numArray);
        }
    }

    public Block getBlock() {
        return this._block;
    }

    public NullableLong getBlockDuration() {
        return this._blockDuration;
    }

    public static byte[] getEbmlId() {
        return new byte[]{-96};
    }

    @Override
    public byte[] getId() {
        return BlockGroup.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        if (this.getBlock() == null) {
            return null;
        }
        ByteOutputStream stream = new ByteOutputStream();
        stream.writeBuffer(this.getBlock().getBytes());
        if (this.getReferenceBlocks() != null) {
            for (long num : this.getReferenceBlocks()) {
                super.writeSignedInteger(num, _referenceBlockId, stream);
            }
        }
        if (this.getBlockDuration().getHasValue()) {
            super.writeSignedInteger(this.getBlockDuration().getValue(), _blockDurationId, stream);
        }
        return stream.toArray();
    }

    public long[] getReferenceBlocks() {
        return this._referenceBlocks;
    }

    public void setBlock(Block value) {
        this._block = value;
    }

    public void setBlockDuration(NullableLong value) {
        this._blockDuration = value;
    }

    public void setReferenceBlocks(long[] value) {
        this._referenceBlocks = value;
    }

    static {
        _referenceBlockId = new byte[]{-5};
        _blockDurationId = new byte[]{-101};
    }
}

