/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.h264;

import fm.icelink.DataBuffer;
import fm.icelink.h264.Nalu;

public class Utility {
    public static int getNaluLength(DataBuffer encodedFrame, int offset) {
        int startCodeLength = Utility.getStartCodeLength(encodedFrame, offset);
        if (startCodeLength <= 0) {
            return -1;
        }
        for (int i = offset + startCodeLength; i < encodedFrame.getLength(); ++i) {
            if (Utility.getStartCodeLength(encodedFrame, i) <= 0) continue;
            return i - offset;
        }
        return encodedFrame.getLength() - offset;
    }

    public static int getStartCodeLength(DataBuffer encodedFrame, int offset) {
        if (encodedFrame != null) {
            if (encodedFrame.getLength() < offset + 4) {
                return -1;
            }
            if (encodedFrame.read8(offset) != 0 || encodedFrame.read8(offset + 1) != 0) {
                return -1;
            }
            if (encodedFrame.read8(offset + 2) == 1) {
                return 3;
            }
            if (encodedFrame.getLength() < offset + 5) {
                return -1;
            }
            if (encodedFrame.read8(offset + 2) != 0) {
                return -1;
            }
            if (encodedFrame.read8(offset + 3) == 1) {
                return 4;
            }
        }
        return -1;
    }

    public static boolean isIdr(DataBuffer encodedFrame, int offset) {
        return Utility.isNaluType(5, encodedFrame, offset);
    }

    public static boolean isIdr(DataBuffer encodedFrame) {
        return Utility.isIdr(encodedFrame, 0);
    }

    public static boolean isKeyFrame(DataBuffer encodedFrame) {
        return Utility.isIdr(encodedFrame) || Utility.isPps(encodedFrame) || Utility.isSps(encodedFrame);
    }

    public static boolean isNaluType(int naluType, DataBuffer encodedFrame, int offset) {
        int startCodeLength = Utility.getStartCodeLength(encodedFrame, offset);
        if (startCodeLength <= 0) {
            return false;
        }
        return (encodedFrame.read8(offset + startCodeLength) & Nalu.getTypeMask()) == naluType;
    }

    public static boolean isPps(DataBuffer encodedFrame, int offset) {
        return Utility.isNaluType(8, encodedFrame, offset);
    }

    public static boolean isPps(DataBuffer encodedFrame) {
        return Utility.isPps(encodedFrame, 0);
    }

    public static boolean isSps(DataBuffer encodedFrame) {
        return Utility.isSps(encodedFrame, 0);
    }

    public static boolean isSps(DataBuffer encodedFrame, int offset) {
        return Utility.isNaluType(7, encodedFrame, offset);
    }
}

