/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1Sequence;
import fm.icelink.Asn1Set;
import fm.icelink.Global;
import fm.icelink.X501Attribute;
import fm.icelink.X501RelativeDistinguishedName;
import java.util.ArrayList;

class X501Name {
    private X501RelativeDistinguishedName[] _rdnSequence;

    public static X501Name fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence != null) {
            X501Name name = new X501Name();
            ArrayList<X501RelativeDistinguishedName> list = new ArrayList<X501RelativeDistinguishedName>();
            for (Asn1Any any2 : sequence.getValues()) {
                list.add(X501RelativeDistinguishedName.fromAsn1(any2));
            }
            name.setRdnSequence(list.toArray(new X501RelativeDistinguishedName[0]));
            return name;
        }
        return null;
    }

    public X501Attribute getAttribute(long[] attributeType) {
        if (this.getRdnSequence() != null) {
            for (X501RelativeDistinguishedName name : this.getRdnSequence()) {
                X501Attribute attribute = name.getAttribute(attributeType);
                if (attribute == null) continue;
                return attribute;
            }
        }
        return null;
    }

    public X501RelativeDistinguishedName[] getRdnSequence() {
        return this._rdnSequence;
    }

    public void setRdnSequence(X501RelativeDistinguishedName[] value) {
        this._rdnSequence = value;
    }

    public Asn1Any toAsn1() {
        ArrayList<Asn1Set> list = new ArrayList<Asn1Set>();
        for (X501RelativeDistinguishedName name : this.getRdnSequence()) {
            list.add(name.toAsn1());
        }
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }

    public X501Name(X501RelativeDistinguishedName[] rdnSequence) {
        this.setRdnSequence(rdnSequence);
    }

    public X501Name() {
    }
}

