/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum TransportType {
    Gatherer(1),
    IceTransport(2),
    DtlsTransport(3),
    SctpTransport(4),
    ReliableDataTransport(5),
    SrtpTransport(6),
    Unset(7),
    MediaTransport(8);

    private final int value;
    private static final Map<Integer, TransportType> lookup;

    private TransportType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static TransportType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, TransportType>();
        for (TransportType s : EnumSet.allOf(TransportType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

