/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BooleanHolder;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.Log;
import fm.icelink.StreamSocket;
import fm.icelink.StringExtensions;
import fm.icelink.TcpSocketCipherSuites;
import fm.icelink.TimeoutTimer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TcpSocket
extends StreamSocket {
    private ExecutorService _execAccept = Executors.newFixedThreadPool(1);
    private ExecutorService _execConnect = Executors.newFixedThreadPool(1);
    private ExecutorService _execIn = Executors.newFixedThreadPool(1);
    private ExecutorService _execOut = Executors.newFixedThreadPool(1);
    private Socket _socket;
    private ServerSocket _serverSocket;
    private OutputStream _out;
    private InputStream _in;
    private boolean _server;
    private boolean _secure;
    private boolean _ipv6;
    private boolean _isClosed;
    private static TcpSocketCipherSuites _cipherSuites = TcpSocketCipherSuites.Default;
    private String _LocalIPAddress;
    private int _LocalPort;
    private String _RemoteIPAddress;
    private int _RemotePort;

    @Override
    public boolean getServer() {
        return this._server;
    }

    @Override
    public boolean getSecure() {
        return this._secure;
    }

    @Override
    public boolean getIPv6() {
        return this._ipv6;
    }

    public static TcpSocketCipherSuites getCipherSuites() {
        return _cipherSuites;
    }

    public static void setCipherSuites(TcpSocketCipherSuites cipherSuites) {
        _cipherSuites = cipherSuites;
    }

    public TcpSocket(boolean server, boolean ipv6, boolean secure) {
        try {
            this._server = server;
            this._ipv6 = ipv6;
            this._secure = secure;
            if (ipv6) {
                this._LocalIPAddress = "::";
                this._RemoteIPAddress = "::";
            } else {
                this._LocalIPAddress = "0.0.0.0";
                this._RemoteIPAddress = "0.0.0.0";
            }
            this._LocalPort = 0;
            this._RemotePort = 0;
            if (this._server) {
                if (this._secure) {
                    this._serverSocket = SSLServerSocketFactory.getDefault().createServerSocket();
                    if (_cipherSuites == TcpSocketCipherSuites.All) {
                        SSLServerSocket sslServerSocket = (SSLServerSocket)this._serverSocket;
                        sslServerSocket.setEnabledCipherSuites(sslServerSocket.getSupportedCipherSuites());
                    }
                } else {
                    this._serverSocket = ServerSocketFactory.getDefault().createServerSocket();
                }
            } else if (this._secure) {
                this._socket = SSLSocketFactory.getDefault().createSocket();
                if (_cipherSuites == TcpSocketCipherSuites.All) {
                    SSLSocket sslSocket = (SSLSocket)this._socket;
                    sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
                }
            } else {
                this._socket = SocketFactory.getDefault().createSocket();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public TcpSocket(Socket socket) {
        this._server = false;
        this._ipv6 = socket.getLocalAddress() instanceof Inet6Address;
        if (this._ipv6) {
            this._LocalIPAddress = "::";
            this._RemoteIPAddress = "::";
        } else {
            this._LocalIPAddress = "0.0.0.0";
            this._RemoteIPAddress = "0.0.0.0";
        }
        this._LocalPort = 0;
        this._RemotePort = 0;
        this._socket = socket;
        try {
            this._out = socket.getOutputStream();
            this._in = socket.getInputStream();
        }
        catch (Exception ex) {
            Log.debug(StringExtensions.format("Could not accept a connection on TCP socket: {0}.", ex.getMessage()));
        }
    }

    @Override
    public boolean getIsClosed() {
        return this._isClosed;
    }

    @Override
    public String getLocalIPAddress() {
        try {
            this._LocalIPAddress = this._socket != null ? this._socket.getLocalAddress().getHostAddress() : this._serverSocket.getInetAddress().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._LocalIPAddress;
    }

    @Override
    public int getLocalPort() {
        try {
            this._LocalPort = this._socket != null ? this._socket.getLocalPort() : this._serverSocket.getLocalPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._LocalPort;
    }

    @Override
    public String getRemoteIPAddress() {
        try {
            if (this._socket != null) {
                this._RemoteIPAddress = this._socket.getInetAddress().getHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._RemoteIPAddress;
    }

    @Override
    public int getRemotePort() {
        try {
            if (this._socket != null) {
                this._RemotePort = this._socket.getPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._RemotePort;
    }

    @Override
    public boolean bind(String ipAddress, int port, BooleanHolder addressInUse) {
        addressInUse.setValue(false);
        try {
            InetAddress localAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
            if (this._socket != null) {
                this._socket.bind(new InetSocketAddress(localAddress, port));
            } else {
                this._serverSocket.bind(new InetSocketAddress(localAddress, port));
            }
            return true;
        }
        catch (BindException e) {
            addressInUse.setValue(e.getMessage().contains("in use"));
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private TcpSocket accept() throws Exception {
        if (this._socket != null) {
            throw new Exception("Client TCP sockets cannot 'accept'.");
        }
        Socket acceptSocket = this._serverSocket.accept();
        return new TcpSocket(acceptSocket);
    }

    @Override
    public void acceptAsync(final IAction1<StreamSocket> onSuccess, final IAction1<Exception> onFailure) {
        try {
            this._execAccept.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TcpSocket acceptSocket = TcpSocket.this.accept();
                        TcpSocket.this.raiseAcceptSuccess(onSuccess, acceptSocket);
                    }
                    catch (Exception e) {
                        TcpSocket.this.raiseAcceptFailure(onFailure, new Exception("Socket accept failed.", e));
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseAcceptFailure(onFailure, new Exception("Socket accept failed.", e));
        }
    }

    private void connect(String ipAddress, int port) throws Exception {
        if (this._socket == null) {
            throw new Exception("Server TCP sockets cannot 'connect'.");
        }
        InetAddress remoteAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
        this._socket.connect(new InetSocketAddress(remoteAddress, port));
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
    }

    @Override
    public void connectAsync(final String ipAddress, final int port, int timeout, final IAction0 onSuccess, final IAction2<Exception, Boolean> onFailure) {
        try {
            TimeoutTimer timer = null;
            if (timeout > 0) {
                timer = new TimeoutTimer(new IAction1<Object>(){

                    @Override
                    public void invoke(Object state) {
                        TcpSocket.this.raiseConnectFailure(onFailure, new Exception("Socket connect timed out."), true);
                    }
                }, null);
                timer.start(timeout);
            }
            final TimeoutTimer t = timer;
            this._execConnect.submit(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            TcpSocket.this.connect(ipAddress, port);
                            if (t == null || t.stop()) {
                                TcpSocket.this.raiseConnectSuccess(onSuccess);
                            }
                        }
                        catch (Exception e) {
                            if (t != null && !t.stop()) break block3;
                            TcpSocket.this.raiseConnectFailure(onFailure, new Exception("Socket connect failed.", e), false);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseConnectFailure(onFailure, new Exception("Socket connect failed.", e), false);
        }
    }

    @Override
    public boolean send(DataBuffer buffer) {
        try {
            this._out.write(buffer.getData(), buffer.getIndex(), buffer.getLength());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void sendAsync(final DataBuffer buffer, int timeout, final IAction0 onSuccess, final IAction2<Exception, Boolean> onFailure) {
        try {
            TimeoutTimer timer = null;
            if (timeout > 0) {
                timer = new TimeoutTimer(new IAction1<Object>(){

                    @Override
                    public void invoke(Object state) {
                        TcpSocket.this.raiseSendFailure(onFailure, new Exception("Socket send timed out."), true);
                    }
                }, null);
                timer.start(timeout);
            }
            final TimeoutTimer t = timer;
            buffer.keep();
            this._execOut.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TcpSocket.this.send(buffer);
                        if (t == null || t.stop()) {
                            TcpSocket.this.raiseSendSuccess(onSuccess);
                        }
                    }
                    catch (Exception e) {
                        if (t == null || t.stop()) {
                            TcpSocket.this.raiseSendFailure(onFailure, new Exception("Socket send failed.", e), false);
                        }
                    }
                    finally {
                        buffer.free();
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseSendFailure(onFailure, new Exception("Socket send failed.", e), false);
        }
    }

    @Override
    public void receiveAsync(int timeout) {
        final IAction1<DataBuffer> onReceiveSuccess = super.getOnReceiveSuccess();
        final IAction2<Exception, Boolean> onReceiveFailure = super.getOnReceiveFailure();
        try {
            TimeoutTimer timer = null;
            if (timeout > 0) {
                timer = new TimeoutTimer(new IAction1<Object>(){

                    @Override
                    public void invoke(Object state) {
                        TcpSocket.this.raiseReceiveFailure(onReceiveFailure, new Exception("Socket receive timed out."), true);
                    }
                }, null);
                timer.start(timeout);
            }
            final TimeoutTimer t = timer;
            this._execIn.submit(new Runnable(){

                @Override
                public void run() {
                    DataBuffer receiveBuffer = DataBufferPool.getInstance().take(2048);
                    try {
                        int read = TcpSocket.this._in.read(receiveBuffer.getData(), receiveBuffer.getIndex(), receiveBuffer.getLength());
                        if (read > 0 && (t == null || t.stop())) {
                            TcpSocket.this.raiseReceiveSuccess(onReceiveSuccess, receiveBuffer.subset(0, read));
                        } else if (read == 0) {
                            TcpSocket.this.close();
                        }
                    }
                    catch (Exception e) {
                        if (t == null || t.stop()) {
                            TcpSocket.this.raiseReceiveFailure(onReceiveFailure, new Exception("Socket receive failed.", e), false);
                            TcpSocket.this.close();
                        }
                    }
                    finally {
                        receiveBuffer.free();
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseReceiveFailure(onReceiveFailure, new Exception("Socket receive failed.", e), false);
        }
    }

    @Override
    public void close() {
        try {
            if (this._in != null) {
                this._in.close();
            }
            if (this._out != null) {
                this._out.close();
            }
            if (this._socket != null) {
                this._socket.close();
            }
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
            if (this._execAccept != null) {
                this._execAccept.shutdown();
            }
            if (this._execConnect != null) {
                this._execConnect.shutdown();
            }
            if (this._execIn != null) {
                this._execIn.shutdown();
            }
            if (this._execOut != null) {
                this._execOut.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._isClosed = true;
    }
}

