/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunkListChunkParameter;
import fm.icelink.SctpCookiePreservativeChunkParameter;
import fm.icelink.SctpForwardTsnSupportedChunkParameter;
import fm.icelink.SctpGenericChunkParameter;
import fm.icelink.SctpHeartbeatInfoChunkParameter;
import fm.icelink.SctpHostNameAddressChunkParameter;
import fm.icelink.SctpIPv4ChunkParameter;
import fm.icelink.SctpPadChunkParameter;
import fm.icelink.SctpRandomChunkParameter;
import fm.icelink.SctpRequestedHmacAlgorithmChunkParameter;
import fm.icelink.SctpStateCookieChunkParameter;
import fm.icelink.SctpSupportedAddressTypesChunkParameter;
import fm.icelink.SctpSupportedExtensionsChunkParameter;
import fm.icelink.SctpUnrecognizedParameterChunkParameter;

abstract class SctpTlvParameter {
    private int _type;

    public abstract byte[] getBytes();

    public boolean getDoNotProcessFurtherParametersIfItIsNotRecognized() {
        return (Binary.toBytes16(this.getType(), false)[0] & 0x80) != 128;
    }

    public boolean getReportToSenderIfItIsNotRecognized() {
        return (Binary.toBytes16(this.getType(), false)[0] & 0x40) == 64;
    }

    public int getType() {
        return this._type;
    }

    public static boolean isInManualListOfUnrecognizedChunkParameterThatMustBeReported(int parameter) {
        return parameter == 49152;
    }

    public static SctpTlvParameter parseBytes(byte[] value, int startIndex, IntegerHolder offsetPlus) {
        int num;
        byte[] buffer;
        try {
            buffer = new byte[ArrayExtensions.getLength(value) - startIndex];
            BitAssistant.copy(value, startIndex, buffer, 0, ArrayExtensions.getLength(buffer));
            num = Binary.fromBytes16(buffer, 0, false);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            Log.warn("Error parsing SCTP TLV Parameter");
            return null;
        }
        int _var0 = num;
        if (_var0 == 1) {
            SctpHeartbeatInfoChunkParameter _var1 = SctpHeartbeatInfoChunkParameter.parseBytes(buffer, offsetPlus);
            return _var1;
        }
        if (_var0 == 5) {
            SctpIPv4ChunkParameter _var2 = SctpIPv4ChunkParameter.parseBytes(buffer, offsetPlus);
            return _var2;
        }
        if (_var0 == 9) {
            SctpCookiePreservativeChunkParameter _var3 = SctpCookiePreservativeChunkParameter.parseBytes(buffer, offsetPlus);
            return _var3;
        }
        if (_var0 == 8) {
            SctpUnrecognizedParameterChunkParameter _var4 = SctpUnrecognizedParameterChunkParameter.parseBytes(buffer, offsetPlus);
            return _var4;
        }
        if (_var0 == 7) {
            SctpStateCookieChunkParameter _var5 = SctpStateCookieChunkParameter.parseBytes(buffer, offsetPlus);
            return _var5;
        }
        if (_var0 == 11) {
            SctpHostNameAddressChunkParameter _var6 = SctpHostNameAddressChunkParameter.parseBytes(buffer, offsetPlus);
            return _var6;
        }
        if (_var0 == 12) {
            SctpSupportedAddressTypesChunkParameter _var7 = SctpSupportedAddressTypesChunkParameter.parseBytes(buffer, offsetPlus);
            return _var7;
        }
        if (_var0 == 32773) {
            SctpPadChunkParameter _var8 = SctpPadChunkParameter.parseBytes(buffer, offsetPlus);
            return _var8;
        }
        if (_var0 == 49152) {
            SctpForwardTsnSupportedChunkParameter _var9 = SctpForwardTsnSupportedChunkParameter.parseBytes(buffer, offsetPlus);
            return _var9;
        }
        if (_var0 == 32776) {
            SctpSupportedExtensionsChunkParameter _var10 = SctpSupportedExtensionsChunkParameter.parseBytes(buffer, offsetPlus);
            return _var10;
        }
        if (_var0 == 32770) {
            SctpRandomChunkParameter _var11 = SctpRandomChunkParameter.parseBytes(buffer, offsetPlus);
            return _var11;
        }
        if (_var0 == 32772) {
            SctpRequestedHmacAlgorithmChunkParameter _var12 = SctpRequestedHmacAlgorithmChunkParameter.parseBytes(buffer, offsetPlus);
            return _var12;
        }
        if (_var0 == 32771) {
            SctpChunkListChunkParameter _var13 = SctpChunkListChunkParameter.parseBytes(buffer, offsetPlus);
            return _var13;
        }
        SctpGenericChunkParameter _var14 = SctpGenericChunkParameter.parseBytes(buffer, offsetPlus);
        return _var14;
    }

    protected SctpTlvParameter() {
    }

    protected void setType(int value) {
        this._type = value;
    }
}

