/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpTlvParameter;

class SctpRequestedHmacAlgorithmChunkParameter
extends SctpTlvParameter {
    private int[] _hmacIdentifiers;

    @Override
    public byte[] getBytes() {
        return SctpRequestedHmacAlgorithmChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpRequestedHmacAlgorithmChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(parameter.getType(), false));
        int num = ArrayExtensions.getLength(parameter.getHmacIdentifiers()) * 2 + 4;
        bytes.addRange(Binary.toBytes16(num, false));
        for (int num2 : parameter.getHmacIdentifiers()) {
            bytes.addRange(Binary.toBytes16(num2, false));
        }
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public int[] getHmacIdentifiers() {
        return this._hmacIdentifiers;
    }

    public static SctpRequestedHmacAlgorithmChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int len = Binary.fromBytes16(bytes, 2, false);
            int[] hmacIdentifiers = new int[(len - 4) / 2];
            for (int i = 0; i < ArrayExtensions.getLength(hmacIdentifiers); ++i) {
                hmacIdentifiers[i] = Binary.fromBytes16(bytes, 4 + i * 2, false);
            }
            int num3 = SctpChunk.calculatePaddingBytes(len);
            offsetPlus.setValue(len + num3);
            return new SctpRequestedHmacAlgorithmChunkParameter(hmacIdentifiers);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            Log.debug("Could not read RequestedHMACAlgorithmChunkParameter.");
            return null;
        }
    }

    public SctpRequestedHmacAlgorithmChunkParameter(int[] hmacIdentifiers) {
        super.setType(32772);
        this.setHmacIdentifiers(hmacIdentifiers);
    }

    public void setHmacIdentifiers(int[] value) {
        this._hmacIdentifiers = value;
    }
}

