/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.Crc32;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpCommonHeader;
import java.util.ArrayList;

class SctpPacket {
    private static Crc32 __crc32c = new Crc32(Crc32.getCrc32cPolynomial());
    private SctpChunk[] _chunks;
    private SctpCommonHeader _header;
    private SctpChunk[] _unrecognizedChunksThatShouldBeReportedToSender;

    public static long computeCRC32cForSCTP(byte[] bytes, int offset, int len) {
        byte[] array = Binary.toBytes32(__crc32c.compute(bytes, offset, len), false);
        BitAssistant.reverse(array);
        return Binary.fromBytes32(array, 0, false);
    }

    private static byte[] getBytes(SctpPacket packet) {
        ByteCollection bytes = new ByteCollection();
        byte[] buffer = packet.getHeader().getBytes();
        bytes.addRange(buffer);
        for (int i = 0; i < ArrayExtensions.getLength(packet.getChunks()); ++i) {
            try {
                byte[] buffer2 = packet.getChunks()[i].getBytes();
                bytes.addRange(buffer2);
                continue;
            }
            catch (Exception exception1) {
                Log.warn("SCTP could not process chunk.");
            }
        }
        byte[] buffer3 = bytes.toArray();
        buffer3[8] = 0;
        buffer3[9] = 0;
        buffer3[10] = 0;
        buffer3[11] = 0;
        byte[] buffer4 = Binary.toBytes32(SctpPacket.computeCRC32cForSCTP(buffer3, 0, ArrayExtensions.getLength(buffer3)), false);
        buffer3[8] = buffer4[0];
        buffer3[9] = buffer4[1];
        buffer3[10] = buffer4[2];
        buffer3[11] = buffer4[3];
        return buffer3;
    }

    public byte[] getBytes() {
        return SctpPacket.getBytes(this);
    }

    public SctpChunk[] getChunks() {
        return this._chunks;
    }

    public SctpCommonHeader getHeader() {
        return this._header;
    }

    public SctpChunk[] getUnrecognizedChunksThatShouldBeReportedToSender() {
        return this._unrecognizedChunksThatShouldBeReportedToSender;
    }

    public static SctpPacket parseBytes(byte[] value, int startIndex, int length) {
        try {
            byte[] destination = new byte[length - startIndex];
            BitAssistant.copy(value, startIndex, destination, 0, length);
            int num = 0;
            int offsetPlus = 0;
            IntegerHolder _var0 = new IntegerHolder(offsetPlus);
            SctpCommonHeader _var1 = SctpCommonHeader.parseBytes(destination, _var0);
            offsetPlus = _var0.getValue();
            SctpCommonHeader header = _var1;
            if (header != null) {
                num += offsetPlus;
                ArrayList<SctpChunk> list = new ArrayList<SctpChunk>();
                ArrayList<SctpChunk> list2 = new ArrayList<SctpChunk>();
                boolean flag = true;
                while (num < length && flag) {
                    IntegerHolder _var2 = new IntegerHolder(offsetPlus);
                    SctpChunk _var3 = SctpChunk.parseBytes(destination, num, _var2);
                    offsetPlus = _var2.getValue();
                    SctpChunk item = _var3;
                    if (item == null) {
                        Log.error("SCTP: could not parse chunk.");
                        flag = false;
                        continue;
                    }
                    num += offsetPlus;
                    if (item.getUnrecognized()) {
                        if (item.getReportToSenderIfItIsNotRecognized() && flag) {
                            list2.add(item);
                        }
                        if (item.getDoNotProcessFurtherChunksIfItIsNotRecognized()) {
                            flag = false;
                        }
                    }
                    list.add(item);
                }
                SctpChunk[] chunks = null;
                if (list != null && ArrayListExtensions.getCount(list) > 0) {
                    chunks = list.toArray(new SctpChunk[0]);
                    SctpPacket packet = new SctpPacket(header, chunks);
                    packet.setUnrecognizedChunksThatShouldBeReportedToSender(list2.toArray(new SctpChunk[0]));
                    return packet;
                }
            }
            return null;
        }
        catch (Exception exception1) {
            Log.debug("SCTP Error: could not read SCTP packet.");
            return null;
        }
    }

    public static SctpPacket parseBytes(byte[] value) {
        return SctpPacket.parseBytes(value, 0, ArrayExtensions.getLength(value));
    }

    public SctpPacket(SctpCommonHeader header, SctpChunk[] chunks) {
        this.setHeader(header);
        this.setChunks(chunks);
    }

    public void setChunks(SctpChunk[] value) {
        this._chunks = value;
    }

    public void setHeader(SctpCommonHeader value) {
        this._header = value;
    }

    private void setUnrecognizedChunksThatShouldBeReportedToSender(SctpChunk[] value) {
        this._unrecognizedChunksThatShouldBeReportedToSender = value;
    }

    public static boolean verifyCRC32cChecksum(byte[] sctpBytes, int offset, int len) {
        try {
            long num = Binary.fromBytes32(sctpBytes, 8 + offset, false);
            sctpBytes[8 + offset] = 0;
            sctpBytes[9 + offset] = 0;
            sctpBytes[10 + offset] = 0;
            sctpBytes[11 + offset] = 0;
            return SctpPacket.computeCRC32cForSCTP(sctpBytes, offset, len) == num;
        }
        catch (Exception exception1) {
            return false;
        }
    }
}

