/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.LongHolder;

public class RtpPacket {
    private int __contributingSourceCount = -1;
    private long[] __contributingSources = null;
    private boolean __extension = false;
    private boolean __extensionValid = false;
    private DataBuffer __header = null;
    private DataBuffer __headerExtension = null;
    private int __headerExtensionId = -1;
    private int __headerExtensionLength = -1;
    private boolean __marker = false;
    private boolean __markerValid = false;
    private boolean __padding = false;
    private int __paddingLength = -1;
    private boolean __paddingValid = false;
    private DataBuffer __payload;
    private int __payloadType = -1;
    private int __sequenceNumber = -1;
    private long __synchronizationSource = -1L;
    private long __timestamp = -1L;
    private int __version = -1;
    private DataBuffer _buffer;

    public DataBuffer getBuffer() {
        return this._buffer;
    }

    public int getContributingSourceCount() {
        if (this.__contributingSourceCount == -1) {
            this.__contributingSourceCount = this.getBuffer().read4(0, 4);
        }
        return this.__contributingSourceCount;
    }

    public long[] getContributingSources() {
        if (this.__contributingSources == null) {
            int contributingSourcesOffset = this.getContributingSourcesOffset();
            long[] numArray = new long[this.getContributingSourceCount()];
            for (int i = 0; i < this.getContributingSourceCount(); ++i) {
                long num3 = 0L;
                LongHolder _var0 = new LongHolder(num3);
                boolean _var1 = this.getBuffer().tryRead32(contributingSourcesOffset, _var0);
                num3 = _var0.getValue();
                if (_var1) {
                    contributingSourcesOffset += 4;
                } else {
                    Log.error("Could not read contributing source from buffer.");
                    return null;
                }
                numArray[i] = num3;
            }
            this.__contributingSources = numArray;
        }
        return this.__contributingSources;
    }

    public int getContributingSourcesLength() {
        return this.getContributingSourceCount() * 4;
    }

    public int getContributingSourcesOffset() {
        return RtpPacket.getFixedHeaderLength();
    }

    public boolean getExtension() {
        if (!this.__extensionValid) {
            this.__extension = this.getBuffer().read1(0, 3);
            this.__extensionValid = true;
        }
        return this.__extension;
    }

    public static int getFixedHeaderLength() {
        return 12;
    }

    public DataBuffer getHeader() {
        if (this.__header == null || this.__header.getLength() != this.getHeaderLength()) {
            this.__header = this.getBuffer().subset(0, this.getHeaderLength());
        }
        return this.__header;
    }

    public DataBuffer getHeaderExtension() {
        if (this.__headerExtension == null) {
            this.__headerExtension = this.getExtension() ? this.getBuffer().subset(this.getHeaderExtensionOffset() + 4, this.getHeaderExtensionLength()) : null;
        }
        return this.__headerExtension;
    }

    public int getHeaderExtensionId() {
        if (this.__headerExtensionId == -1) {
            this.__headerExtensionId = this.getExtension() ? this.getBuffer().read16(this.getHeaderExtensionOffset()) : 0;
        }
        return this.__headerExtensionId;
    }

    public int getHeaderExtensionLength() {
        if (this.__headerExtensionLength == -1) {
            this.__headerExtensionLength = this.getExtension() ? this.getBuffer().read16(this.getHeaderExtensionOffset() + 1) * 4 : 0;
        }
        return this.__headerExtensionLength;
    }

    public int getHeaderExtensionOffset() {
        return this.getContributingSourcesOffset() + this.getContributingSourcesLength();
    }

    public int getHeaderLength() {
        return RtpPacket.getFixedHeaderLength() + this.getVariableHeaderLength();
    }

    public boolean getMarker() {
        if (!this.__markerValid) {
            this.__marker = this.getBuffer().read1(1, 0);
            this.__markerValid = true;
        }
        return this.__marker;
    }

    public boolean getPadding() {
        if (!this.__paddingValid) {
            this.__padding = this.getBuffer().read1(0, 2);
            this.__paddingValid = true;
        }
        return this.__padding;
    }

    public int getPaddingLength() {
        if (this.__paddingLength == -1) {
            this.__paddingLength = this.getPadding() ? this.getBuffer().read8(this.getBuffer().getLength() - 1) : 0;
        }
        return this.__paddingLength;
    }

    public DataBuffer getPayload() {
        if (this.__payload == null || this.__payload.getLength() != this.getPayloadLength()) {
            this.__payload = this.getBuffer().subset(this.getPayloadOffset());
        }
        return this.__payload;
    }

    public int getPayloadLength() {
        if (this.getBuffer() == null) {
            return 0;
        }
        return this.getBuffer().getLength() - this.getHeaderLength() - this.getPaddingLength();
    }

    public int getPayloadOffset() {
        return this.getHeaderLength();
    }

    public int getPayloadType() {
        if (this.__payloadType == -1) {
            this.__payloadType = this.getBuffer().read7(1, 1);
        }
        return this.__payloadType;
    }

    public int getSequenceNumber() {
        if (this.__sequenceNumber == -1) {
            this.__sequenceNumber = this.getBuffer().read16(2);
        }
        return this.__sequenceNumber;
    }

    public static int getSequenceNumberDelta(int sequenceNumber, int lastSequenceNumber) {
        int num = sequenceNumber - lastSequenceNumber;
        if (num < Short.MIN_VALUE) {
            return num + 65536;
        }
        if (num > 32768) {
            num -= 65536;
        }
        return num;
    }

    public long getSynchronizationSource() {
        if (this.__synchronizationSource == -1L) {
            this.__synchronizationSource = this.getBuffer().read32(8);
        }
        return this.__synchronizationSource;
    }

    public long getTimestamp() {
        if (this.__timestamp == -1L) {
            this.__timestamp = this.getBuffer().read32(4);
        }
        return this.__timestamp;
    }

    public int getVariableHeaderLength() {
        return this.getContributingSourcesLength() + (this.getExtension() ? 4 + this.getHeaderExtensionLength() : 0);
    }

    public int getVersion() {
        if (this.__version == -1) {
            this.__version = this.getBuffer().read2(0, 0);
        }
        return this.__version;
    }

    private void resizeForContributingSources(int newContributingSourceCount) {
        int contributingSourceCount = this.getContributingSourceCount();
        int num2 = newContributingSourceCount * 4;
        int num3 = contributingSourceCount * 4;
        this.getBuffer().resize(this.getBuffer().getLength() + num2 - num3);
        this.setContributingSourceCount(newContributingSourceCount);
    }

    private void resizeForHeaderExtension(boolean newExtension, int newHeaderExtensionLength) {
        boolean extension = this.getExtension();
        int headerExtensionLength = this.getHeaderExtensionLength();
        int num2 = newExtension ? 4 + newHeaderExtensionLength : 0;
        int num3 = extension ? 4 + headerExtensionLength : 0;
        this.getBuffer().resize(this.getBuffer().getLength() + num2 - num3);
        this.setExtension(newExtension);
        if (newExtension) {
            this.setHeaderExtensionLength(newHeaderExtensionLength);
        }
    }

    private void resizeForPayload(int newPayloadLength) {
        int payloadLength = this.getPayloadLength();
        this.getBuffer().resize(this.getPayloadOffset() + newPayloadLength - payloadLength);
    }

    public RtpPacket(DataBuffer payload) {
        this.setBuffer(DataBuffer.allocate(payload.getLength() + RtpPacket.getFixedHeaderLength(), false));
        this.getBuffer().write(payload, RtpPacket.getFixedHeaderLength());
        this.setVersion(2);
    }

    public RtpPacket() {
    }

    private void setBuffer(DataBuffer value) {
        this._buffer = value;
    }

    private void setContributingSourceCount(int value) {
        if (this.__contributingSourceCount != value) {
            this.getBuffer().write4(value, 0, 4);
            this.__contributingSourceCount = value;
        }
    }

    public void setContributingSources(long[] value) {
        if (value == null) {
            value = new long[]{};
        }
        if (this.__contributingSources != value) {
            this.resizeForContributingSources(ArrayExtensions.getLength(value));
            int contributingSourcesOffset = this.getContributingSourcesOffset();
            for (int i = 0; i < ArrayExtensions.getLength(value); ++i) {
                this.getBuffer().write32(value[i], contributingSourcesOffset);
                contributingSourcesOffset += 4;
            }
            this.__contributingSources = value;
        }
    }

    private void setExtension(boolean value) {
        if (!this.__extensionValid || !Global.equals(this.__extension, value)) {
            this.getBuffer().write1(value, 0, 3);
            this.__extension = value;
            this.__extensionValid = true;
        }
    }

    public void setHeaderExtension(DataBuffer value) {
        if (!Global.equals(this.__headerExtension, value)) {
            if (value == null) {
                this.resizeForHeaderExtension(false, 0);
            } else {
                this.resizeForHeaderExtension(true, value.getLength());
                this.getBuffer().write(value, this.getHeaderExtensionOffset() + 4);
            }
            this.__headerExtension = value;
        }
    }

    public void setHeaderExtensionId(int value) {
        if (this.__headerExtensionId != value) {
            this.resizeForHeaderExtension(true, this.getHeaderExtensionLength());
            this.getBuffer().write16(value, this.getHeaderExtensionOffset());
            this.__headerExtensionId = value;
        }
    }

    private void setHeaderExtensionLength(int value) {
        if (this.__headerExtensionLength != value) {
            this.getBuffer().write16(value / 4, this.getHeaderExtensionOffset() + 1);
            this.__headerExtensionLength = value;
        }
    }

    public void setMarker(boolean value) {
        if (!this.__markerValid || !Global.equals(this.__marker, value)) {
            this.getBuffer().write1(value, 1, 0);
            this.__marker = value;
            this.__markerValid = true;
        }
    }

    public void setPadding(boolean value) {
        if (!this.__paddingValid || !Global.equals(this.__padding, value)) {
            this.getBuffer().write1(value, 0, 2);
            this.__padding = value;
            this.__paddingValid = true;
        }
    }

    private void setPaddingLength(int value) {
        if (this.__paddingLength != value) {
            this.setPadding(value > 0);
            for (int i = 0; i < value; ++i) {
                this.getBuffer().write8(i < value - 1 ? 0 : value, this.getBuffer().getLength() - value + i);
            }
        }
    }

    public void setPayload(DataBuffer value) {
        if (value.getLength() > this.getBuffer().getLength()) {
            this.setBuffer(value.clone());
            this.getBuffer().prepend(this.getHeader());
        } else if (this.getBuffer().getLength() == this.getHeaderLength()) {
            this.getBuffer().append(this.getPayload());
        } else {
            if (this.getHeaderLength() + value.getLength() > this.getBuffer().getLength()) {
                this.getBuffer().resize(this.getHeaderLength() + value.getLength());
            }
            this.getBuffer().write(value, this.getHeaderLength());
        }
        this.__payload = value;
    }

    public void setPayloadType(int value) {
        if (this.__payloadType != value) {
            this.getBuffer().write7(value, 1, 1);
            this.__payloadType = value;
        }
    }

    public void setSequenceNumber(int value) {
        if (this.__sequenceNumber != value) {
            this.getBuffer().write16(value, 2);
            this.__sequenceNumber = value;
        }
    }

    public void setSynchronizationSource(long value) {
        if (this.__synchronizationSource != value) {
            this.getBuffer().write32(value, 8);
            this.__synchronizationSource = value;
        }
    }

    public void setTimestamp(long value) {
        if (this.__timestamp != value) {
            this.getBuffer().write32(value, 4);
            this.__timestamp = value;
        }
    }

    public void setVersion(int value) {
        if (this.__version != value) {
            this.getBuffer().write2(value, 0, 0);
            this.__version = value;
        }
    }

    public static void test() {
    }

    public static RtpPacket wrap(DataBuffer buffer) {
        if (buffer.getLength() < RtpPacket.getFixedHeaderLength()) {
            return null;
        }
        RtpPacket packet2 = new RtpPacket();
        packet2.setBuffer(buffer);
        RtpPacket packet = packet2;
        if (packet.getVersion() != 2) {
            return null;
        }
        if (packet.getPayloadType() >= 72 && packet.getPayloadType() <= 85) {
            return null;
        }
        if (packet.getContributingSourcesLength() > buffer.getLength()) {
            return null;
        }
        if (packet.getHeaderExtensionLength() > buffer.getLength()) {
            return null;
        }
        if (packet.getHeaderLength() > buffer.getLength()) {
            return null;
        }
        return packet;
    }
}

