/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AtomicInteger;
import fm.icelink.Future;
import fm.icelink.FutureState;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IFunction0;
import fm.icelink.IPromise;
import fm.icelink.Promise;
import java.util.ArrayList;

public abstract class PromiseBase<T>
extends Future<T>
implements IPromise {
    private String __id = Guid.newGuid().toString().replace("-", "");
    private ArrayList<IPromise> __pendingPromisesToReject;
    private ArrayList<IPromise> __pendingPromisesToResolve;
    private ArrayList<IAction1<Exception>> __pendingRejects;
    private ArrayList<IAction1<T>> __pendingResolves;
    private Object __stateLock = new Object();

    private void addReject(IPromise promise, IAction1<Exception> reject) {
        if (this.__pendingPromisesToReject != null) {
            this.__pendingPromisesToReject = new ArrayList();
        }
        if (this.__pendingRejects == null) {
            this.__pendingRejects = new ArrayList();
        }
        this.__pendingPromisesToReject.add(promise);
        this.__pendingRejects.add(reject);
    }

    private void addResolve(IPromise promise, IAction1<T> resolve) {
        if (this.__pendingPromisesToResolve != null) {
            this.__pendingPromisesToResolve = new ArrayList();
        }
        if (this.__pendingResolves == null) {
            this.__pendingResolves = new ArrayList();
        }
        this.__pendingPromisesToResolve.add(promise);
        this.__pendingResolves.add(resolve);
    }

    public static <R> Future<R> all(Future<R>[] promises) {
        Promise promise = new Promise();
        AtomicInteger counter = new AtomicInteger(ArrayExtensions.getLength(promises));
        promise.doAll(promises, counter);
        return promise;
    }

    protected <R> void doAll(Future<R>[] promises, final AtomicInteger counter) {
        IAction1 resolveAction = null;
        IAction1<Exception> rejectAction = null;
        for (Future<R> future : promises) {
            if (resolveAction == null) {
                resolveAction = new IAction1<R>(){

                    @Override
                    public void invoke(R result) {
                        if (counter.decrement() == 0) {
                            PromiseBase.this.resolve(null);
                        }
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception ex) {
                        PromiseBase.this.reject(ex);
                    }
                };
            }
            future.then(resolveAction, rejectAction);
        }
    }

    public String getId() {
        return this.__id;
    }

    protected void process(IPromise promise, IAction1<T> resolve, IAction1<Exception> reject) {
        if (Global.equals((Object)super.getState(), (Object)FutureState.Resolved)) {
            this.raiseResolve(resolve, super.getResult(), promise);
        } else if (Global.equals((Object)super.getState(), (Object)FutureState.Rejected)) {
            this.raiseReject(reject, super.getException(), promise);
        } else {
            this.addResolve(promise, resolve);
            this.addReject(promise, reject);
        }
    }

    public PromiseBase() {
        this.__pendingPromisesToResolve = new ArrayList();
        this.__pendingPromisesToReject = new ArrayList();
        this.__pendingResolves = new ArrayList();
        this.__pendingRejects = new ArrayList();
        super.setState(FutureState.Pending);
    }

    private void raiseReject(IAction1<Exception> callback, Exception exception, IPromise promise) {
        try {
            callback.invoke(exception);
        }
        catch (Exception exception2) {
            promise.reject(exception2);
        }
    }

    private void raiseRejects(Exception exception) {
        if (this.__pendingRejects != null) {
            for (int i = 0; i < ArrayListExtensions.getCount(this.__pendingRejects); ++i) {
                this.raiseReject(ArrayListExtensions.getItem(this.__pendingRejects).get(i), exception, ArrayListExtensions.getItem(this.__pendingPromisesToReject).get(i));
            }
        }
        this.reset();
    }

    private void raiseResolve(IAction1<T> callback, T result, IPromise promise) {
        try {
            callback.invoke(result);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
    }

    private void raiseResolves(T result) {
        if (this.__pendingResolves != null) {
            for (int i = 0; i < ArrayListExtensions.getCount(this.__pendingResolves); ++i) {
                this.raiseResolve(ArrayListExtensions.getItem(this.__pendingResolves).get(i), result, ArrayListExtensions.getItem(this.__pendingPromisesToResolve).get(i));
            }
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reject(Exception exception) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)super.getState(), (Object)FutureState.Pending)) {
                return false;
            }
            super.setException(exception);
            super.setState(FutureState.Rejected);
        }
        this.raiseRejects(exception);
        return true;
    }

    public static <R> Future<R> rejectNow(Exception ex) {
        Promise promise = new Promise();
        promise.reject(ex);
        return promise;
    }

    private void reset() {
        this.__pendingPromisesToResolve.clear();
        this.__pendingPromisesToReject.clear();
        this.__pendingResolves.clear();
        this.__pendingRejects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolve(T result) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)super.getState(), (Object)FutureState.Pending)) {
                return false;
            }
            super.setResult(result);
            super.setState(FutureState.Resolved);
        }
        this.raiseResolves(result);
        return true;
    }

    public static Future<Object> resolveNow() {
        return PromiseBase.resolveNow(null);
    }

    public static <R> Future<R> resolveNow(R result) {
        Promise<R> promise = new Promise<R>();
        promise.resolve(result);
        return promise;
    }

    public static <R> Future<R> wrapPromise(IFunction0<Future<R>> callback) {
        try {
            if (callback == null) {
                throw new RuntimeException(new Exception("callback cannot be null."));
            }
            return callback.invoke();
        }
        catch (Exception exception) {
            return PromiseBase.rejectNow(exception);
        }
    }
}

