/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Collection;
import fm.icelink.Error;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IElement;
import fm.icelink.IFunction1;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaInputCollection;
import fm.icelink.IMediaOutput;
import fm.icelink.IOutput;
import fm.icelink.JsonSerializer;
import fm.icelink.License;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaSourceBase;
import fm.icelink.MediaSourceState;
import fm.icelink.MediaTrackStats;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.Stream;
import fm.icelink.StringExtensions;
import fm.icelink.Utility;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.rtp.SsrcAttribute;
import fm.icelink.sdp.rtp.SsrcAttributeName;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaSource<TIOutput extends IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIInput extends IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIInputCollection extends IMediaInputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIInputCollection>, TSource extends MediaSource<TIOutput, TIInput, TIInputCollection, TSource, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends MediaSourceBase
implements IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private boolean __disabled = true;
    private SourceInput __input = null;
    private List<IAction1<TSource>> __onDisabledChange = new ArrayList<IAction1<TSource>>();
    private List<IAction1<MediaControlFrame[]>> __onProcessControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onRaiseFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<TSource>> __onStateChange = new ArrayList<IAction1<TSource>>();
    private TIInputCollection __outputs;
    private volatile boolean __processingControlFrames = false;
    private volatile boolean __raisingFrame = false;
    private MediaSourceState __state;
    private Object __stateLock;
    private boolean _muted;
    private IAction1<TSource> _onDisabledChange = new IAction1<TSource>(){

        @Override
        public void invoke(TSource p0) {
            for (IAction1 action : new ArrayList(MediaSource.this.__onDisabledChange)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<MediaControlFrame[]> _onProcessControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaSource.this.__onProcessControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onRaiseFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaSource.this.__onRaiseFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TSource> _onStateChange = new IAction1<TSource>(){

        @Override
        public void invoke(TSource p0) {
            for (IAction1 action : new ArrayList(MediaSource.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private TFormat _outputFormat;
    private long _synchronizationSource;

    public void addOnDisabledChange(IAction1<TSource> value) {
        this.__onDisabledChange.add(value);
    }

    @Override
    public void addOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onProcessControlFrames.add(value);
    }

    @Override
    public void addOnRaiseFrame(IAction1<TFrame> value) {
        this.__onRaiseFrame.add(value);
    }

    public void addOnStateChange(IAction1<TSource> value) {
        this.__onStateChange.add(value);
    }

    @Override
    public void addOutput(TIInput output) {
        this.validateOutput(output);
        ((Collection)this.__outputs).add(output);
    }

    @Override
    public void addOutputs(TIInput[] outputs) {
        for (TIInput local : outputs) {
            this.validateOutput(local);
        }
        ((Collection)this.__outputs).addMany(outputs);
    }

    public Future<Object> changeInput(SourceInput input) {
        return this.doChangeInput(new Promise<Object>(), input);
    }

    protected abstract TIInputCollection createInputCollection(TIOutput var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        MediaSourceState state;
        Object obj2;
        Object object = obj2 = this.__stateLock;
        synchronized (object) {
            MediaSourceState _var0 = this.getState();
            if (_var0 == MediaSourceState.Starting) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is being started."));
            }
            if (_var0 == MediaSourceState.Started) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is started. (Stop the media source first.)"));
            }
            if (_var0 == MediaSourceState.Stopping) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is being stopped."));
            }
            if (_var0 == MediaSourceState.Destroying) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is being destroyed on a different thread."));
            }
            if (_var0 == MediaSourceState.Destroyed) {
                return true;
            }
            state = this.getState();
            this.setState(MediaSourceState.Destroying);
        }
        Log.debug(StringExtensions.format("Media source ({0}) is being destroyed.", this.getLabel()));
        try {
            this.doDestroy();
            object = obj2 = this.__stateLock;
            synchronized (object) {
                this.setState(MediaSourceState.Destroyed);
            }
            ((IMediaInputCollection)this.__outputs).destroy();
            return true;
        }
        catch (Exception obj1) {
            Object object2 = obj2 = this.__stateLock;
            synchronized (object2) {
                this.setState(state);
            }
            return false;
        }
    }

    private Future<Object> doChangeInput(final Promise<Object> promise, final SourceInput input) {
        IAction0 action = null;
        IAction1<Object> resolveAction = null;
        IAction1<Exception> rejectAction = null;
        IFunction1<Object, Future<Object>> resolveFunction = null;
        IAction1<Exception> action4 = null;
        IAction0 action5 = null;
        if (Global.equals(input, this.__input)) {
            if (action == null) {
                action = new IAction0(){

                    @Override
                    public void invoke() {
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action);
        } else if (Global.equals((Object)this.getState(), (Object)MediaSourceState.Started)) {
            if (resolveFunction == null) {
                resolveFunction = new IFunction1<Object, Future<Object>>(){

                    @Override
                    public Future<Object> invoke(Object result) {
                        MediaSource.this.setInput(input);
                        return MediaSource.this.start();
                    }
                };
            }
            if (action4 == null) {
                action4 = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception exception) {
                        promise.reject(exception);
                    }
                };
            }
            if (resolveAction == null) {
                resolveAction = new IAction1<Object>(){

                    @Override
                    public void invoke(Object result) {
                        promise.resolve(null);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception exception) {
                        promise.reject(exception);
                    }
                };
            }
            this.stop().then(resolveFunction, action4).then(resolveAction, rejectAction);
        } else {
            if (action5 == null) {
                action5 = new IAction0(){

                    @Override
                    public void invoke() {
                        MediaSource.this.setInput(input);
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action5);
        }
        return promise;
    }

    protected void doDestroy() {
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        if (isLocalDescription && ArrayExtensions.getLength(mediaDescription.getSsrcAttributes(this.getSynchronizationSource(), SsrcAttributeName.getCName())) == 0) {
            mediaDescription.addMediaAttribute(new SsrcAttribute(this.getSynchronizationSource(), SsrcAttributeName.getCName()));
        }
        return null;
    }

    protected void doProcessStatsFromOutput(MediaTrackStats stats) {
    }

    protected abstract Future<Object> doStart();

    protected abstract Future<Object> doStop();

    @Override
    public boolean getDisabled() {
        boolean flag = true;
        for (IMediaInput local : this.getOutputs()) {
            TFormat inputFormat = local.getInputFormat();
            if (local.getDisabled() || inputFormat == null || !((MediaFormat)inputFormat).isEquivalent(this.getOutputFormat())) continue;
            flag = false;
            break;
        }
        if (!Global.equals(this.__disabled, flag)) {
            this.__disabled = flag;
            IAction1<TSource> onDisabledChange = this._onDisabledChange;
            if (onDisabledChange != null) {
                onDisabledChange.invoke(this);
            }
        }
        return flag;
    }

    public SourceInput getInput() {
        return this.__input;
    }

    public Future<SourceInput[]> getInputs() {
        Promise<SourceInput[]> promise = new Promise<SourceInput[]>();
        promise.resolve(null);
        return promise;
    }

    @Override
    public abstract String getLabel();

    @Override
    public boolean getMuted() {
        return this._muted;
    }

    @Override
    public TIInput getOutput() {
        return (TIInput)((IMediaInput)((Collection)this.__outputs).getValue());
    }

    @Override
    public TFormat getOutputFormat() {
        return this._outputFormat;
    }

    @Override
    public TIInput[] getOutputs() {
        return (IMediaInput[])((Collection)this.__outputs).getValues();
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonOutputs(), " }"});
    }

    private String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonOutput()});
    }

    @Override
    public String getPipelineJsonFromOutput() {
        return StringExtensions.concat("{ ", this.getPipelineJsonBase(), " }");
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(super.getId()));
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonOutput() {
        return StringExtensions.concat("\"outputFormat\": ", this.getOutputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getOutputFormat()).toString()));
    }

    private String getPipelineJsonOutputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaInput local : this.getOutputs()) {
            list.add(local.getPipelineJsonFromInput());
        }
        return StringExtensions.concat("\"outputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(super.getTag()));
    }

    public MediaSourceState getState() {
        return this.__state;
    }

    public long getSynchronizationSource() {
        return this._synchronizationSource;
    }

    public boolean hasOutput(TIInput output) {
        for (IMediaInput local : this.getOutputs()) {
            if (local != output) continue;
            return true;
        }
        return false;
    }

    public MediaSource(TFormat outputFormat) {
        this.__state = MediaSourceState.New;
        this.__stateLock = new Object();
        License.checkKey();
        this.setOutputFormat(outputFormat);
        this.setSynchronizationSource(Utility.generateSynchronizationSource());
        this.__outputs = this.createInputCollection(this);
    }

    @Override
    public void processControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
            this.__processingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
                    IAction1<MediaControlFrame[]> onProcessControlFrames = this._onProcessControlFrames;
                    if (onProcessControlFrames != null) {
                        onProcessControlFrames.invoke(controlFrames);
                    }
                    this.doProcessControlFrames(controlFrames);
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media source ({0}) could not process control frames.", this.getLabel()), exception);
            }
            finally {
                this.__processingControlFrames = false;
            }
        }
    }

    @Override
    public boolean processGetMuteFromStream() {
        return this.getMuted();
    }

    @Override
    public Error processSdpMediaDescriptionFromOutput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
    }

    @Override
    public void processSetMuteFromStream(boolean mute) {
        this.setMuted(mute);
    }

    @Override
    public void processStatsFromOutput(MediaTrackStats stats) {
        stats.setStopped(Global.equals((Object)this.getState(), (Object)MediaSourceState.Stopped));
        this.doProcessStatsFromOutput(stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
            this.__raisingFrame = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
                    Object[] outputs;
                    IAction1<TFrame> onRaiseFrame;
                    for (MediaBuffer local : frame.getBuffers()) {
                        if (StringExtensions.isNullOrEmpty(local.getSourceId())) {
                            local.setSourceId(super.getId());
                        }
                        if (!this.getMuted()) continue;
                        local.mute();
                    }
                    if (((MediaFrame)frame).getSynchronizationSource() == -1L) {
                        ((MediaFrame)frame).setSynchronizationSource(this.getSynchronizationSource());
                    }
                    if ((onRaiseFrame = this._onRaiseFrame) != null) {
                        onRaiseFrame.invoke(frame);
                    }
                    if (ArrayExtensions.getLength(outputs = this.getOutputs()) > 0) {
                        for (Object local2 : outputs) {
                            if (local2.getDisabled()) continue;
                            local2.processFrame(frame);
                        }
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media source ({0}) could not raise frame.", this.getLabel()), exception);
            }
            finally {
                this.__raisingFrame = false;
            }
        }
    }

    public void removeOnDisabledChange(IAction1<TSource> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onDisabledChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onDisabledChange.remove(value);
    }

    @Override
    public void removeOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessControlFrames.remove(value);
    }

    @Override
    public void removeOnRaiseFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseFrame.remove(value);
    }

    public void removeOnStateChange(IAction1<TSource> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    @Override
    public boolean removeOutput(TIInput output) {
        return ((Collection)this.__outputs).remove(output);
    }

    @Override
    public boolean removeOutputs(TIInput[] outputs) {
        return ((Collection)this.__outputs).removeMany(outputs);
    }

    @Override
    public void removeOutputs() {
        ((Collection)this.__outputs).removeAll();
    }

    public void setInput(SourceInput value) {
        if (Global.equals((Object)this.getState(), (Object)MediaSourceState.Started)) {
            throw new RuntimeException(new Exception("Cannot set input while the source is started. Use ChangeInput instead or stop the source first."));
        }
        this.__input = value;
    }

    @Override
    public void setMuted(boolean value) {
        this._muted = value;
    }

    public void setOutput(TIInput value) {
        this.removeOutputs();
        this.addOutput(value);
    }

    private void setOutputFormat(TFormat value) {
        this._outputFormat = value;
    }

    public void setOutputs(TIInput[] value) {
        this.removeOutputs();
        this.addOutputs((IMediaInput[])value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(MediaSourceState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                IAction1<TSource> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    public void setSynchronizationSource(long value) {
        this._synchronizationSource = value;
    }

    @Override
    public Future<Object> start() {
        return this.startInternal(new Promise<Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Object> startInternal(final Promise<Object> promise) {
        Object object = this.__stateLock;
        synchronized (object) {
            MediaSourceState _var0 = this.getState();
            if (_var0 == MediaSourceState.Starting) {
                promise.reject(new Exception("A media source cannot be started while it is being started on a different thread."));
                return promise;
            }
            if (_var0 == MediaSourceState.Started) {
                promise.resolve(null);
                return promise;
            }
            if (_var0 == MediaSourceState.Stopping) {
                promise.reject(new Exception("A media source cannot be started while it is being stopped."));
                return promise;
            }
            if (_var0 == MediaSourceState.Destroying) {
                promise.reject(new Exception("A media source cannot be started while it is being destroyed."));
                return promise;
            }
            if (_var0 == MediaSourceState.Destroyed) {
                promise.reject(new Exception("A media source cannot be started while it is destroyed."));
                return promise;
            }
            this.setState(MediaSourceState.Starting);
        }
        Log.debug(StringExtensions.format("Media source ({0}) is being started.", this.getLabel()));
        this.doStart().then(new IAction1<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Object result) {
                Log.debug(StringExtensions.format("Media source ({0}) has successfully started.", MediaSource.this.getLabel()));
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Started);
                    promise.resolve(result);
                }
            }
        }, new IAction1<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Exception exception) {
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Stopped);
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    @Override
    public Future<Object> stop() {
        return this.stopInternal(new Promise<Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Object> stopInternal(final Promise<Object> promise) {
        Object object = this.__stateLock;
        synchronized (object) {
            MediaSourceState _var0 = this.getState();
            if (_var0 == MediaSourceState.New) {
                promise.resolve(null);
                return promise;
            }
            if (_var0 == MediaSourceState.Starting) {
                promise.reject(new Exception("A media source cannot be stopped while it is being started."));
                return promise;
            }
            if (_var0 == MediaSourceState.Stopping) {
                promise.reject(new Exception("A media source cannot be stopped while it is being stopped on a different thread."));
                return promise;
            }
            if (_var0 == MediaSourceState.Stopped) {
                promise.resolve(null);
                return promise;
            }
            if (_var0 == MediaSourceState.Destroying) {
                promise.reject(new Exception("A media source cannot be stopped while it is being destroyed."));
                return promise;
            }
            if (_var0 == MediaSourceState.Destroyed) {
                promise.reject(new Exception("A media source cannot be stopped while it is destroyed."));
                return promise;
            }
            this.setState(MediaSourceState.Stopping);
        }
        Log.debug(StringExtensions.format("Media source ({0}) is being stopped.", this.getLabel()));
        while (this.__raisingFrame || this.__processingControlFrames) {
            ManagedThread.sleep(10);
        }
        this.doStop().then(new IAction1<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Object result) {
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Stopped);
                    promise.resolve(result);
                }
            }
        }, new IAction1<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Exception exception) {
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Started);
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    public String toString() {
        return this.getLabel();
    }

    private void validateOutput(TIInput output) {
        if (!(output instanceof Stream) && output.getInputFormat() != null && !((MediaFormat)output.getInputFormat()).isEquivalent(this.getOutputFormat())) {
            throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Input format [", ((MediaFormat)output.getInputFormat()).toString(), "] of output (", output.getLabel(), ") does not match output format [", ((MediaFormat)this.getOutputFormat()).toString(), "] of self (", this.getLabel(), ")."})));
        }
    }
}

