/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.ArrayListExtensions;
import fm.Delegate;
import fm.ManagedCondition;
import fm.ManagedThread;
import fm.MathAssistant;
import fm.SingleAction;
import fm.websync.Publication;
import fm.websync.Publisher;
import java.util.ArrayList;

public class PublisherQueue {
    private Publisher __publisher;
    private boolean _active = false;
    private SingleAction<Exception> _exception;
    private int _maxBatchSize;
    private ArrayList<Publication> _publications = new ArrayList();
    private ManagedCondition _publicationsLock = new ManagedCondition();
    private SingleAction<Publication[]> _published;
    private Object _stateLock = new Object();
    private ManagedThread _thread = null;

    public SingleAction<Exception> addException(SingleAction<Exception> value) {
        this._exception = (SingleAction)Delegate.combine(this._exception, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPublication(Publication publication) {
        ManagedCondition managedCondition = this._publicationsLock;
        synchronized (managedCondition) {
            this._publications.add(publication);
            this._publicationsLock.pulse();
        }
    }

    public SingleAction<Publication[]> addPublished(SingleAction<Publication[]> value) {
        this._published = (SingleAction)Delegate.combine(this._published, value);
        return value;
    }

    public int getMaxBatchSize() {
        return this._maxBatchSize;
    }

    public Publisher getPublisher() {
        return this.__publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop(ManagedThread thread) throws Exception {
        while (this._active) {
            Publication[] publicationArray;
            ManagedCondition condition;
            thread.loopBegin();
            ManagedCondition managedCondition = condition = this._publicationsLock;
            synchronized (managedCondition) {
                publicationArray = this.stealPublications();
                if (ArrayExtensions.getLength((Object[])publicationArray) == 0) {
                    this._publicationsLock.halt();
                    publicationArray = this.stealPublications();
                }
            }
            if (ArrayExtensions.getLength((Object[])publicationArray) > 0) {
                ManagedCondition published;
                Exception p = null;
                try {
                    publicationArray = this.getPublisher().publishMany(publicationArray);
                }
                catch (Exception exception2) {
                    p = exception2;
                }
                if (p == null) {
                    published = this._published;
                    if (published != null) {
                        published.invoke((Object)publicationArray);
                    }
                } else {
                    published = condition = this._publicationsLock;
                    synchronized (published) {
                        for (Publication publication : publicationArray) {
                            this._publications.add(publication);
                        }
                    }
                    SingleAction<Exception> exception = this._exception;
                    if (exception != null) {
                        exception.invoke((Object)p);
                    }
                }
            }
            thread.loopEnd();
        }
    }

    public PublisherQueue(Publisher publisher) throws Exception {
        if (publisher == null) {
            throw new Exception("publisher cannot be null.");
        }
        this.__publisher = publisher;
        this.setMaxBatchSize(1000);
    }

    public void removeException(SingleAction<Exception> value) {
        this._exception = (SingleAction)Delegate.remove(this._exception, value);
    }

    public void removePublished(SingleAction<Publication[]> value) {
        this._published = (SingleAction)Delegate.remove(this._published, value);
    }

    public void setMaxBatchSize(int value) {
        this._maxBatchSize = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._active) {
                return;
            }
            this._active = true;
        }
        final PublisherQueue _var0 = this;
        this._thread = new ManagedThread((SingleAction)new SingleAction<ManagedThread>(){

            public void invoke(ManagedThread thread) {
                try {
                    _var0.loop(thread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._thread.setIsBackground(true);
        this._thread.start();
    }

    private Publication[] stealPublications() {
        int count = MathAssistant.min((int)this.getMaxBatchSize(), (int)ArrayListExtensions.getCount(this._publications));
        if (count <= 0) {
            count = ArrayListExtensions.getCount(this._publications);
        }
        Publication[] publicationArray = new Publication[count];
        for (int i = 0; i < ArrayExtensions.getLength((Object[])publicationArray); ++i) {
            publicationArray[i] = (Publication)((Object)ArrayListExtensions.getItem(this._publications).get(i));
        }
        ArrayListExtensions.removeRange(this._publications, (int)0, (int)ArrayExtensions.getLength((Object[])publicationArray));
        return publicationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this._stateLock;
        synchronized (object) {
            if (!this._active) {
                return;
            }
            this._active = false;
        }
        object = this._publicationsLock;
        synchronized (object) {
            this._publicationsLock.pulse();
        }
    }
}

