/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.Holder;
import fm.Serializer;
import fm.StringExtensions;
import fm.websync.BaseMessage;
import fm.websync.Extensible;
import fm.websync.Message;

public class Publication
extends BaseMessage {
    private String __channel;

    public static Publication fromJson(String publicationJson) throws Exception {
        return fm.websync.Serializer.deserializePublication(publicationJson);
    }

    public static Publication[] fromJsonMultiple(String publicationsJson) throws Exception {
        return fm.websync.Serializer.deserializePublicationArray(publicationsJson);
    }

    public static Publication fromMessage(Message message) throws Exception {
        if (message == null) {
            return null;
        }
        Publication publication = new Publication();
        publication.setChannel(message.getBayeuxChannel());
        publication.setSuccessful(message.getSuccessful());
        publication.setError(message.getError());
        publication.setTimestamp(message.getTimestamp());
        publication.setDataJson(message.getDataJson());
        publication.setExtensions(message.getExtensions());
        return publication;
    }

    public static Publication[] fromMessages(Message[] messages) throws Exception {
        if (messages == null) {
            return null;
        }
        Publication[] publicationArray = new Publication[ArrayExtensions.getLength((Object[])messages)];
        for (int i = 0; i < ArrayExtensions.getLength((Object[])messages); ++i) {
            publicationArray[i] = Publication.fromMessage(messages[i]);
        }
        return publicationArray;
    }

    public String getChannel() {
        return this.__channel;
    }

    public String getTag() throws Exception {
        return Serializer.deserializeString((String)super.getExtensionValueJson("fm.tag"));
    }

    public Publication() {
    }

    public Publication(String channel) throws Exception {
        this.setChannel(channel);
    }

    public Publication(String channel, String dataJson) throws Exception {
        this(channel, dataJson, null);
    }

    public Publication(String channel, String dataJson, String tag) throws Exception {
        this.setChannel(channel);
        super.setDataJson(dataJson);
        this.setTag(tag);
    }

    public Publication(String channel, byte[] dataBytes) throws Exception {
        this(channel, dataBytes, null);
    }

    public Publication(String channel, byte[] dataBytes, String tag) throws Exception {
        this.setChannel(channel);
        super.setDataBytes(dataBytes);
        this.setTag(tag);
    }

    public void setChannel(String value) throws Exception {
        if (value == null) {
            this.__channel = value;
            super.setIsDirty(true);
        } else {
            String error = null;
            Holder _var0 = new Holder(error);
            boolean _var1 = Extensible.validateChannel(value, (Holder<String>)_var0);
            error = (String)_var0.getValue();
            if (super.getValidate() && !_var1) {
                throw new Exception(StringExtensions.format((String)"Invalid channel. {0}", (Object)error));
            }
            this.__channel = value;
            super.setIsDirty(true);
        }
    }

    public void setTag(String value) throws Exception {
        super.setExtensionValueJson("fm.tag", Serializer.serializeString((String)value), false);
        super.setIsDirty(true);
    }

    public String toJson() {
        return Publication.toJson(this);
    }

    public static String toJson(Publication publication) {
        return fm.websync.Serializer.serializePublication(publication);
    }

    public static String toJsonMultiple(Publication[] publications) {
        return fm.websync.Serializer.serializePublicationArray(publications);
    }

    public static Message toMessage(Publication publication) throws Exception {
        if (publication == null) {
            return null;
        }
        Message message = new Message();
        message.setBayeuxChannel(publication.getChannel());
        message.setSuccessful(publication.getSuccessful());
        message.setError(publication.getError());
        message.setTimestamp(publication.getTimestamp());
        message.setDataJson(publication.getDataJson());
        message.setExtensions(publication.getExtensions());
        return message;
    }

    public static Message[] toMessages(Publication[] publications) throws Exception {
        if (publications == null) {
            return null;
        }
        Message[] messageArray = new Message[ArrayExtensions.getLength((Object[])publications)];
        for (int i = 0; i < ArrayExtensions.getLength((Object[])publications); ++i) {
            messageArray[i] = Publication.toMessage(publications[i]);
        }
        return messageArray;
    }
}

