/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.DataBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import fm.icelink.stun.Attribute;

public class SoftwareAttribute
extends Attribute {
    private String __value;

    @Override
    public int getTypeValue() {
        return Attribute.getSoftwareType();
    }

    public String getValue() {
        return this.__value;
    }

    @Override
    protected int getValueLength() {
        return Utf8.getByteCount(this.getValue());
    }

    public static SoftwareAttribute readValueFrom(DataBuffer buffer, int offset, int length) {
        String str = Utf8.decode(buffer.getData(), buffer.getIndex() + offset, length).trim();
        while (str.endsWith("\u0000")) {
            str = StringExtensions.substring(str, 0, StringExtensions.getLength(str) - 1);
        }
        SoftwareAttribute attribute = new SoftwareAttribute();
        attribute.setValue(str);
        return attribute;
    }

    public void setValue(String value) {
        if (StringExtensions.getLength(value) > 127) {
            throw new RuntimeException(new Exception("value must have fewer than 128 characters."));
        }
        this.__value = value;
    }

    private SoftwareAttribute() {
    }

    public SoftwareAttribute(String value) {
        this.setValue(value);
    }

    public String toString() {
        return StringExtensions.format("SOFTWARE {0}", this.getValue());
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        buffer.writeBytes(Utf8.encode(this.getValue()), offset);
    }
}

