/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.ArrayList;
import java.util.Enumeration;

public class ArrayListExtensions {
    public static <T> int getCount(ArrayList<T> array) {
        return array.size();
    }

    public static <T> ArrayList<T> getItem(ArrayList<T> array) {
        return array;
    }

    public static <T> void copyTo(ArrayList<T> array, T[] target, int index) {
        for (int i = 0; i < array.size(); ++i) {
            target[index + i] = array.get(i);
        }
    }

    public static <T> void insert(ArrayList<T> array, int index, T value) {
        array.add(index, value);
    }

    public static <T> void removeAt(ArrayList<T> array, int index) {
        array.remove(index);
    }

    public static <T> ArrayList<T> createArray(T[] elements) {
        ArrayList<T> array = new ArrayList<T>(elements.length);
        for (T element : elements) {
            array.add(element);
        }
        return array;
    }

    public static <T> ArrayList<T> createArray(Iterable<T> elements) {
        ArrayList<T> array = new ArrayList<T>();
        for (T element : elements) {
            array.add(element);
        }
        return array;
    }

    public static <T> void addRange(ArrayList<T> array, Iterable<T> elements) {
        for (T element : elements) {
            array.add(element);
        }
    }

    public static <T> void addRange(ArrayList<T> array, T[] elements) {
        for (T element : elements) {
            array.add(element);
        }
    }

    public static <T> ArrayList<T> getRange(ArrayList<T> array, int index, int count) {
        ArrayList<T> sublist = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            sublist.add(array.get(index + i));
        }
        return sublist;
    }

    public static <T> void insertRange(ArrayList<T> array, int index, Iterable<T> elements) {
        int i = 0;
        for (T element : elements) {
            array.add(index + i, element);
            ++i;
        }
    }

    public static <T> void insertRange(ArrayList<T> array, int index, T[] elements) {
        int i = 0;
        for (T element : elements) {
            array.add(index + i, element);
            ++i;
        }
    }

    public static <T> void removeRange(ArrayList<T> array, int index, int count) {
        for (int i = 0; i < count; ++i) {
            array.remove(index);
        }
    }

    public static <T> Enumeration<T> getEnumerator(final ArrayList<T> array) {
        return new Enumeration<T>(){
            int size;
            int cursor;
            {
                this.size = array.size();
            }

            @Override
            public boolean hasMoreElements() {
                return this.cursor < this.size;
            }

            @Override
            public T nextElement() {
                return array.get(this.cursor++);
            }
        };
    }
}

