/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.DateExtensions;
import fm.IntegerExtensions;
import fm.LogLevel;
import fm.StringExtensions;
import java.util.Date;

public abstract class LogProvider {
    private LogLevel _level;

    private void _log(LogLevel level, String message, Exception ex) {
        if (this.isEnabled(level)) {
            try {
                this.log(level, message, ex);
            }
            catch (Exception obj1) {
                // empty catch block
            }
        }
    }

    private void _log(LogLevel level, String message) {
        if (this.isEnabled(level)) {
            try {
                this.log(level, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void debug(String message) {
        this._log(LogLevel.Debug, message);
    }

    public void debug(String message, Exception ex) {
        this._log(LogLevel.Debug, message, ex);
    }

    public void debugFormat(String format, String[] args) {
        try {
            this.debug(StringExtensions.format(format, args));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void error(String message) {
        this._log(LogLevel.Error, message);
    }

    public void error(String message, Exception ex) {
        this._log(LogLevel.Error, message, ex);
    }

    public void errorFormat(String format, String[] args) {
        try {
            this.error(StringExtensions.format(format, args));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fatal(String message, Exception ex) {
        this._log(LogLevel.Fatal, message, ex);
    }

    public void fatal(String message) {
        this._log(LogLevel.Fatal, message);
    }

    public void fatalFormat(String format, String[] args) {
        try {
            this.fatal(StringExtensions.format(format, args));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void formatAndWriteLine(String format, String[] args) {
        try {
            this.writeLine(StringExtensions.format(format, args));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getIsDebugEnabled() {
        return this.isEnabled(LogLevel.Debug);
    }

    public boolean getIsErrorEnabled() {
        return this.isEnabled(LogLevel.Error);
    }

    public boolean getIsFatalEnabled() {
        return this.isEnabled(LogLevel.Fatal);
    }

    public boolean getIsInfoEnabled() {
        return this.isEnabled(LogLevel.Info);
    }

    public boolean getIsWarnEnabled() {
        return this.isEnabled(LogLevel.Warn);
    }

    public LogLevel getLevel() {
        return this._level;
    }

    public static String getPrefix(LogLevel level, boolean includeTimestamp) {
        String prefixLevel = LogProvider.getPrefixLevel(level);
        if (includeTimestamp) {
            prefixLevel = StringExtensions.format("{0} {1}", prefixLevel, LogProvider.getPrefixTimestamp(DateExtensions.getUtcNow()));
        }
        return prefixLevel;
    }

    public static String getPrefixLevel(LogLevel level) {
        LogLevel _var0 = level;
        if (_var0 == LogLevel.Debug) {
            return "DEBUG";
        }
        if (_var0 == LogLevel.Info) {
            return "INFO ";
        }
        if (_var0 == LogLevel.Warn) {
            return "WARN ";
        }
        if (_var0 == LogLevel.Error) {
            return "ERROR";
        }
        if (_var0 == LogLevel.Fatal) {
            return "FATAL";
        }
        if (_var0 == LogLevel.None) {
            return "NONE ";
        }
        return "?????";
    }

    public static String getPrefixTimestamp(Date timestamp) {
        String str = IntegerExtensions.toString(DateExtensions.getYear(timestamp));
        String str2 = IntegerExtensions.toString(DateExtensions.getMonth(timestamp));
        String str3 = IntegerExtensions.toString(DateExtensions.getDay(timestamp));
        String str4 = IntegerExtensions.toString(DateExtensions.getHour(timestamp));
        String str5 = IntegerExtensions.toString(DateExtensions.getMinute(timestamp));
        String str6 = IntegerExtensions.toString(DateExtensions.getSecond(timestamp));
        while (StringExtensions.getLength(str) < 4) {
            str = StringExtensions.concat("0", str);
        }
        while (StringExtensions.getLength(str2) < 2) {
            str2 = StringExtensions.concat("0", str2);
        }
        while (StringExtensions.getLength(str3) < 2) {
            str3 = StringExtensions.concat("0", str3);
        }
        while (StringExtensions.getLength(str4) < 2) {
            str4 = StringExtensions.concat("0", str4);
        }
        while (StringExtensions.getLength(str5) < 2) {
            str5 = StringExtensions.concat("0", str5);
        }
        while (StringExtensions.getLength(str6) < 2) {
            str6 = StringExtensions.concat("0", str6);
        }
        return StringExtensions.format("{0}/{1}/{2}-{3}:{4}:{5}", new Object[]{str, str2, str3, str4, str5, str6});
    }

    public void info(String message) {
        this._log(LogLevel.Info, message);
    }

    public void info(String message, Exception ex) {
        this._log(LogLevel.Info, message, ex);
    }

    public void infoFormat(String format, String[] args) {
        try {
            this.info(StringExtensions.format(format, args));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isEnabled(LogLevel level) {
        return level.getAssignedValue() >= this.getLevel().getAssignedValue();
    }

    protected abstract void log(LogLevel var1, String var2);

    protected abstract void log(LogLevel var1, String var2, Exception var3);

    public LogProvider() {
        this.setLevel(LogLevel.None);
    }

    public void setLevel(LogLevel value) {
        this._level = value;
    }

    public void warn(String message, Exception ex) {
        this._log(LogLevel.Warn, message, ex);
    }

    public void warn(String message) {
        this._log(LogLevel.Warn, message);
    }

    public void warnFormat(String format, String[] args) {
        try {
            this.warn(StringExtensions.format(format, args));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void writeLine(String var1);
}

