/*
 * Decompiled with CFR 0.152.
 */
package fm.websync.subscribers;

import fm.DeserializeCallback;
import fm.EmptyFunction;
import fm.Global;
import fm.HashMapExtensions;
import fm.Serializable;
import fm.SerializeCallback;
import fm.websync.SubscribedClient;
import fm.websync.subscribers.SubscriberChange;
import fm.websync.subscribers.SubscriberChangeType;
import java.util.HashMap;

class Serializer {
    static HashMap<String, SubscribedClient[]> createSubscribedClients() {
        return new HashMap<String, SubscribedClient[]>();
    }

    static SubscriberChange createSubscriberChange() {
        return new SubscriberChange();
    }

    public static HashMap<String, SubscribedClient[]> deserializeSubscribedClients(String subscribedClientsJson) throws Exception {
        return (HashMap)fm.Serializer.deserializeObject((String)subscribedClientsJson, (EmptyFunction)new EmptyFunction<HashMap<String, SubscribedClient[]>>(){

            public HashMap<String, SubscribedClient[]> invoke() {
                try {
                    return Serializer.createSubscribedClients();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<HashMap<String, SubscribedClient[]>>(){

            public void invoke(HashMap<String, SubscribedClient[]> subscribedClients, String name, String valueJson) {
                try {
                    Serializer.deserializeSubscribedClientsCallback(subscribedClients, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializeSubscribedClientsCallback(HashMap<String, SubscribedClient[]> subscribedClients, String name, String valueJson) throws Exception {
        HashMapExtensions.getItem(subscribedClients).put(name, SubscribedClient.fromJsonMultiple((String)valueJson));
    }

    public static SubscriberChange deserializeSubscriberChange(String subscriberChangeJson) throws Exception {
        return (SubscriberChange)fm.Serializer.deserializeObjectFast((String)subscriberChangeJson, (EmptyFunction)new EmptyFunction<SubscriberChange>(){

            public SubscriberChange invoke() {
                try {
                    return Serializer.createSubscriberChange();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<SubscriberChange>(){

            public void invoke(SubscriberChange subscriberChange, String name, String valueJson) {
                try {
                    Serializer.deserializeSubscriberChangeCallback(subscriberChange, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializeSubscriberChangeCallback(SubscriberChange subscriberChange, String name, String valueJson) throws Exception {
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"client")) {
                if (Global.equals((Object)str, (Object)"type")) {
                    subscriberChange.setType(Serializer.deserializeSubscriberChangeType(valueJson));
                }
            } else {
                subscriberChange.setClient(SubscribedClient.fromJson((String)valueJson));
            }
        }
    }

    public static SubscriberChangeType deserializeSubscriberChangeType(String subscriberChangeTypeJson) throws Exception {
        String _var0 = fm.Serializer.deserializeString((String)subscriberChangeTypeJson);
        if (_var0.equals("subscribe")) {
            return SubscriberChangeType.Subscribe;
        }
        if (_var0.equals("unsubscribe")) {
            return SubscriberChangeType.Unsubscribe;
        }
        throw new Exception("Unknown subscriber change type.");
    }

    public static String serializeSubscribedClients(HashMap<String, SubscribedClient[]> subscribedClients) {
        return fm.Serializer.serializeObject(subscribedClients, (SerializeCallback)new SerializeCallback<HashMap<String, SubscribedClient[]>>(){

            public void invoke(HashMap<String, SubscribedClient[]> subscribedClients, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeSubscribedClientsCallback(subscribedClients, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeSubscribedClientsCallback(HashMap<String, SubscribedClient[]> subscribedClients, HashMap<String, String> jsonObject) {
        for (String str : HashMapExtensions.getKeys(subscribedClients)) {
            HashMapExtensions.getItem(jsonObject).put(str, SubscribedClient.toJsonMultiple((SubscribedClient[])((SubscribedClient[])HashMapExtensions.getItem(subscribedClients).get(str))));
        }
    }

    public static String serializeSubscriberChange(SubscriberChange subscriberChange) throws Exception {
        return fm.Serializer.serializeObjectFast((Serializable)subscriberChange, (SerializeCallback)new SerializeCallback<SubscriberChange>(){

            public void invoke(SubscriberChange subscriberChange, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeSubscriberChangeCallback(subscriberChange, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeSubscriberChangeCallback(SubscriberChange subscriberChange, HashMap<String, String> jsonObject) throws Exception {
        if (subscriberChange.getClient() != null) {
            HashMapExtensions.getItem(jsonObject).put("client", SubscribedClient.toJson((SubscribedClient)subscriberChange.getClient()));
        }
        HashMapExtensions.getItem(jsonObject).put("type", Serializer.serializeSubscriberChangeType(subscriberChange.getType()));
    }

    public static String serializeSubscriberChangeType(SubscriberChangeType subscriberChangeType) throws Exception {
        String str;
        SubscriberChangeType _var0 = subscriberChangeType;
        if (_var0 == SubscriberChangeType.Subscribe) {
            str = "subscribe";
        } else if (_var0 == SubscriberChangeType.Unsubscribe) {
            str = "unsubscribe";
        } else {
            throw new Exception("Unknown subscriber change type.");
        }
        return fm.Serializer.serializeString((String)str);
    }
}

