/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.ArrayExtensions;
import fm.ArrayListExtensions;
import fm.AsyncException;
import fm.BaseWebSocket;
import fm.BitAssistant;
import fm.BooleanHolder;
import fm.ByteCollection;
import fm.ByteExtensions;
import fm.Crypto;
import fm.Dns;
import fm.DoubleAction;
import fm.Encoding;
import fm.Global;
import fm.Guid;
import fm.HashMapExtensions;
import fm.Holder;
import fm.HttpRequestCreatedArgs;
import fm.HttpResponseReceivedArgs;
import fm.IntegerExtensions;
import fm.IntegerHolder;
import fm.Log;
import fm.LongExtensions;
import fm.LongHolder;
import fm.ParseAssistant;
import fm.RandomExtensions;
import fm.SingleAction;
import fm.Splitter;
import fm.StringBuilderExtensions;
import fm.StringExtensions;
import fm.TcpConnectArgs;
import fm.TcpConnectFailureArgs;
import fm.TcpConnectSuccessArgs;
import fm.TcpReceiveArgs;
import fm.TcpReceiveFailureArgs;
import fm.TcpReceiveSuccessArgs;
import fm.TcpSendArgs;
import fm.TcpSendFailureArgs;
import fm.TcpSendSuccessArgs;
import fm.TcpSocket;
import fm.UriExtensions;
import fm.WebSocketCloseArgs;
import fm.WebSocketCloseCompleteArgs;
import fm.WebSocketFrameType;
import fm.WebSocketMockRequest;
import fm.WebSocketMockResponse;
import fm.WebSocketOpenArgs;
import fm.WebSocketOpenFailureArgs;
import fm.WebSocketOpenSuccessArgs;
import fm.WebSocketReceiveArgs;
import fm.WebSocketSendArgs;
import fm.WebSocketSendState;
import fm.WebSocketStatusCode;
import fm.WebSocketStreamFailureArgs;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class WebSocket
extends BaseWebSocket {
    private boolean __isOpen;
    private boolean __secure;
    private boolean _closing = false;
    private Exception _exception;
    private ByteCollection _fragmentedMessageBytes;
    private WebSocketFrameType _fragmentedMessageType;
    private byte[] _handshakeEndOfResponse;
    private WebSocketOpenArgs _openArgs;
    private boolean _opening = false;
    private String _protocol;
    private ByteCollection _receiveBuffer;
    private URI _requestUri;
    private String _secWebSocketAccept;
    private String _secWebSocketKey;
    private boolean _sending = false;
    private Random _sendingRandomizer;
    private ArrayList<WebSocketSendState> _sendQueue;
    private TcpSocket _socket;
    private Object _stateLock = new Object();

    @Override
    public void close(WebSocketCloseArgs closeArgs) throws Exception {
        closeArgs.setStatusCode(WebSocketStatusCode.Normal);
        closeArgs.setReason(null);
        this.close(closeArgs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(WebSocketCloseArgs closeArgs, boolean initiate) throws Exception {
        Object obj2;
        if (initiate) {
            Object obj22;
            Object object = obj22 = this._stateLock;
            synchronized (object) {
                if (this.getIsOpen() && !this._opening && !this._closing) {
                    this._sendQueue.clear();
                    ByteCollection bytes = new ByteCollection();
                    byte[] shortBytesNetwork = BitAssistant.getShortBytesNetwork((short)closeArgs.getStatusCode().getAssignedValue());
                    bytes.addRange(shortBytesNetwork);
                    if (closeArgs.getReason() != null) {
                        bytes.addRange(Encoding.getUTF8().getBytes(closeArgs.getReason()));
                    }
                    WebSocketSendArgs sendArgs = new WebSocketSendArgs();
                    sendArgs.setBinaryMessage(bytes.toArray());
                    this.send(sendArgs, WebSocketFrameType.Close);
                    this._closing = true;
                    this.close(closeArgs, false);
                }
            }
        }
        Object object = obj2 = this._stateLock;
        synchronized (object) {
            if (!this.getIsOpen()) {
                return;
            }
            this._socket.close();
            this._closing = false;
            this.__isOpen = false;
        }
        WebSocketCloseCompleteArgs args = new WebSocketCloseCompleteArgs();
        args.setStatusCode(closeArgs.getStatusCode());
        args.setReason(closeArgs.getReason());
        this.raiseCloseComplete(closeArgs, args);
    }

    @Override
    public void close() {
        try {
            this.close(new WebSocketCloseArgs());
        }
        catch (Exception exception) {
            Log.error("Could not close WebSocket.", exception);
        }
    }

    private void closeComplete(WebSocketCloseCompleteArgs e) {
        WebSocketStreamFailureArgs args = new WebSocketStreamFailureArgs();
        args.setStatusCode(e.getStatusCode());
        args.setException(this._exception);
        this.raiseStreamFailure(this._openArgs, args);
    }

    private void closeWithException(Exception ex, WebSocketStatusCode statusCode, boolean initiateClose) throws Exception {
        this._exception = ex;
        WebSocketCloseArgs closeArgs = new WebSocketCloseArgs();
        closeArgs.setStatusCode(statusCode);
        closeArgs.setReason(ex.getMessage());
        final WebSocket _var0 = this;
        closeArgs.setOnComplete(new SingleAction<WebSocketCloseCompleteArgs>(){

            @Override
            public void invoke(WebSocketCloseCompleteArgs e) {
                try {
                    _var0.closeComplete(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.close(closeArgs, initiateClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectFailure(TcpConnectFailureArgs e) {
        Object object = this._stateLock;
        synchronized (object) {
            this._opening = false;
            WebSocketOpenFailureArgs args = new WebSocketOpenFailureArgs();
            args.setException(e.getException());
            args.setStatusCode(WebSocketStatusCode.NoStatus);
            this.raiseOpenFailure(this._openArgs, args);
        }
    }

    private void connectSuccess(TcpConnectSuccessArgs e) throws Exception {
        this.handshakeSend();
    }

    private void dnsResolveCallback(String[] ipAddresses, Object state) throws Exception {
        WebSocketOpenArgs args = (WebSocketOpenArgs)state;
        if (ipAddresses == null) {
            ipAddresses = new String[]{"127.0.0.1"};
        }
        String ipAddress = ipAddresses[0];
        Log.infoFormat("WebSocket address resolved to {0}.", new String[]{ipAddress});
        this._socket = new TcpSocket(false, false, this.getSecure());
        this._receiveBuffer = new ByteCollection();
        this._sendQueue = new ArrayList();
        this._openArgs = args;
        TcpConnectArgs connectArgs = new TcpConnectArgs(ipAddress, this.getServerPort(), null);
        final WebSocket _var0 = this;
        connectArgs.setOnSuccess(new SingleAction<TcpConnectSuccessArgs>(){

            @Override
            public void invoke(TcpConnectSuccessArgs e) {
                try {
                    _var0.connectSuccess(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final WebSocket _var2 = this;
        connectArgs.setOnFailure(new SingleAction<TcpConnectFailureArgs>(){

            @Override
            public void invoke(TcpConnectFailureArgs e) {
                try {
                    _var2.connectFailure(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._socket.connectAsync(connectArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferedAmount() {
        Object object = this._stateLock;
        synchronized (object) {
            int num = 0;
            for (WebSocketSendState state : this._sendQueue) {
                num += ArrayExtensions.getLength(state.getRequestBytes());
            }
            return num;
        }
    }

    public static boolean getExists() {
        return true;
    }

    private WebSocketFrameType getFrameType(byte opcode) {
        if (opcode == 0) {
            return WebSocketFrameType.Continuation;
        }
        if (opcode == 1) {
            return WebSocketFrameType.Text;
        }
        if (opcode == 2) {
            return WebSocketFrameType.Binary;
        }
        if (opcode == 8) {
            return WebSocketFrameType.Close;
        }
        if (opcode == 9) {
            return WebSocketFrameType.Ping;
        }
        if (opcode == 10) {
            return WebSocketFrameType.Pong;
        }
        return WebSocketFrameType.Unknown;
    }

    @Override
    public boolean getIsOpen() {
        return this.__isOpen;
    }

    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public boolean getSecure() {
        return this.__secure;
    }

    private int getServerPort() {
        int port = this._requestUri.getPort();
        if (port <= 0) {
            port = Global.equals(this._requestUri.getScheme(), "wss") ? 443 : 80;
        }
        return port;
    }

    private void handshakeReceive() throws Exception {
        TcpReceiveArgs receiveArgs = new TcpReceiveArgs(null, this._openArgs.getHandshakeTimeout());
        final WebSocket _var0 = this;
        receiveArgs.setOnSuccess(new SingleAction<TcpReceiveSuccessArgs>(){

            @Override
            public void invoke(TcpReceiveSuccessArgs e) {
                try {
                    _var0.handshakeReceiveSuccess(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final WebSocket _var2 = this;
        receiveArgs.setOnFailure(new SingleAction<TcpReceiveFailureArgs>(){

            @Override
            public void invoke(TcpReceiveFailureArgs e) {
                try {
                    _var2.handshakeReceiveFailure(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._socket.receiveAsync(receiveArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeReceiveFailure(TcpReceiveFailureArgs e) throws Exception {
        try {
            Object object = this._stateLock;
            synchronized (object) {
                this._opening = false;
                WebSocketOpenFailureArgs args = new WebSocketOpenFailureArgs();
                args.setException(new Exception(StringExtensions.format("Could not receive handshake response. {0}", e.getException().getMessage()), e.getException()));
                args.setStatusCode(WebSocketStatusCode.NoStatus);
                this.raiseOpenFailure(this._openArgs, args);
            }
        }
        catch (Exception exception) {
            AsyncException.asyncThrow(exception, "WebSocket -> HandshakeReceive -> OnFailure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeReceiveSuccess(TcpReceiveSuccessArgs e) throws Exception {
        block22: {
            try {
                this._receiveBuffer.addRange(e.getBuffer());
                int index = this.indexOf(this._handshakeEndOfResponse, this._receiveBuffer.toArray());
                if (index > -1) {
                    Object obj2;
                    byte[] range = this._receiveBuffer.getRange(0, index + ArrayExtensions.getLength(this._handshakeEndOfResponse));
                    this._receiveBuffer.removeRange(0, index + ArrayExtensions.getLength(this._handshakeEndOfResponse));
                    String str = Encoding.getUTF8().getString(range, 0, ArrayExtensions.getLength(range));
                    Object[] strArray = Splitter.split(StringExtensions.trimEnd(str, new char[]{'\r', '\n'}), "\r\n");
                    HashMap<String, String> responseHeaders = new HashMap<String, String>();
                    String str2 = strArray[0];
                    if (ArrayExtensions.getLength(strArray) > 1) {
                        for (int i = 1; i < ArrayExtensions.getLength(strArray); ++i) {
                            Object[] strArray2 = StringExtensions.split((String)strArray[i], new char[]{':'});
                            if (ArrayExtensions.getLength(strArray2) != 2) continue;
                            HashMapExtensions.getItem(responseHeaders).put(((String)strArray2[0]).trim(), ((String)strArray2[1]).trim());
                        }
                    }
                    if (this._openArgs.getOnResponseReceived() != null) {
                        WebSocketMockResponse response = new WebSocketMockResponse();
                        response.setResponseUri(this._requestUri);
                        Object[] strArray3 = StringExtensions.split(str2, new char[]{' '});
                        if (ArrayExtensions.getLength(strArray3) > 1) {
                            int intResult = 0;
                            IntegerHolder _var0 = new IntegerHolder(intResult);
                            boolean _var1 = ParseAssistant.tryParseIntegerValue((String)strArray3[1], _var0);
                            intResult = _var0.getValue();
                            if (_var1) {
                                response.setStatusCode(intResult);
                            }
                        }
                        for (String str4 : HashMapExtensions.getAllKeys(responseHeaders)) {
                            if (Global.equals(StringExtensions.toLower(str4), "content-type")) {
                                response.setContentType(HashMapExtensions.getItem(responseHeaders).get(str4));
                                continue;
                            }
                            if (Global.equals(StringExtensions.toLower(str4), "content-length")) {
                                long longResult = 0L;
                                LongHolder _var2 = new LongHolder(longResult);
                                boolean _var3 = ParseAssistant.tryParseLongValue(HashMapExtensions.getItem(responseHeaders).get(str4), _var2);
                                longResult = _var2.getValue();
                                if (!_var3) continue;
                                response.setContentLength(longResult);
                                continue;
                            }
                            HashMapExtensions.getItem(response.getHeaders()).put(str4, HashMapExtensions.getItem(responseHeaders).get(str4));
                        }
                        HttpResponseReceivedArgs p = new HttpResponseReceivedArgs();
                        p.setResponse(response);
                        p.setSender(this._openArgs.getSender());
                        this._openArgs.getOnResponseReceived().invoke(p);
                    }
                    if (!this.handshakeResponseIsValid(str2, responseHeaders)) {
                        Object obj22;
                        Object object = obj22 = this._stateLock;
                        synchronized (object) {
                            this._opening = false;
                            WebSocketOpenFailureArgs args = new WebSocketOpenFailureArgs();
                            args.setException(new Exception(StringExtensions.format("Invalid handshake response ({0}).", str)));
                            args.setStatusCode(WebSocketStatusCode.NoStatus);
                            this.raiseOpenFailure(this._openArgs, args);
                            break block22;
                        }
                    }
                    Object object = obj2 = this._stateLock;
                    synchronized (object) {
                        this.__isOpen = true;
                        this._opening = false;
                        this.raiseOpenSuccess(this._openArgs, new WebSocketOpenSuccessArgs());
                        if (ArrayListExtensions.getCount(this._sendQueue) > 0) {
                            WebSocketSendState state = ArrayListExtensions.getItem(this._sendQueue).get(0);
                            this.sendNow(state.getSendArgs(), state.getRequestBytes());
                        }
                    }
                    this.listen();
                    break block22;
                }
                this.handshakeReceive();
            }
            catch (Exception exception) {
                Object obj2;
                Object object = obj2 = this._stateLock;
                synchronized (object) {
                    this._opening = false;
                    WebSocketOpenFailureArgs args3 = new WebSocketOpenFailureArgs();
                    args3.setException(exception);
                    args3.setStatusCode(WebSocketStatusCode.NoStatus);
                    this.raiseOpenFailure(this._openArgs, args3);
                }
            }
        }
    }

    private boolean handshakeResponseIsValid(String responseLine1, HashMap<String, String> responseHeaders) {
        if (!Global.equals(responseLine1, "HTTP/1.1 101 Switching Protocols")) {
            return false;
        }
        String str = HashMapExtensions.getItem(responseHeaders).get("Upgrade");
        String str2 = HashMapExtensions.getItem(responseHeaders).get("Connection");
        String str3 = HashMapExtensions.getItem(responseHeaders).get("Sec-WebSocket-Accept");
        String str4 = HashMapExtensions.getItem(responseHeaders).get("Sec-WebSocket-Protocol");
        if (str == null || str2 == null || str3 == null) {
            return false;
        }
        if (!(Global.equals(StringExtensions.toLower(str), "websocket") && Global.equals(StringExtensions.toLower(str2), "upgrade") && Global.equals(StringExtensions.toLower(str3), StringExtensions.toLower(this._secWebSocketAccept)))) {
            return false;
        }
        return str4 == null || this.getProtocol() == null || Global.equals(StringExtensions.toLower(str4), StringExtensions.toLower(this.getProtocol()));
    }

    private void handshakeSend() throws Exception {
        String str = StringExtensions.concat(UriExtensions.getAbsolutePath(this._requestUri), UriExtensions.getQuery(this._requestUri));
        String dnsSafeHost = UriExtensions.getDnsSafeHost(this._requestUri);
        if (this.getServerPort() != 80) {
            dnsSafeHost = StringExtensions.concat(dnsSafeHost, ":", IntegerExtensions.toString(this.getServerPort()));
        }
        WebSocketMockRequest request = new WebSocketMockRequest();
        request.setRequestUri(new URI(this._requestUri.toString().replace("ws://", "http://").replace("wss://", "https://")));
        request.setMethod("GET");
        if (this._openArgs.getHeaders() != null) {
            for (String str3 : HashMapExtensions.getAllKeys(this._openArgs.getHeaders())) {
                HashMapExtensions.getItem(request.getHeaders()).put(str3, HashMapExtensions.getItem(this._openArgs.getHeaders()).get(str3));
            }
        }
        if (!StringExtensions.isNullOrEmpty(this.getProtocol())) {
            HashMapExtensions.getItem(request.getHeaders()).put("Sec-WebSocket-Protocol", this.getProtocol());
        }
        if (this._openArgs.getOnRequestCreated() != null) {
            HttpRequestCreatedArgs p = new HttpRequestCreatedArgs();
            p.setRequest(request);
            p.setSender(this._openArgs.getSender());
            this._openArgs.getOnRequestCreated().invoke(p);
        }
        StringBuilder builder = new StringBuilder();
        for (String str4 : HashMapExtensions.getAllKeys(request.getHeaders())) {
            StringBuilderExtensions.append(builder, StringExtensions.format("{0}: {1}\r\n", str4, HashMapExtensions.getItem(request.getHeaders()).get(str4)));
        }
        String s = StringExtensions.concat(new String[]{"GET ", str, " HTTP/1.1\r\nHost: ", dnsSafeHost, "\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: ", this._secWebSocketKey, "\r\nSec-WebSocket-Version: 13\r\n", builder.toString(), "\r\n"});
        byte[] bytes = Encoding.getUTF8().getBytes(s);
        TcpSendArgs sendArgs = new TcpSendArgs(bytes, null, this._openArgs.getHandshakeTimeout());
        final WebSocket _var0 = this;
        sendArgs.setOnSuccess(new SingleAction<TcpSendSuccessArgs>(){

            @Override
            public void invoke(TcpSendSuccessArgs e) {
                try {
                    _var0.handshakeSendSuccess(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final WebSocket _var2 = this;
        sendArgs.setOnFailure(new SingleAction<TcpSendFailureArgs>(){

            @Override
            public void invoke(TcpSendFailureArgs e) {
                try {
                    _var2.handshakeSendFailure(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._socket.sendAsync(sendArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeSendFailure(TcpSendFailureArgs e) {
        Object object = this._stateLock;
        synchronized (object) {
            this._opening = false;
            WebSocketOpenFailureArgs args = new WebSocketOpenFailureArgs();
            args.setException(new Exception(StringExtensions.format("Could not send handshake request. {0}", e.getException().getMessage()), e.getException()));
            args.setStatusCode(WebSocketStatusCode.NoStatus);
            this.raiseOpenFailure(this._openArgs, args);
        }
    }

    private void handshakeSendSuccess(TcpSendSuccessArgs e) throws Exception {
        this.handshakeReceive();
    }

    private int indexOf(byte[] pattern, byte[] data) {
        int num = -1;
        int index = 0;
        int num3 = 0;
        for (index = 0; index < ArrayExtensions.getLength(data); ++index) {
            byte num4 = data[index];
            byte num5 = pattern[num3];
            if (num4 == num5) {
                if (num3 == 0) {
                    num = index;
                }
                if (num3 == ArrayExtensions.getLength(pattern) - 1) {
                    return num;
                }
                ++num3;
                continue;
            }
            num3 = 0;
        }
        return -1;
    }

    private void listen() throws Exception {
        TcpReceiveArgs receiveArgs = new TcpReceiveArgs(null, this._openArgs.getStreamTimeout());
        final WebSocket _var0 = this;
        receiveArgs.setOnSuccess(new SingleAction<TcpReceiveSuccessArgs>(){

            @Override
            public void invoke(TcpReceiveSuccessArgs e) {
                try {
                    _var0.listenSuccess(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final WebSocket _var2 = this;
        receiveArgs.setOnFailure(new SingleAction<TcpReceiveFailureArgs>(){

            @Override
            public void invoke(TcpReceiveFailureArgs e) {
                try {
                    _var2.listenFailure(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._socket.receiveAsync(receiveArgs);
    }

    private void listenFailure(TcpReceiveFailureArgs e) throws Exception {
        try {
            if (this.getIsOpen() && !this._opening && !this._closing) {
                this.closeWithException(e.getException(), WebSocketStatusCode.GoingAway, true);
            }
        }
        catch (Exception exception) {
            AsyncException.asyncThrow(exception, "WebSocket -> Listen -> OnFailure");
        }
    }

    private void listenSuccess(TcpReceiveSuccessArgs e) throws Exception {
        try {
            if (this.getIsOpen() && !this._opening && !this._closing) {
                this._receiveBuffer.addRange(e.getBuffer());
                WebSocketStatusCode normal = WebSocketStatusCode.Normal;
                Exception exception = null;
                boolean initiateClose = false;
                Holder<WebSocketStatusCode> _var0 = new Holder<WebSocketStatusCode>(normal);
                Holder<Object> _var1 = new Holder<Object>(exception);
                BooleanHolder _var2 = new BooleanHolder(initiateClose);
                boolean _var3 = this.processReceiveBuffer(_var0, _var1, _var2);
                normal = _var0.getValue();
                exception = _var1.getValue();
                initiateClose = _var2.getValue();
                if (_var3) {
                    this.listen();
                } else {
                    this.closeWithException(exception, normal, initiateClose);
                }
            }
        }
        catch (Exception exception2) {
            AsyncException.asyncThrow(exception2, "WebSocket -> Listen -> OnSuccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(WebSocketOpenArgs openArgs) throws Exception {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getIsOpen()) {
                WebSocketOpenFailureArgs args = new WebSocketOpenFailureArgs();
                args.setException(new Exception("Already open."));
                args.setStatusCode(WebSocketStatusCode.NoStatus);
                this.raiseOpenFailure(openArgs, args);
                return;
            }
            if (this._opening) {
                WebSocketOpenFailureArgs args2 = new WebSocketOpenFailureArgs();
                args2.setException(new Exception("Already opening."));
                args2.setStatusCode(WebSocketStatusCode.NoStatus);
                this.raiseOpenFailure(openArgs, args2);
                return;
            }
            this._opening = true;
        }
        this.__secure = Global.equals(this._requestUri.getScheme(), "wss");
        final WebSocket _var0 = this;
        Dns.resolve(UriExtensions.getDnsSafeHost(this._requestUri), new DoubleAction<String[], Object>(){

            @Override
            public void invoke(String[] ipAddresses, Object state) {
                try {
                    _var0.dnsResolveCallback(ipAddresses, state);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, openArgs);
    }

    private boolean processReceiveBuffer(Holder<WebSocketStatusCode> statusCode, Holder<Exception> exception, BooleanHolder initiateClose) throws Exception {
        WebSocketFrameType frameType;
        boolean finalFlag;
        byte[] range;
        boolean _var0;
        statusCode.setValue(WebSocketStatusCode.Normal);
        exception.setValue(null);
        initiateClose.setValue(true);
        do {
            if (this._receiveBuffer.getCount() < 2) {
                return true;
            }
            byte num = this._receiveBuffer.get(0);
            byte num2 = this._receiveBuffer.get(1);
            finalFlag = (num & 0x80) == 128;
            byte opcode = (byte)(num & 0xF);
            frameType = this.getFrameType(opcode);
            if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Unknown)) {
                statusCode.setValue(WebSocketStatusCode.InvalidType);
                exception.setValue(new Exception(StringExtensions.format("Invalid frame type received (opcode {0}).", ByteExtensions.toString(opcode))));
                return false;
            }
            if ((num2 & 0x80) == 128) {
                statusCode.setValue(WebSocketStatusCode.ProtocolError);
                exception.setValue(new Exception("Masked frame received from server."));
                return false;
            }
            long num4 = num2 & 0x7F;
            int index = 2;
            int count = 0;
            if (num4 == 126L) {
                count = 2;
            } else if (num4 == 127L) {
                count = 8;
            }
            if (this._receiveBuffer.getCount() < count + 2) {
                return true;
            }
            if (count > 0) {
                byte[] buffer = this._receiveBuffer.getRange(2, count);
                if (count == 2) {
                    num4 = BitAssistant.toIntegerFromShortNetwork(buffer, 0);
                } else if (count == 8) {
                    num4 = BitAssistant.toLongNetwork(buffer, 0);
                }
                index += count;
            }
            if (num4 > Integer.MAX_VALUE) {
                statusCode.setValue(WebSocketStatusCode.MessageTooLarge);
                exception.setValue(new Exception(StringExtensions.format("Maximum payload size of 2GB was exceeded (actual {0} bytes).", LongExtensions.toString(num4))));
                return false;
            }
            int num7 = (int)num4;
            if (this._receiveBuffer.getCount() < index + num7) {
                return true;
            }
            range = this._receiveBuffer.getRange(index, num7);
            this._receiveBuffer.removeRange(0, index + num7);
        } while (_var0 = this.processReceiveFrame(range, finalFlag, frameType, statusCode, exception, initiateClose));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processReceiveFrame(byte[] payloadData, boolean finalFlag, WebSocketFrameType frameType, Holder<WebSocketStatusCode> statusCode, Holder<Exception> exception, BooleanHolder initiateClose) throws Exception {
        WebSocketFrameType fragmentedMessageType;
        byte[] buffer;
        statusCode.setValue(WebSocketStatusCode.Normal);
        exception.setValue(null);
        initiateClose.setValue(true);
        if (!finalFlag) {
            if (!Global.equals((Object)frameType, (Object)WebSocketFrameType.Continuation)) {
                this._fragmentedMessageBytes = new ByteCollection(payloadData);
                this._fragmentedMessageType = frameType;
            } else {
                this._fragmentedMessageBytes.addRange(payloadData);
            }
            return true;
        }
        if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Continuation)) {
            this._fragmentedMessageBytes.addRange(payloadData);
            buffer = this._fragmentedMessageBytes.toArray();
            fragmentedMessageType = this._fragmentedMessageType;
        } else {
            buffer = payloadData;
            fragmentedMessageType = frameType;
        }
        if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Close)) {
            Object object = this._stateLock;
            synchronized (object) {
                this._sendQueue.clear();
                if (!this._closing) {
                    try {
                        WebSocketSendArgs sendArgs = new WebSocketSendArgs();
                        sendArgs.setBinaryMessage(buffer);
                        this.send(sendArgs, WebSocketFrameType.Close);
                    }
                    catch (Exception exception1) {
                        // empty catch block
                    }
                }
                this._closing = true;
            }
            statusCode.setValue(WebSocketStatusCode.NoStatus);
            if (ArrayExtensions.getLength(buffer) >= 2) {
                short num = BitAssistant.toShortNetwork(buffer, 0);
                try {
                    statusCode.setValue(WebSocketStatusCode.getByAssignedValue(num));
                }
                catch (Exception exception2) {
                    statusCode.setValue(WebSocketStatusCode.NoStatus);
                }
            }
            String str = null;
            if (ArrayExtensions.getLength(buffer) > 2) {
                try {
                    str = Encoding.getUTF8().getString(buffer, 2, ArrayExtensions.getLength(buffer) - 2);
                }
                catch (Exception exception3) {
                    str = "Reason was given, but not in UTF-8 format.";
                }
            }
            exception.setValue(new Exception(StringExtensions.format("Connection closed ({0}).", str)));
            initiateClose.setValue(false);
            return false;
        }
        if (Global.equals((Object)fragmentedMessageType, (Object)WebSocketFrameType.Text)) {
            String str2;
            try {
                str2 = Encoding.getUTF8().getString(buffer, 0, ArrayExtensions.getLength(buffer));
            }
            catch (Exception exception4) {
                statusCode.setValue(WebSocketStatusCode.InvalidData);
                exception.setValue(new Exception("Message of type text was not in UTF-8 format."));
                return false;
            }
            WebSocketReceiveArgs args = new WebSocketReceiveArgs();
            args.setTextMessage(str2);
            this.raiseReceive(this._openArgs, args);
        } else if (Global.equals((Object)fragmentedMessageType, (Object)WebSocketFrameType.Binary)) {
            WebSocketReceiveArgs args3 = new WebSocketReceiveArgs();
            args3.setBinaryMessage(buffer);
            this.raiseReceive(this._openArgs, args3);
        } else if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Ping)) {
            try {
                WebSocketSendArgs args4 = new WebSocketSendArgs();
                args4.setBinaryMessage(buffer);
                this.send(args4, WebSocketFrameType.Pong);
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
        boolean _var0 = this.processReceiveBuffer(statusCode, exception, initiateClose);
        return _var0;
    }

    private void raiseCloseComplete(WebSocketCloseArgs closeArgs, WebSocketCloseCompleteArgs args) {
        if (closeArgs != null && closeArgs.getOnComplete() != null) {
            args.setCloseArgs(closeArgs);
            closeArgs.getOnComplete().invoke(args);
        }
    }

    private void raiseOpenFailure(WebSocketOpenArgs openArgs, WebSocketOpenFailureArgs args) {
        if (openArgs != null && openArgs.getOnFailure() != null) {
            args.setOpenArgs(openArgs);
            openArgs.getOnFailure().invoke(args);
        }
    }

    private void raiseOpenSuccess(WebSocketOpenArgs openArgs, WebSocketOpenSuccessArgs args) {
        if (openArgs != null && openArgs.getOnSuccess() != null) {
            args.setOpenArgs(openArgs);
            openArgs.getOnSuccess().invoke(args);
        }
    }

    private void raiseReceive(WebSocketOpenArgs openArgs, WebSocketReceiveArgs args) {
        if (openArgs != null && openArgs.getOnReceive() != null) {
            args.setOpenArgs(openArgs);
            openArgs.getOnReceive().invoke(args);
        }
    }

    private void raiseStreamFailure(WebSocketOpenArgs openArgs, WebSocketStreamFailureArgs args) {
        if (openArgs != null && openArgs.getOnStreamFailure() != null) {
            args.setOpenArgs(openArgs);
            openArgs.getOnStreamFailure().invoke(args);
        }
    }

    @Override
    public void send(WebSocketSendArgs sendArgs) throws Exception {
        if (sendArgs.getTextMessage() == null && sendArgs.getBinaryMessage() == null) {
            throw new Exception("textMessage and binaryMessage cannot both be null.");
        }
        if (sendArgs.getBinaryMessage() == null) {
            sendArgs.setBinaryMessage(Encoding.getUTF8().getBytes(sendArgs.getTextMessage()));
            this.send(sendArgs, WebSocketFrameType.Text);
        } else {
            this.send(sendArgs, WebSocketFrameType.Binary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(WebSocketSendArgs sendArgs, WebSocketFrameType frameType) throws Exception {
        if (this.getIsOpen()) {
            ByteCollection bytes = new ByteCollection();
            WebSocketFrameType _var0 = frameType;
            if (_var0 == WebSocketFrameType.Continuation) {
                bytes.add((byte)-128);
            } else if (_var0 == WebSocketFrameType.Text) {
                bytes.add((byte)-127);
            } else if (_var0 == WebSocketFrameType.Binary) {
                bytes.add((byte)-126);
            } else if (_var0 == WebSocketFrameType.Close) {
                bytes.add((byte)-120);
            } else if (_var0 == WebSocketFrameType.Ping) {
                bytes.add((byte)-119);
            } else if (_var0 == WebSocketFrameType.Pong) {
                bytes.add((byte)-118);
            }
            if (sendArgs.getBinaryMessage() == null) {
                bytes.add((byte)-128);
            } else if (ArrayExtensions.getLength(sendArgs.getBinaryMessage()) < 126) {
                byte length = (byte)ArrayExtensions.getLength(sendArgs.getBinaryMessage());
                bytes.add((byte)(0x80 | length));
            } else if (ArrayExtensions.getLength(sendArgs.getBinaryMessage()) <= 65535) {
                bytes.add((byte)-2);
                byte[] shortBytesFromIntegerNetwork = BitAssistant.getShortBytesFromIntegerNetwork(ArrayExtensions.getLength(sendArgs.getBinaryMessage()));
                bytes.addRange(shortBytesFromIntegerNetwork);
            } else {
                bytes.add((byte)-1);
                byte[] shortBytesFromIntegerNetwork = BitAssistant.getLongBytesNetwork(ArrayExtensions.getLength(sendArgs.getBinaryMessage()));
                bytes.addRange(shortBytesFromIntegerNetwork);
            }
            byte[] buffer2 = new byte[4];
            RandomExtensions.nextBytes(this._sendingRandomizer, buffer2);
            if (BitAssistant.isLittleEndian()) {
                BitAssistant.reverse(buffer2);
            }
            bytes.addRange(buffer2);
            if (sendArgs.getBinaryMessage() != null) {
                for (int i = 0; i < ArrayExtensions.getLength(sendArgs.getBinaryMessage()); ++i) {
                    int index = i % 4;
                    sendArgs.getBinaryMessage()[i] = (byte)(sendArgs.getBinaryMessage()[i] ^ buffer2[index]);
                }
                bytes.addRange(sendArgs.getBinaryMessage());
            }
            Object object = this._stateLock;
            synchronized (object) {
                if (!this.getIsOpen() || this._opening || this._closing) {
                    WebSocketSendState item = new WebSocketSendState();
                    item.setSendArgs(sendArgs);
                    item.setRequestBytes(bytes.toArray());
                    this._sendQueue.add(item);
                    return;
                }
                if (this._sending) {
                    WebSocketSendState state2 = new WebSocketSendState();
                    state2.setSendArgs(sendArgs);
                    state2.setRequestBytes(bytes.toArray());
                    this._sendQueue.add(state2);
                    return;
                }
                this._sending = true;
            }
            this.sendNow(sendArgs, bytes.toArray());
        }
    }

    private void sendNow(WebSocketSendArgs sendArgs, byte[] requestBytes) throws Exception {
        TcpSendArgs args = new TcpSendArgs(requestBytes, null, sendArgs.getTimeout());
        final WebSocket _var0 = this;
        args.setOnSuccess(new SingleAction<TcpSendSuccessArgs>(){

            @Override
            public void invoke(TcpSendSuccessArgs e) {
                try {
                    _var0.sendNowSuccess(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final WebSocket _var2 = this;
        args.setOnFailure(new SingleAction<TcpSendFailureArgs>(){

            @Override
            public void invoke(TcpSendFailureArgs e) {
                try {
                    _var2.sendNowFailure(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._socket.sendAsync(args);
    }

    private void sendNowFailure(TcpSendFailureArgs e) throws Exception {
        this.closeWithException(e.getException(), WebSocketStatusCode.GoingAway, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNowSuccess(TcpSendSuccessArgs e) throws Exception {
        Object object = this._stateLock;
        synchronized (object) {
            if (ArrayListExtensions.getCount(this._sendQueue) > 0) {
                WebSocketSendState state = ArrayListExtensions.getItem(this._sendQueue).get(0);
                ArrayListExtensions.removeAt(this._sendQueue, 0);
                this.sendNow(state.getSendArgs(), state.getRequestBytes());
            } else {
                this._sending = false;
            }
        }
    }

    private void setProtocol(String value) {
        this._protocol = value;
    }

    public WebSocket(String requestUrl) {
        this(requestUrl, null);
    }

    public WebSocket(String requestUrl, String protocol) {
        this._handshakeEndOfResponse = Encoding.getUTF8().getBytes("\r\n\r\n");
        this._sendingRandomizer = new Random();
        try {
            this._requestUri = new URI(requestUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProtocol(protocol);
        this._secWebSocketKey = Crypto.base64Encode(Guid.newGuid().toByteArray());
        this._secWebSocketAccept = Crypto.base64Encode(Crypto.sha1Hash(StringExtensions.concat(this._secWebSocketKey, "258EAFA5-E914-47DA-95CA-C5AB0DC85B11")));
    }
}

