/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.ArrayExtensions;
import fm.Binary;
import fm.BitAssistant;
import fm.ByteCollection;
import fm.ByteInputStream;
import fm.ByteOutputStream;
import fm.IntegerHolder;

public class LittleEndianBuffer {
    public static int fromBuffer16(ByteCollection buffer, int offset) {
        return Binary.fromBytes16(LittleEndianBuffer.getValue32FromBuffer(buffer, offset, 2), 0, true);
    }

    public static int fromBuffer24(ByteCollection buffer, int offset) {
        return Binary.fromBytes24(LittleEndianBuffer.getValue32FromBuffer(buffer, offset, 3), 0, true);
    }

    public static long fromBuffer32(ByteCollection buffer, int offset) {
        return Binary.fromBytes32(LittleEndianBuffer.getValue64FromBuffer(buffer, offset, 4), 0, true);
    }

    public static long fromBuffer40(ByteCollection buffer, int offset) {
        return Binary.fromBytes40(LittleEndianBuffer.getValue64FromBuffer(buffer, offset, 5), 0, true);
    }

    public static long fromBuffer48(ByteCollection buffer, int offset) {
        return Binary.fromBytes48(LittleEndianBuffer.getValue64FromBuffer(buffer, offset, 6), 0, true);
    }

    public static long fromBuffer56(ByteCollection buffer, int offset) {
        return Binary.fromBytes48(LittleEndianBuffer.getValue64FromBuffer(buffer, offset, 7), 0, true);
    }

    public static long fromBuffer64(ByteCollection buffer, int offset) {
        return Binary.fromBytes48(LittleEndianBuffer.getValue64FromBuffer(buffer, offset, 8), 0, true);
    }

    public static int fromBuffer8(ByteCollection buffer, int offset) {
        return buffer.get(offset);
    }

    public static int fromData16(byte[] data, int offset) {
        return Binary.fromBytes16(data, offset, true);
    }

    public static int fromData24(byte[] data, int offset) {
        return Binary.fromBytes24(data, offset, true);
    }

    public static long fromData32(byte[] data, int offset) {
        return Binary.fromBytes32(data, offset, true);
    }

    public static long fromData40(byte[] data, int offset) {
        return Binary.fromBytes40(data, offset, true);
    }

    public static long fromData48(byte[] data, int offset) {
        return Binary.fromBytes48(data, offset, true);
    }

    public static long fromData56(byte[] data, int offset) {
        return Binary.fromBytes56(data, offset, true);
    }

    public static long fromData64(byte[] data, int offset) {
        return Binary.fromBytes64(data, offset, true);
    }

    public static int fromData8(byte[] data, int offset) {
        return data[offset];
    }

    public static int fromStream16(ByteInputStream stream) throws Exception {
        return Binary.fromBytes16(LittleEndianBuffer.getValue32FromStream(stream, 2), 0, true);
    }

    public static int fromStream24(ByteInputStream stream) throws Exception {
        return Binary.fromBytes24(LittleEndianBuffer.getValue32FromStream(stream, 3), 0, true);
    }

    public static long fromStream32(ByteInputStream stream) throws Exception {
        return Binary.fromBytes32(LittleEndianBuffer.getValue64FromStream(stream, 4), 0, true);
    }

    public static long fromStream40(ByteInputStream stream) throws Exception {
        return Binary.fromBytes40(LittleEndianBuffer.getValue64FromStream(stream, 5), 0, true);
    }

    public static long fromStream48(ByteInputStream stream) throws Exception {
        return Binary.fromBytes48(LittleEndianBuffer.getValue64FromStream(stream, 6), 0, true);
    }

    public static long fromStream56(ByteInputStream stream) throws Exception {
        return Binary.fromBytes56(LittleEndianBuffer.getValue64FromStream(stream, 7), 0, true);
    }

    public static long fromStream64(ByteInputStream stream) throws Exception {
        return Binary.fromBytes64(LittleEndianBuffer.getValue64FromStream(stream, 8), 0, true);
    }

    public static int fromStream8(ByteInputStream stream) {
        return stream.read();
    }

    private static byte[] getValue32FromBuffer(ByteCollection buffer, int offset, int count) {
        return LittleEndianBuffer.getValueFromBuffer(buffer, 4, offset, count);
    }

    private static byte[] getValue32FromData(byte[] data, int offset, int count) {
        return LittleEndianBuffer.getValueFromData(data, 4, offset, count);
    }

    private static byte[] getValue32FromStream(ByteInputStream stream, int count) throws Exception {
        return LittleEndianBuffer.getValueFromStream(stream, 4, count);
    }

    private static byte[] getValue64FromBuffer(ByteCollection buffer, int offset, int count) {
        return LittleEndianBuffer.getValueFromBuffer(buffer, 8, offset, count);
    }

    private static byte[] getValue64FromData(byte[] data, int offset, int count) {
        return LittleEndianBuffer.getValueFromData(data, 8, offset, count);
    }

    private static byte[] getValue64FromStream(ByteInputStream stream, int count) throws Exception {
        return LittleEndianBuffer.getValueFromStream(stream, 8, count);
    }

    private static byte[] getValueFromBuffer(ByteCollection buffer, int length, int offset, int count) {
        int num;
        byte[] buffer2 = new byte[length];
        for (num = 0; num < length; ++num) {
            buffer2[num] = 0;
        }
        for (num = 0; num < count; ++num) {
            buffer2[num] = buffer.get(offset + num);
        }
        return buffer2;
    }

    private static byte[] getValueFromData(byte[] data, int length, int offset, int count) {
        int num;
        byte[] buffer = new byte[length];
        for (num = 0; num < length; ++num) {
            buffer[num] = 0;
        }
        for (num = 0; num < count; ++num) {
            buffer[num] = data[offset + num];
        }
        return buffer;
    }

    private static byte[] getValueFromStream(ByteInputStream stream, int length, int count) throws Exception {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = 0;
        }
        if (stream.read(buffer, 0, count) != count) {
            throw new Exception("Cannot read value beyond end of stream.");
        }
        return buffer;
    }

    public static byte[] readBuffer(int length, ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + length);
        return buffer.getRange(offset, length);
    }

    public static byte[] readBuffer(int length, ByteCollection buffer, int offset) {
        return buffer.getRange(offset, length);
    }

    public static int readBuffer16(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = LittleEndianBuffer.readBuffer16(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer16(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 2);
        return LittleEndianBuffer.fromBuffer16(buffer, offset);
    }

    public static int readBuffer24(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = LittleEndianBuffer.readBuffer24(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer24(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 3);
        return LittleEndianBuffer.fromBuffer24(buffer, offset);
    }

    public static long readBuffer32(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 4);
        return LittleEndianBuffer.fromBuffer32(buffer, offset);
    }

    public static long readBuffer32(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readBuffer32(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer40(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 5);
        return LittleEndianBuffer.fromBuffer40(buffer, offset);
    }

    public static long readBuffer40(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readBuffer40(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer48(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readBuffer48(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer48(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 6);
        return LittleEndianBuffer.fromBuffer48(buffer, offset);
    }

    public static long readBuffer56(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 7);
        return LittleEndianBuffer.fromBuffer56(buffer, offset);
    }

    public static long readBuffer56(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readBuffer56(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readBuffer64(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 8);
        return LittleEndianBuffer.fromBuffer64(buffer, offset);
    }

    public static long readBuffer64(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readBuffer64(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer8(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = LittleEndianBuffer.readBuffer8(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readBuffer8(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 1);
        return LittleEndianBuffer.fromBuffer8(buffer, offset);
    }

    public static byte[] readBufferOpaque16(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readBufferOpaque16(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readBufferOpaque16(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        int _var0 = LittleEndianBuffer.readBuffer16(buffer, offset, offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readBuffer(_var0, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque24(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readBufferOpaque24(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readBufferOpaque24(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        int _var0 = LittleEndianBuffer.readBuffer24(buffer, offset, offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readBuffer(_var0, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque32(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        long _var0 = LittleEndianBuffer.readBuffer32(buffer, offset, offsetPlus);
        int length = (int)_var0;
        byte[] _var1 = LittleEndianBuffer.readBuffer(length, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque32(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readBufferOpaque32(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readBufferOpaque8(ByteCollection buffer, int offset, IntegerHolder offsetPlus) {
        int _var0 = LittleEndianBuffer.readBuffer8(buffer, offset, offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readBuffer(_var0, buffer, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readBufferOpaque8(ByteCollection buffer, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readBufferOpaque8(buffer, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readData(int length, byte[] data, int offset) {
        return BitAssistant.subArray(data, offset, length);
    }

    public static byte[] readData(int length, byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + length);
        return BitAssistant.subArray(data, offset, length);
    }

    public static int readData16(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 2);
        return LittleEndianBuffer.fromData16(data, offset);
    }

    public static int readData16(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = LittleEndianBuffer.readData16(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readData24(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 3);
        return LittleEndianBuffer.fromData24(data, offset);
    }

    public static int readData24(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = LittleEndianBuffer.readData24(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData32(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 4);
        return LittleEndianBuffer.fromData32(data, offset);
    }

    public static long readData32(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readData32(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData40(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 5);
        return LittleEndianBuffer.fromData40(data, offset);
    }

    public static long readData40(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readData40(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData48(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readData48(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData48(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 6);
        return LittleEndianBuffer.fromData48(data, offset);
    }

    public static long readData56(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readData56(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static long readData56(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 7);
        return LittleEndianBuffer.fromData56(data, offset);
    }

    public static long readData64(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 8);
        return LittleEndianBuffer.fromData64(data, offset);
    }

    public static long readData64(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        long _var1 = LittleEndianBuffer.readData64(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readData8(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        int _var1 = LittleEndianBuffer.readData8(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static int readData8(byte[] data, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 1);
        return LittleEndianBuffer.fromData8(data, offset);
    }

    public static byte[] readDataOpaque16(byte[] data, int offset, IntegerHolder offsetPlus) {
        int _var0 = LittleEndianBuffer.readData16(data, offset, offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readData(_var0, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readDataOpaque16(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readDataOpaque16(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque24(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readDataOpaque24(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque24(byte[] data, int offset, IntegerHolder offsetPlus) {
        int _var0 = LittleEndianBuffer.readData24(data, offset, offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readData(_var0, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readDataOpaque32(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readDataOpaque32(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque32(byte[] data, int offset, IntegerHolder offsetPlus) {
        long _var0 = LittleEndianBuffer.readData32(data, offset, offsetPlus);
        int length = (int)_var0;
        byte[] _var1 = LittleEndianBuffer.readData(length, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readDataOpaque8(byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readDataOpaque8(data, offset, _var0);
        offsetPlus = _var0.getValue();
        return _var1;
    }

    public static byte[] readDataOpaque8(byte[] data, int offset, IntegerHolder offsetPlus) {
        int _var0 = LittleEndianBuffer.readData8(data, offset, offsetPlus);
        byte[] _var1 = LittleEndianBuffer.readData(_var0, data, offset, offsetPlus);
        return _var1;
    }

    public static byte[] readStream(int length, ByteInputStream stream) {
        byte[] buffer = new byte[length];
        int count = stream.read(buffer, 0, length);
        if (count != length) {
            buffer = BitAssistant.subArray(buffer, 0, count);
        }
        return buffer;
    }

    public static int readStream16(ByteInputStream stream) throws Exception {
        return LittleEndianBuffer.fromStream16(stream);
    }

    public static int readStream24(ByteInputStream stream) throws Exception {
        return LittleEndianBuffer.fromStream24(stream);
    }

    public static long readStream32(ByteInputStream stream) throws Exception {
        return LittleEndianBuffer.fromStream32(stream);
    }

    public static long readStream40(ByteInputStream stream) throws Exception {
        return LittleEndianBuffer.fromStream40(stream);
    }

    public static long readStream48(ByteInputStream stream) throws Exception {
        return LittleEndianBuffer.fromStream48(stream);
    }

    public static long readStream56(ByteInputStream stream) throws Exception {
        return LittleEndianBuffer.fromStream56(stream);
    }

    public static long readStream64(ByteInputStream stream) throws Exception {
        return LittleEndianBuffer.fromStream64(stream);
    }

    public static int readStream8(ByteInputStream stream) {
        return LittleEndianBuffer.fromStream8(stream);
    }

    public static byte[] readStreamOpaque16(ByteInputStream stream) throws Exception {
        int length = LittleEndianBuffer.readStream16(stream);
        if (length < 0) {
            return null;
        }
        return LittleEndianBuffer.readStream(length, stream);
    }

    public static byte[] readStreamOpaque24(ByteInputStream stream) throws Exception {
        int length = LittleEndianBuffer.readStream24(stream);
        if (length < 0) {
            return null;
        }
        return LittleEndianBuffer.readStream(length, stream);
    }

    public static byte[] readStreamOpaque32(ByteInputStream stream) throws Exception {
        int length = (int)LittleEndianBuffer.readStream32(stream);
        if (length < 0) {
            return null;
        }
        return LittleEndianBuffer.readStream(length, stream);
    }

    public static byte[] readStreamOpaque8(ByteInputStream stream) {
        int length = LittleEndianBuffer.readStream8(stream);
        if (length < 0) {
            return null;
        }
        return LittleEndianBuffer.readStream(length, stream);
    }

    public static byte[] toBytes16(int value) {
        return Binary.toBytes16(value, true);
    }

    public static byte[] toBytes24(int value) {
        return Binary.toBytes24(value, true);
    }

    public static byte[] toBytes32(long value) {
        return Binary.toBytes32(value, true);
    }

    public static byte[] toBytes40(long value) {
        return Binary.toBytes40(value, true);
    }

    public static byte[] toBytes48(long value) {
        return Binary.toBytes48(value, true);
    }

    public static byte[] toBytes56(long value) {
        return Binary.toBytes56(value, true);
    }

    public static byte[] toBytes64(long value) {
        return Binary.toBytes64(value, true);
    }

    public static byte[] toBytes8(int value) {
        return new byte[]{(byte)value};
    }

    public static void writeBuffer(byte[] value, ByteCollection buffer) {
        buffer.addRange(value);
    }

    public static void writeBuffer16(int value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes16(value), buffer);
    }

    public static void writeBuffer24(int value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes24(value), buffer);
    }

    public static void writeBuffer32(long value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes32(value), buffer);
    }

    public static void writeBuffer40(long value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes40(value), buffer);
    }

    public static void writeBuffer48(long value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes48(value), buffer);
    }

    public static void writeBuffer56(long value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes56(value), buffer);
    }

    public static void writeBuffer64(long value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes64(value), buffer);
    }

    public static void writeBuffer8(int value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer(LittleEndianBuffer.toBytes8(value), buffer);
    }

    public static void writeBufferOpaque16(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer16(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque24(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer24(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque32(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer32(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque40(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer40(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque48(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer48(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque56(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer56(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque64(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer64(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeBufferOpaque8(byte[] value, ByteCollection buffer) {
        LittleEndianBuffer.writeBuffer8(ArrayExtensions.getLength(value), buffer);
        LittleEndianBuffer.writeBuffer(value, buffer);
    }

    public static void writeData(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData(byte[] value, int valueIndex, int valueLength, byte[] data, int offset, IntegerHolder offsetPlus) {
        BitAssistant.copy(value, valueIndex, data, offset, valueLength);
        offsetPlus.setValue(offset + valueLength);
    }

    public static void writeData(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(value, 0, ArrayExtensions.getLength(value), data, offset, offsetPlus);
    }

    public static void writeData(byte[] value, int valueIndex, int valueLength, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData(value, valueIndex, valueLength, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData16(int value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes16(value), data, offset, offsetPlus);
    }

    public static void writeData16(int value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData16(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData24(int value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData24(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData24(int value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes24(value), data, offset, offsetPlus);
    }

    public static void writeData32(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes32(value), data, offset, offsetPlus);
    }

    public static void writeData32(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData32(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData40(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData40(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData40(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes40(value), data, offset, offsetPlus);
    }

    public static void writeData48(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes48(value), data, offset, offsetPlus);
    }

    public static void writeData48(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData48(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData56(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes56(value), data, offset, offsetPlus);
    }

    public static void writeData56(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData56(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData64(long value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData64(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData64(long value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes64(value), data, offset, offsetPlus);
    }

    public static void writeData8(int value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeData8(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeData8(int value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData(LittleEndianBuffer.toBytes8(value), data, offset, offsetPlus);
    }

    public static void writeDataOpaque16(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque16(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque16(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData16(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque24(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData24(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque24(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque24(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque32(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData32(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque32(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque32(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque40(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData40(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque40(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque40(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque48(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData48(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque48(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque48(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque56(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData56(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque56(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque56(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque64(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque64(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeDataOpaque64(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData64(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque8(byte[] value, byte[] data, int offset, IntegerHolder offsetPlus) {
        LittleEndianBuffer.writeData8(ArrayExtensions.getLength(value), data, offset, offsetPlus);
        LittleEndianBuffer.writeData(value, data, offset, offsetPlus);
    }

    public static void writeDataOpaque8(byte[] value, byte[] data, int offset) {
        int offsetPlus = 0;
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        LittleEndianBuffer.writeDataOpaque8(value, data, offset, _var0);
        offsetPlus = _var0.getValue();
    }

    public static void writeStream(byte[] value, ByteOutputStream stream) {
        stream.writeBuffer(value);
    }

    public static void writeStream16(int value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes16(value), stream);
    }

    public static void writeStream24(int value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes24(value), stream);
    }

    public static void writeStream32(long value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes32(value), stream);
    }

    public static void writeStream40(long value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes40(value), stream);
    }

    public static void writeStream48(long value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes48(value), stream);
    }

    public static void writeStream56(long value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes56(value), stream);
    }

    public static void writeStream64(long value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes64(value), stream);
    }

    public static void writeStream8(int value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream(LittleEndianBuffer.toBytes8(value), stream);
    }

    public static void writeStreamOpaque16(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream16(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque24(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream24(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque32(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream32(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque40(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream40(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque48(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream48(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque56(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream56(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque64(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream64(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }

    public static void writeStreamOpaque8(byte[] value, ByteOutputStream stream) {
        LittleEndianBuffer.writeStream8(ArrayExtensions.getLength(value), stream);
        LittleEndianBuffer.writeStream(value, stream);
    }
}

