/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.NullableLong;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;

public class Audio
extends Element {
    private NullableLong _bitDepth = new NullableLong();
    private static byte[] _bitDepthId;
    private long _channels;
    private static byte[] _channelsId;
    private NullableLong _outputSamplingFrequency = new NullableLong();
    private static byte[] _outputSamplingFrequencyId;
    private long _samplingFrequency;
    private static byte[] _samplingFrequencyId;

    public Audio() {
        this.setSamplingFrequency(Audio.getDefaultSamplingFrequency());
        this.setChannels(Audio.getDefaultChannels());
    }

    public Audio(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _samplingFrequencyId)) {
                this.setSamplingFrequency(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _outputSamplingFrequencyId)) {
                this.setOutputSamplingFrequency(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _channelsId)) {
                this.setChannels(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _bitDepthId)) {
                this.setBitDepth(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaAudio: ", BitAssistant.getHexString(buffer)));
        }
    }

    public NullableLong getBitDepth() {
        return this._bitDepth;
    }

    public long getChannels() {
        return this._channels;
    }

    public static long getDefaultChannels() {
        return 1L;
    }

    public static long getDefaultSamplingFrequency() {
        return 8000L;
    }

    public static byte[] getEbmlId() {
        return new byte[]{-31};
    }

    @Override
    public byte[] getId() {
        return Audio.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (super.getWriteDefaultValues() || this.getSamplingFrequency() != Audio.getDefaultSamplingFrequency()) {
            super.writeUnsignedInteger(this.getSamplingFrequency(), _samplingFrequencyId, stream);
        }
        if (super.getWriteDefaultValues() || this.getOutputSamplingFrequency().getHasValue()) {
            if (super.getWriteDefaultValues() && !this.getOutputSamplingFrequency().getHasValue()) {
                this.setOutputSamplingFrequency(new NullableLong(this.getSamplingFrequency()));
            }
            super.writeUnsignedInteger(this.getOutputSamplingFrequency().getValue(), _outputSamplingFrequencyId, stream);
        }
        if (super.getWriteDefaultValues() || this.getChannels() != Audio.getDefaultChannels()) {
            super.writeUnsignedInteger(this.getChannels(), _channelsId, stream);
        }
        if (this.getBitDepth().getHasValue()) {
            super.writeUnsignedInteger(this.getBitDepth().getValue(), _bitDepthId, stream);
        }
        return stream.toArray();
    }

    public NullableLong getOutputSamplingFrequency() {
        return this._outputSamplingFrequency;
    }

    public long getSamplingFrequency() {
        return this._samplingFrequency;
    }

    public void setBitDepth(NullableLong value) {
        this._bitDepth = value;
    }

    public void setChannels(long value) {
        this._channels = value;
    }

    public void setOutputSamplingFrequency(NullableLong value) {
        this._outputSamplingFrequency = value;
    }

    public void setSamplingFrequency(long value) {
        this._samplingFrequency = value;
    }

    static {
        _samplingFrequencyId = new byte[]{-75};
        _outputSamplingFrequencyId = new byte[]{120, -75};
        _channelsId = new byte[]{-97};
        _bitDepthId = new byte[]{98, 100};
    }
}

