/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.JitterBuffer;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoBufferCollection;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;

public class JitterVideoPipe
extends VideoPipe {
    private JitterBuffer<VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat> _buffer;
    private IAction1<VideoFrame> _callback;

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoFrame frame2 = frame.clone();
        frame2.removeBuffers();
        frame2.addBuffer(inputBuffer.clone());
        ((VideoBuffer)frame2.getBuffer()).setSequenceNumber(((VideoBuffer)frame.getBuffer()).getSequenceNumber());
        ((VideoBuffer)frame2.getBuffer()).setDataBuffer(((VideoBuffer)frame.getBuffer()).getDataBuffer());
        this._buffer.push(frame2);
        this._buffer.pull(this._callback);
    }

    @Override
    public String getLabel() {
        return "Jitter Video Pipe";
    }

    public JitterVideoPipe(VideoFormat format, int length) {
        super(format, format);
        if (!format.getIsPacketized()) {
            throw new RuntimeException(new Exception("Format must be packetized."));
        }
        this._buffer = new JitterBuffer(this.getLabel(), ((VideoFormat)super.getInputFormat()).getClockRate(), length);
        this._callback = new IActionDelegate1<VideoFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.JitterVideoPipe.onPull";
            }

            @Override
            public void invoke(VideoFrame frame) {
                JitterVideoPipe.this.onPull(frame);
            }
        };
    }

    public JitterVideoPipe(VideoFormat format) {
        this(format, 100);
    }

    private void onPull(VideoFrame frame) {
        this.raiseFrame(frame);
    }
}

