/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IntegerHolder;
import fm.icelink.JsonSerializer;
import fm.icelink.ParseAssistant;
import fm.icelink.StringExtensions;
import java.util.HashMap;

public class Error {
    private ErrorCode _errorCode;
    private Exception _exception;

    public Error(ErrorCode errorCode) {
        this(errorCode, null);
    }

    public Error(ErrorCode errorCode, Exception exception) {
        this.setErrorCode(errorCode);
        this.setException(exception);
    }

    private Error() {
    }

    public static Error fromJson(String errorJson) {
        return JsonSerializer.deserializeObject(errorJson, new IFunction0<Error>(){

            @Override
            public Error invoke() {
                return new Error();
            }
        }, new IAction3<Error, String, String>(){

            @Override
            public void invoke(Error error, String name, String valueJson) {
                String str = name;
                if (str != null) {
                    if (!Global.equals(str, "errorCode")) {
                        if (Global.equals(str, "exception")) {
                            error.setException(new Exception(JsonSerializer.deserializeString(valueJson)));
                        }
                    } else {
                        int intResult = -1;
                        IntegerHolder _var0 = new IntegerHolder(intResult);
                        boolean _var1 = ParseAssistant.tryParseIntegerValue(valueJson, _var0);
                        intResult = _var0.getValue();
                        if (_var1) {
                            error.setErrorCode(ErrorCode.getByAssignedValue(intResult));
                        }
                    }
                }
            }
        });
    }

    public String getDescription() {
        String str = this.getErrorCode().toString();
        if (this.getException() != null) {
            str = StringExtensions.concat(str, " ", this.getException().getMessage());
        }
        return str;
    }

    public ErrorCode getErrorCode() {
        return this._errorCode;
    }

    public Exception getException() {
        return this._exception;
    }

    public void setErrorCode(ErrorCode value) {
        this._errorCode = value;
    }

    public void setException(Exception value) {
        this._exception = value;
    }

    public static String toJson(final Error error) {
        return JsonSerializer.serializeObject(error, new IAction2<Error, HashMap<String, String>>(){

            @Override
            public void invoke(Error e, HashMap<String, String> jsonObject) {
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "errorCode", JsonSerializer.serializeString(error.getErrorCode().toString()));
                if (error.getException() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "exception", JsonSerializer.serializeString(error.getException().getMessage()));
                }
            }
        });
    }

    public String toJson() {
        return Error.toJson(this);
    }

    public String toString() {
        return this.getDescription();
    }
}

