/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;

public class CircularBuffer {
    private boolean __allowRead = false;
    private DataBuffer __buffer;
    private int _latency;
    private boolean _littleEndian;
    private int _readOffset;
    private int _writeOffset;

    public CircularBuffer(int length, int latency, boolean littleEndian) {
        if (length <= 0) {
            throw new RuntimeException(new Exception("Cannot create a circular buffer with no length."));
        }
        this.__buffer = DataBuffer.allocate(length, littleEndian);
        this.setReadOffset(0);
        this.setWriteOffset(this.getLatency());
        this.setLatency(latency);
        this.setLittleEndian(littleEndian);
    }

    public CircularBuffer(int length, int latency) {
        this(length, latency, false);
    }

    public int getAvailable() {
        return this.getWriteOffset() - this.getReadOffset();
    }

    public int getLatency() {
        return this._latency;
    }

    public int getLength() {
        return this.__buffer.getLength();
    }

    public boolean getLittleEndian() {
        return this._littleEndian;
    }

    public int getReadOffset() {
        return this._readOffset;
    }

    public int getWriteOffset() {
        return this._writeOffset;
    }

    public DataBuffer read(int length) {
        if (length > this.getLength()) {
            return null;
        }
        DataBuffer buffer = DataBuffer.allocate(length, this.getLittleEndian());
        if (this.__allowRead) {
            if (this.getReadOffset() + length <= this.getLength()) {
                buffer.write(this.__buffer.subset(this.getReadOffset(), length), 0);
                this.__buffer.set((byte)0, this.getReadOffset(), length);
            } else {
                int num = this.__buffer.getLength() - this.getReadOffset();
                int num2 = length - num;
                buffer.write(this.__buffer.subset(this.getReadOffset(), num), 0);
                buffer.write(this.__buffer.subset(0, num2), num);
                this.__buffer.set((byte)0, this.getReadOffset(), num);
                this.__buffer.set((byte)0, 0, num2);
            }
            this.setReadOffset((this.getReadOffset() + length) % this.getLength());
        }
        return buffer;
    }

    private void setLatency(int value) {
        this._latency = value;
    }

    private void setLittleEndian(boolean value) {
        this._littleEndian = value;
    }

    private void setReadOffset(int value) {
        this._readOffset = value;
    }

    private void setWriteOffset(int value) {
        this._writeOffset = value;
    }

    public void write(DataBuffer buffer) {
        int length;
        for (int i = 0; i < buffer.getLength(); i += length) {
            length = 0;
            length = buffer.getLength() - i < this.getWriteOffset() + this.getLength() ? buffer.getLength() : this.getLength() - this.getWriteOffset();
            this.__buffer.write(buffer.subset(i, length), this.getWriteOffset());
            this.setWriteOffset((this.getWriteOffset() + length) % this.getLength());
        }
        if (!this.__allowRead && this.getWriteOffset() >= this.getReadOffset() + this.getLatency()) {
            this.__allowRead = true;
        }
    }
}

