/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.matroska.BlockFlags;
import fm.icelink.matroska.Element;

public class Block
extends Element {
    private byte[] _data;
    private byte _flags;
    private int _timecode;
    private long _trackNumber;

    public Block(byte[] bytes) {
        this();
        int offset = 0;
        IntegerHolder _var0 = new IntegerHolder(offset);
        long _var1 = Element.readVariableInteger(bytes, offset, _var0);
        offset = _var0.getValue();
        this.setTrackNumber(_var1);
        this.setTimecode(Binary.fromBytes16(bytes, offset, false));
        this.setFlags((byte)Binary.fromBytes8(bytes, offset += 2));
        if (++offset < ArrayExtensions.getLength(bytes)) {
            this.setData(BitAssistant.subArray(bytes, offset));
        }
    }

    public Block() {
    }

    public byte[] getData() {
        return this._data;
    }

    public static byte[] getEbmlId() {
        return new byte[]{-95};
    }

    public byte getFlags() {
        return this._flags;
    }

    @Override
    public byte[] getId() {
        return Block.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        if (this.getFlags() == BlockFlags.getEbmlLacing() || this.getFlags() == BlockFlags.getFixedSizeLacing() || this.getFlags() == BlockFlags.getXiphLacing()) {
            return null;
        }
        ByteOutputStream stream = new ByteOutputStream();
        super.writeVariableInteger(this.getTrackNumber(), stream);
        stream.writeBuffer(Binary.toBytes16(this.getTimecode(), false));
        stream.writeBuffer(Binary.toBytes8(this.getFlags()));
        if (this.getData() != null) {
            stream.writeBuffer(this.getData());
        }
        return stream.toArray();
    }

    public int getTimecode() {
        return this._timecode;
    }

    public long getTrackNumber() {
        return this._trackNumber;
    }

    public void setData(byte[] value) {
        this._data = value;
    }

    public void setFlags(byte value) {
        this._flags = value;
    }

    public void setTimecode(int value) {
        this._timecode = value;
    }

    public void setTrackNumber(long value) {
        this._trackNumber = value;
    }
}

