/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.X509AlgorithmIdentifier;
import fm.icelink.X509TbsCertificate;

class X509Certificate {
    private byte[] _signature;
    private X509AlgorithmIdentifier _signatureAlgorithm;
    private X509TbsCertificate _tbsCertificate;

    public static X509Certificate fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) != 3) {
            return null;
        }
        X509Certificate certificate = new X509Certificate();
        certificate.setTbsCertificate(X509TbsCertificate.fromAsn1(sequence.getValues()[0]));
        certificate.setSignatureAlgorithm(X509AlgorithmIdentifier.fromAsn1(sequence.getValues()[1]));
        certificate.setSignature(((Asn1BitString)sequence.getValues()[2]).getValueBytes());
        return certificate;
    }

    public byte[] getSignature() {
        return this._signature;
    }

    public X509AlgorithmIdentifier getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    public X509TbsCertificate getTbsCertificate() {
        return this._tbsCertificate;
    }

    public void setSignature(byte[] value) {
        this._signature = value;
    }

    public void setSignatureAlgorithm(X509AlgorithmIdentifier value) {
        this._signatureAlgorithm = value;
    }

    public void setTbsCertificate(X509TbsCertificate value) {
        this._tbsCertificate = value;
    }

    public Asn1Sequence toAsn1() {
        return new Asn1Sequence(new Asn1Any[]{this.getTbsCertificate().toAsn1(), this.getSignatureAlgorithm().toAsn1(), new Asn1BitString(this.getSignature())});
    }
}

