/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1BmpString;
import fm.icelink.Asn1PrintableString;
import fm.icelink.Asn1UniversalString;
import fm.icelink.Asn1Utf8String;
import fm.icelink.Global;

class X501DirectoryString {
    private String _value;

    public static X501DirectoryString fromAsn1(Asn1Any any) {
        Asn1Utf8String str = Global.tryCast(any, Asn1Utf8String.class);
        if (str != null) {
            return new X501DirectoryString(str.getValue());
        }
        Asn1PrintableString str2 = Global.tryCast(any, Asn1PrintableString.class);
        if (str2 != null) {
            return new X501DirectoryString(str2.getValue());
        }
        Asn1BmpString str3 = Global.tryCast(any, Asn1BmpString.class);
        if (str3 != null) {
            return new X501DirectoryString(str3.getValue());
        }
        Asn1UniversalString str4 = Global.tryCast(any, Asn1UniversalString.class);
        if (str4 != null) {
            return new X501DirectoryString(str4.getValue());
        }
        return null;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public Asn1Any toAsn1Bmp() {
        return new Asn1BmpString(this.getValue());
    }

    public Asn1Any toAsn1Printable() {
        return new Asn1PrintableString(this.getValue());
    }

    public Asn1Any toAsn1Universal() {
        return new Asn1UniversalString(this.getValue());
    }

    public Asn1Any toAsn1Utf8() {
        return new Asn1Utf8String(this.getValue());
    }

    public X501DirectoryString() {
    }

    public X501DirectoryString(String value) {
        this.setValue(value);
    }
}

