/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DateExtensions;
import java.util.Date;

class TurnPermission {
    private String _address;
    private Date _expires = new Date();

    public void extendTimeToExpiry() {
        this.setTimeToExpiry(86400);
    }

    public String getAddress() {
        return this._address;
    }

    public boolean getIsExpired() {
        return DateExtensions.getTicks(DateExtensions.getUtcNow()) > DateExtensions.getTicks(this._expires);
    }

    public int getTimeToExpiry() {
        return (int)((DateExtensions.getTicks(this._expires) - DateExtensions.getTicks(DateExtensions.getUtcNow())) / 10000000L);
    }

    private void setAddress(String value) {
        this._address = value;
    }

    private void setTimeToExpiry(int timeToExpiry) {
        this._expires = DateExtensions.addSeconds(DateExtensions.getUtcNow(), timeToExpiry);
    }

    public String toString() {
        return this.getAddress();
    }

    public TurnPermission(String address) {
        this.setAddress(address);
        this.extendTimeToExpiry();
    }
}

