/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.MathAssistant;
import fm.icelink.Platform;

public class Resampler {
    private static int _defaultLowPassOrder;
    private double _factor;
    private double _factorMax;
    private double _factorMin;
    private float[] _impulseResponse;
    private float[] _impulseResponseDeltas;
    private byte[] _input;
    private int _inputOffset;
    private int _inputPosition;
    private int _inputRead;
    private int _inputSize;
    private int _lowpassOrder;
    private float _lowpassScale;
    private byte[] _output;
    private int _outputPosition;
    private double _time;
    private int _wingLength;

    private int downsample(byte[] input, byte[] output, double factor, int inputPosition, int wingLength, float lowpassScale, float[] impulseResponse, float[] impulseResponseDeltas, boolean interpolate) {
        double time;
        byte[] sampleArray = input;
        int sampleIndex = 0;
        byte[] buffer2 = output;
        int index = 0;
        double num5 = 1.0 / factor;
        double samplingPeriod = MathAssistant.min(4096.0, factor * 4096.0);
        double num6 = time + (double)inputPosition;
        for (time = this._time; time < num6; time += num5) {
            double phase = time - MathAssistant.floor(time);
            double num8 = 1.0 - phase;
            sampleIndex = (int)time * 2;
            float num9 = Resampler.downsample(impulseResponse, impulseResponseDeltas, wingLength, interpolate, sampleArray, sampleIndex, phase, -2, samplingPeriod);
            num9 += Resampler.downsample(impulseResponse, impulseResponseDeltas, wingLength, interpolate, sampleArray, sampleIndex += 2, num8, 2, samplingPeriod);
            this.writePcmShort(Resampler.shortFromFloat(num9 *= lowpassScale), buffer2, index);
            index += 2;
        }
        this._time = time;
        return index;
    }

    private static float downsample(float[] impulseResponse, float[] impulseResponseDeltas, int wingLength, boolean interpolate, byte[] sampleArray, int sampleIndex, double phase, int increment, double samplingPeriod) {
        float num = 0.0f;
        double num2 = phase * samplingPeriod;
        int num3 = wingLength;
        if (increment == 2) {
            --num3;
            if (phase == 0.0) {
                num2 += samplingPeriod;
            }
        }
        float[] numArray = impulseResponse;
        int index = 0;
        if (interpolate) {
            float[] numArray2 = impulseResponseDeltas;
            int num5 = 0;
            index = (int)num2;
            while (index < num3) {
                float num6 = numArray[index];
                num5 = (int)num2;
                float num7 = (float)(num2 - MathAssistant.floor(num2));
                num6 += numArray2[num5] * num7;
                num += (num6 *= Resampler.floatFromShort(Resampler.readPcmShort(sampleArray, sampleIndex)));
                sampleIndex += increment;
                index = (int)(num2 += samplingPeriod);
            }
            return num;
        }
        index = (int)num2;
        while (index < num3) {
            float num6 = numArray[index];
            num += (num6 *= Resampler.floatFromShort(Resampler.readPcmShort(sampleArray, sampleIndex)));
            sampleIndex += increment;
            index = (int)(num2 += samplingPeriod);
        }
        return num;
    }

    private static float floatFromShort(short value) {
        float num = (float)value / 32768.0f;
        if (num > 1.0f) {
            num = 1.0f;
        }
        if (num < -1.0f) {
            num = -1.0f;
        }
        return num;
    }

    public static int getDefaultLowPassOrder() {
        return _defaultLowPassOrder;
    }

    public double getFactor() {
        return this._factor;
    }

    public int getOutputLength(DataBuffer input) {
        return (int)((double)input.getLength() * this.getFactor());
    }

    private static void lowpassFilter(double[] coefficients, int coefficientCount, double frequency, double beta, int order) {
        double num2;
        int num;
        coefficients[0] = 2.0 * frequency;
        for (num = 1; num < coefficientCount; ++num) {
            num2 = MathAssistant.getPi() * (double)num / (double)order;
            coefficients[num] = MathAssistant.sin(2.0 * num2 * frequency) / num2;
        }
        double num3 = 1.0 / Resampler.zero(beta);
        double num4 = 1.0 / (double)(coefficientCount - 1);
        for (num = 1; num < coefficientCount; ++num) {
            num2 = (double)num * num4;
            double num5 = 1.0 - num2 * num2;
            num5 = num5 < 0.0 ? 0.0 : num5;
            coefficients[num] = coefficients[num] * (Resampler.zero(beta * MathAssistant.sqrt(num5)) * num3);
        }
    }

    private static short readPcmShort(byte[] input, int index) {
        return (short)(input[index] & 0xFF | (input[index + 1] & 0xFF) << 8);
    }

    public boolean resample(DataBuffer input, DataBuffer output, boolean lastBatch) {
        if (output.getLength() != this.getOutputLength(input)) {
            throw new RuntimeException(new Exception("Invalid output length."));
        }
        int inputSampleIndex = input.getIndex() / 2;
        int inputSampleCount = input.getLength() / 2;
        int outputSampleIndex = output.getIndex() / 2;
        int outputSampleCount = output.getLength() / 2;
        return this.resample(input.getData(), inputSampleIndex, inputSampleCount, output.getData(), outputSampleIndex, outputSampleCount, lastBatch);
    }

    private boolean resample(byte[] input, int inputSampleIndex, int inputSampleCount, byte[] output, int outputSampleIndex, int outputSampleCount, boolean lastBatch) {
        int num10;
        int num9;
        int num8;
        double factor = this.getFactor();
        if (factor < this._factorMin || factor > this._factorMax) {
            throw new RuntimeException(new Exception("Factor must be between minimum and maximum factors."));
        }
        int num2 = inputSampleIndex;
        int num3 = outputSampleIndex;
        float[] impulseResponse = this._impulseResponse;
        float[] impulseResponseDeltas = this._impulseResponseDeltas;
        float lowpassScale = this._lowpassScale;
        int wingLength = this._wingLength;
        boolean interpolate = false;
        int num6 = 0;
        int num7 = 0;
        if (this._outputPosition != 0 && outputSampleCount - num7 > 0) {
            num8 = MathAssistant.min(outputSampleCount - num7, this._outputPosition);
            BitAssistant.copy(this._output, 0, output, num3 * 2, num8 * 2);
            num3 += num8;
            num7 += num8;
            for (num9 = 0; num9 < this._outputPosition - num8; ++num9) {
                for (num10 = 0; num10 < 2; ++num10) {
                    this._output[num9 * 2 + num10] = this._output[(num9 + num8) * 2 + num10];
                }
            }
            this._outputPosition -= num8;
        }
        if (this._outputPosition == 0) {
            if (factor < 1.0) {
                lowpassScale = (float)((double)lowpassScale * factor);
            }
            do {
                int num11;
                if ((num8 = this._inputSize - this._inputRead) >= inputSampleCount - num6) {
                    num8 = inputSampleCount - num6;
                }
                BitAssistant.copy(input, num2 * 2, this._input, this._inputRead * 2, num8 * 2);
                num2 += num8;
                this._inputRead += num8;
                if (lastBatch && (num6 += num8) == inputSampleCount) {
                    num11 = this._inputRead - this._inputOffset;
                    for (num9 = 0; num9 < this._inputOffset; ++num9) {
                        for (num10 = 0; num10 < 2; ++num10) {
                            this._input[(this._inputRead + num9) * 2 + num10] = 0;
                        }
                    }
                } else {
                    num11 = this._inputRead - 2 * this._inputOffset;
                }
                if (num11 <= 0) break;
                int num12 = factor >= 1.0 ? this.upsample(this._input, this._output, factor, num11, wingLength, lowpassScale, impulseResponse, impulseResponseDeltas, interpolate) / 2 : this.downsample(this._input, this._output, factor, num11, wingLength, lowpassScale, impulseResponse, impulseResponseDeltas, interpolate) / 2;
                this._time -= (double)num11;
                this._inputPosition += num11;
                int num13 = (int)this._time - this._inputOffset;
                if (num13 != 0) {
                    this._time -= (double)num13;
                    this._inputPosition += num13;
                }
                int num14 = this._inputRead - (this._inputPosition - this._inputOffset);
                for (num9 = 0; num9 < num14; ++num9) {
                    for (num10 = 0; num10 < 2; ++num10) {
                        this._input[num9 * 2 + num10] = this._input[(num9 + (this._inputPosition - this._inputOffset)) * 2 + num10];
                    }
                }
                this._inputRead = num14;
                this._inputPosition = this._inputOffset;
                this._outputPosition = num12;
                if (this._outputPosition == 0 || outputSampleCount - num7 <= 0) continue;
                num8 = MathAssistant.min(outputSampleCount - num7, this._outputPosition);
                BitAssistant.copy(this._output, 0, output, num3 * 2, num8 * 2);
                num3 += num8;
                num7 += num8;
                for (num9 = 0; num9 < this._outputPosition - num8; ++num9) {
                    for (num10 = 0; num10 < 2; ++num10) {
                        this._output[num9 * 2 + num10] = this._output[(num9 + num8) * 2 + num10];
                    }
                }
                this._outputPosition -= num8;
            } while (this._outputPosition == 0);
        }
        return num6 == inputSampleCount;
    }

    public boolean resample(DataBuffer input, DataBuffer output) {
        return this.resample(input, output, true);
    }

    public Resampler(double factor) {
        int num5;
        this.setFactor(factor);
        boolean flag = false;
        double num = factor;
        double num2 = factor;
        if (num <= 0.0 || num2 <= 0.0) {
            throw new RuntimeException(new Exception("Mininum and maximum factor must be positive."));
        }
        if (num2 < num) {
            throw new RuntimeException(new Exception("Mininum factor must be less than maximum factor."));
        }
        this._factorMin = num;
        this._factorMax = num2;
        this._lowpassOrder = Resampler.getDefaultLowPassOrder() > 0 ? Resampler.getDefaultLowPassOrder() : (flag ? 35 : (Platform.getInstance().getIsMobile() ? 5 : 11));
        this._lowpassScale = 1.0f;
        this._wingLength = 4096 * (this._lowpassOrder - 1) / 2;
        double num3 = 0.9;
        double beta = 6.0;
        double[] coefficients = new double[this._wingLength];
        Resampler.lowpassFilter(coefficients, this._wingLength, 0.5 * num3, beta, 4096);
        this._impulseResponse = new float[this._wingLength];
        this._impulseResponseDeltas = new float[this._wingLength];
        for (num5 = 0; num5 < this._wingLength; ++num5) {
            this._impulseResponse[num5] = (float)coefficients[num5];
        }
        for (num5 = 0; num5 < this._wingLength - 1; ++num5) {
            this._impulseResponseDeltas[num5] = this._impulseResponse[num5 + 1] - this._impulseResponse[num5];
        }
        this._impulseResponseDeltas[this._wingLength - 1] = -this._impulseResponse[this._wingLength - 1];
        int num6 = (int)((double)(this._lowpassOrder + 1) / 2.0 * MathAssistant.max(1.0, 1.0 / num) + 10.0);
        int num7 = (int)((double)(this._lowpassOrder + 1) / 2.0 * MathAssistant.max(1.0, 1.0 / num2) + 10.0);
        this._inputOffset = MathAssistant.max(num6, num7);
        this._inputSize = MathAssistant.max(2 * this._inputOffset + 10, 4096);
        this._input = new byte[(this._inputSize + this._inputOffset) * 2];
        this._inputPosition = this._inputOffset;
        this._inputRead = this._inputOffset;
        int num8 = (int)((double)this._inputSize * num2 + 2.0);
        this._output = new byte[num8 * 2];
        this._outputPosition = 0;
        this._time = this._inputOffset;
    }

    public Resampler(int sourceClockRate, int targetClockRate) {
        this((double)targetClockRate / (double)sourceClockRate);
    }

    public static void setDefaultLowPassOrder(int value) {
        _defaultLowPassOrder = value;
    }

    private void setFactor(double value) {
        this._factor = value;
    }

    private static short shortFromFloat(float value) {
        if ((value *= 32768.0f) > 32767.0f) {
            value = 32767.0f;
        }
        if (value < -32768.0f) {
            value = -32768.0f;
        }
        return (short)value;
    }

    private static float upsample(float[] impulseResponse, float[] impulseResponseDeltas, int wingLength, boolean interpolate, byte[] sampleArray, int sampleIndex, double phase, int increment) {
        double num = 0.0;
        float num2 = 0.0f;
        float[] numArray = impulseResponse;
        int index = (int)(phase *= 4096.0);
        int num4 = wingLength;
        float[] numArray2 = impulseResponseDeltas;
        int num5 = (int)phase;
        if (interpolate) {
            num = phase - MathAssistant.floor(phase);
        }
        if (increment == 2) {
            --num4;
            if (phase == 0.0) {
                index += 4096;
                num5 += 4096;
            }
        }
        if (!interpolate) {
            while (index < num4) {
                float num6 = numArray[index];
                num2 += (num6 *= Resampler.floatFromShort(Resampler.readPcmShort(sampleArray, sampleIndex)));
                index += 4096;
                sampleIndex += increment;
            }
            return num2;
        }
        while (index < num4) {
            float num6 = numArray[index];
            num6 += (float)((double)numArray2[num5] * num);
            num5 += 4096;
            num2 += (num6 *= Resampler.floatFromShort(Resampler.readPcmShort(sampleArray, sampleIndex)));
            index += 4096;
            sampleIndex += increment;
        }
        return num2;
    }

    private int upsample(byte[] input, byte[] output, double factor, int inputPosition, int wingLength, float lowPassScale, float[] impulseResponse, float[] impulseResponseDeltas, boolean interpolate) {
        double time;
        byte[] sampleArray = input;
        int sampleIndex = 0;
        byte[] buffer2 = output;
        int index = 0;
        double num4 = 1.0 / factor;
        double num5 = time + (double)inputPosition;
        for (time = this._time; time < num5; time += num4) {
            double phase = time - MathAssistant.floor(time);
            double num7 = 1.0 - phase;
            sampleIndex = (int)time * 2;
            float num8 = Resampler.upsample(impulseResponse, impulseResponseDeltas, wingLength, interpolate, sampleArray, sampleIndex, phase, -2);
            num8 += Resampler.upsample(impulseResponse, impulseResponseDeltas, wingLength, interpolate, sampleArray, sampleIndex += 2, num7, 2);
            this.writePcmShort(Resampler.shortFromFloat(num8 *= lowPassScale), buffer2, index);
            index += 2;
        }
        this._time = time;
        return index;
    }

    private void writePcmShort(short input, byte[] output, int index) {
        output[index] = (byte)(input & 0xFF);
        output[index + 1] = (byte)(input >> 8 & 0xFF);
    }

    private static double zero(double x) {
        double num = 1.0;
        double num2 = 1.0;
        int num3 = 1;
        double num4 = x / 2.0;
        double num5 = num4 / (double)num3;
        ++num3;
        num5 *= num5;
        num += (num2 *= num5);
        while (num2 >= 1.0E-21 * num) {
            num5 = num4 / (double)num3;
            ++num3;
            num5 *= num5;
            num += (num2 *= num5);
        }
        return num;
    }
}

